/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.range;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.range.DateTimeRange;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.range.TimeSpanRange;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.viewer.requestfromuser.StiDialogInfoRange;
import com.stimulsoft.viewer.requestfromuser.StiNewRequestFromUserDialogCreatingEventArgs;
import com.stimulsoft.viewer.requestfromuser.components.StiDateTimePicker;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestLabel;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.controls.StiRequestFromUserDropDownButton;
import com.stimulsoft.viewer.requestfromuser.range.IStiRangeItemControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;

public class StiRangeDateTimeItemControl
extends StiRequestPanel
implements IStiRangeItemControl {
    private static final long serialVersionUID = -6706183690815421537L;
    private StiDateTimePicker dateTimeFrom;
    private StiDateTimePicker dateTimeTo;
    private StiRequestLabel labelTo;
    private StiRequestLabel labelFrom;
    private StiRequestFromUserDropDownButton dropDownButton;
    private final boolean isDateTime;

    public StiRangeDateTimeItemControl(StiVariable variable, StiReport report) {
        Range range;
        this.setLayout(null);
        this.isDateTime = variable.getType() == StiSystemTypeEnum.SystemDateTime;
        this.initializeComponent();
        this.labelFrom.setText(StiLocalization.getValue((String)"PropertyMain", (String)"RangeFrom"));
        this.labelTo.setText(StiLocalization.getValue((String)"PropertyMain", (String)"RangeTo"));
        this.locateComponents();
        List list = null;
        ArrayList<StiDialogInfoRange> listRanges = new ArrayList<StiDialogInfoRange>();
        list = variable.getDialogInfoItems();
        for (StiVariableItem item : list) {
            listRanges.add(new StiDialogInfoRange(item));
        }
        this.dropDownButton.setListRanges(listRanges);
        this.dropDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = ((JComboBox)e.getSource()).getSelectedItem();
                StiRangeDateTimeItemControl.this.dropDownButtonItemChanged((StiDialogInfoRange)object);
            }
        });
        if (listRanges.size() == 0) {
            this.dropDownButton.setVisible(false);
        }
        this.dateTimeFrom.setEnabled(variable.getDialogInfo().getAllowUserValues());
        this.dateTimeTo.setEnabled(variable.getDialogInfo().getAllowUserValues());
        StiNewRequestFromUserDialogCreatingEventArgs arg = new StiNewRequestFromUserDialogCreatingEventArgs(variable, this.dateTimeTo.getWidth());
        this.dateTimeFrom.setWidth(arg.getWidth());
        this.dateTimeTo.setWidth(arg.getWidth());
        this.labelTo.setLeft(this.dateTimeFrom.getRight() + 2);
        this.dateTimeTo.setLeft(this.labelTo.getRight() + 2);
        if (this.dropDownButton.isVisible()) {
            this.dropDownButton.setLeft(this.dateTimeTo.getRight() + 3);
        }
        this.setWidth(this.dropDownButton.isVisible() ? this.dropDownButton.getRight() + 2 : this.dateTimeTo.getRight() + 2);
        Range range2 = range = report.getVariable(variable.getName()) instanceof Range ? (Range)report.getVariable(variable.getName()) : null;
        if (range != null) {
            if (this.isDateTime) {
                this.dateTimeFrom.setValue((StiDateTime)range.getFromObject());
                this.dateTimeTo.setValue((StiDateTime)range.getToObject());
            } else {
                this.dateTimeFrom.setValue(this.convertTimeSpanToDateTime(range.getFromObject()));
                this.dateTimeTo.setValue(this.convertTimeSpanToDateTime(range.getToObject()));
            }
        } else {
            String rangeString = (String)variable.getValueObject();
            if (StiValidationUtil.isNullOrEmpty((String)rangeString) || !rangeString.contains("<<|>>") || variable.getInitBy() == StiVariableInitBy.Expression) {
                // empty if block
            }
        }
        if (this.isDateTime) {
            switch (variable.getDialogInfo().getDateTimeType()) {
                case DateAndTime: {
                    this.dateTimeTo.setCustomFormat(StiDateUtil.DEFAULT_DATE_TIME_PATTERN);
                    this.dateTimeFrom.setCustomFormat(StiDateUtil.DEFAULT_DATE_TIME_PATTERN);
                    break;
                }
                case Date: {
                    this.dateTimeTo.setCustomFormat(StiDateUtil.DEFAULT_DATE_PATTERN);
                    this.dateTimeFrom.setCustomFormat(StiDateUtil.DEFAULT_DATE_PATTERN);
                    break;
                }
                case Time: {
                    this.dateTimeTo.setCustomFormat("HH:mm:ss");
                    this.dateTimeFrom.setCustomFormat("HH:mm:ss");
                }
            }
        } else {
            this.dateTimeTo.setCustomFormat("HH:mm:ss");
            this.dateTimeFrom.setCustomFormat("HH:mm:ss");
        }
    }

    @Override
    public Range getValue() {
        if (this.isDateTime) {
            return new DateTimeRange(this.dateTimeFrom.getValue(), this.dateTimeTo.getValue());
        }
        return new TimeSpanRange(this.dateTimeFrom.getValue().getTicks(), this.dateTimeTo.getValue().getTicks());
    }

    private void locateComponents() {
        this.dateTimeFrom.setLeft(this.labelFrom.getRight() + 4);
        this.labelTo.setLeft(this.dateTimeFrom.getRight() + 4);
        this.dateTimeTo.setLeft(this.labelTo.getRight() + 4);
        this.dropDownButton.setLeft(this.dateTimeTo.getRight() + 2);
        this.setWidth(this.dropDownButton.getRight() + 2);
    }

    private StiDateTime convertTimeSpanToDateTime(Object obj) {
        StiDateTime dataTime = new StiDateTime((StiTimeSpan)obj);
        return dataTime;
    }

    private void dropDownButtonItemChanged(StiDialogInfoRange range) {
        if (range != null) {
            if (this.isDateTime) {
                this.dateTimeFrom.setValue((Date)range.getFrom());
                this.dateTimeTo.setValue((Date)range.getTo());
            } else {
                this.dateTimeFrom.setValue(this.convertTimeSpanToDateTime(range.getFrom()));
                this.dateTimeTo.setValue(this.convertTimeSpanToDateTime(range.getTo()));
            }
        }
    }

    private void initializeComponent() {
        this.dateTimeTo = new StiDateTimePicker();
        this.dateTimeFrom = new StiDateTimePicker();
        this.labelTo = new StiRequestLabel("To");
        this.labelFrom = new StiRequestLabel("From");
        this.dropDownButton = new StiRequestFromUserDropDownButton();
        this.labelTo.setLocation(145, 4);
        this.labelTo.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.labelTo.setName("labelTo");
        this.labelTo.setSize(20, 13);
        this.labelFrom.setLocation(3, 4);
        this.labelFrom.setName("labelFrom");
        this.labelFrom.setSize(30, 13);
        this.dropDownButton.setHorizontalOffset(0);
        this.dropDownButton.setLocation(274, 0);
        this.dropDownButton.setName("dropDownButton");
        this.dropDownButton.setPopupHeight(200);
        this.dropDownButton.setPopupWidth(263);
        this.dropDownButton.setSize(20, 20);
        this.dateTimeFrom.setLocation(39, 0);
        this.dateTimeFrom.setName("dateTimeFrom");
        this.dateTimeFrom.setShowCheckBox(true);
        this.dateTimeFrom.setSize(180, 20);
        this.dateTimeTo.setLocation(218, 0);
        this.dateTimeTo.setName("dateTimeTo");
        this.dateTimeTo.setShowCheckBox(true);
        this.dateTimeTo.setSize(180, 20);
        this.add(this.labelFrom);
        this.add(this.dateTimeFrom);
        this.add(this.labelTo);
        this.add(this.dateTimeTo);
        this.add((Component)((Object)this.dropDownButton));
        this.setName("StiRangeDateTimeItemControl");
        this.setSize(405, 21);
    }
}

