/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.panels;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.viewer.controls.dialogs.StiFileChooser;
import com.stimulsoft.viewer.controls.visual.StiExportPopupMenu;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import com.stimulsoft.viewer.controls.visual.StiMultipageButton;
import com.stimulsoft.viewer.controls.visual.StiToggleFlatButton;
import com.stimulsoft.viewer.enums.StiViewState;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.events.StiViewerEventDispatcher;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.utils.StiTooltipUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JToolBar;

public class StiMainToolBar
extends JToolBar
implements StiViewEventable {
    private static final long serialVersionUID = -7010207668633833611L;
    private StiViewModel stiViewModel;
    private StiFlatButton buttonPrint;
    private StiFlatButton buttonOpen;
    private StiFlatButton buttonSave;
    private StiFlatButton buttonSaveEmail;
    private StiToggleFlatButton buttonBookmarks;
    private StiFlatButton buttonParameters;
    private StiToggleFlatButton buttonThumbs;
    private StiToggleFlatButton buttonFind;
    private StiFlatButton buttonFullScreen;
    private StiToggleFlatButton buttonZoomOnePage;
    private StiToggleFlatButton buttonZoomTwoPages;
    private StiToggleFlatButton buttonZoomPageWidth;
    private StiMultipageButton buttonZoomMultiplePages;
    private StiFlatButton buttonAbout;
    private StiExportPopupMenu exportPopupMenu;
    private StiViewerEventDispatcher eventDispatcher = new StiViewerEventDispatcher();

    public StiMainToolBar(StiViewModel stiViewModel) {
        this.stiViewModel = stiViewModel;
        this.setFloatable(false);
        this.buildComponent();
        this.exportPopupMenu = new StiExportPopupMenu(stiViewModel);
        this.bindEvents();
        this.enableControls(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
    }

    private void buildComponent() {
        String toolbarUrl = "http://www.stimulsoft.com/en/documentation/online/user-manual/index.html?viewing_reports_basic_toolbar_of_report_viewer.htm";
        this.buttonPrint = new StiFlatButton(StiLocalization.getHingValue((String)"FormViewer", (String)"Print"), StiResourceUtil.loadIcon((String)"/icons/ReportPrint.png"), StiTooltipUtil.formatTooltip("Print", "Print", "(Ctrl + P)"), 80, 128, toolbarUrl);
        this.add(this.buttonPrint);
        this.buttonOpen = new StiFlatButton(StiLocalization.getHingValue((String)"FormViewer", (String)"Open"), StiResourceUtil.loadIcon((String)"/icons/ReportOpen.png"), StiTooltipUtil.formatTooltip("Open", "Open", "(Ctrl + O)"), 79, 128, toolbarUrl);
        this.add(this.buttonOpen);
        this.buttonSave = new StiFlatButton(StiLocalization.getHingValue((String)"FormViewer", (String)"Save"), StiResourceUtil.loadIcon((String)"/icons/ReportSave.png"), StiTooltipUtil.formatTooltip("Save", "Save", ""), toolbarUrl);
        this.add(this.buttonSave);
        this.buttonSaveEmail = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/SendEMail.png"), StiTooltipUtil.formatTooltip("SendEMail", "SendEMail", ""), toolbarUrl);
        this.add(this.buttonSaveEmail);
        this.addSeparator();
        this.buttonBookmarks = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/Bookmarks.png"), StiTooltipUtil.formatTooltip("Bookmarks", "Bookmarks", "(Ctrl + B)"), 66, 128, toolbarUrl);
        this.add(this.buttonBookmarks);
        this.buttonParameters = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/Parameters.png"), StiTooltipUtil.formatTooltip("Parameters", "Parameters", "(Ctrl + Enter)"), 10, 128, toolbarUrl);
        this.add(this.buttonParameters);
        this.buttonParameters.setEnabled(false);
        this.buttonThumbs = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/Thumbs.png"), StiTooltipUtil.formatTooltip("Thumbnails", "Thumbnails", "(Ctrl + T)"), 84, 128, toolbarUrl);
        this.add(this.buttonThumbs);
        this.buttonThumbs.setSelected(true);
        this.addSeparator();
        this.buttonFind = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/Find.png"), StiTooltipUtil.formatTooltip("Find", "Find", "(Ctrl + F)"), 70, 128, toolbarUrl);
        this.add(this.buttonFind);
        this.addSeparator();
        this.buttonFullScreen = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/FullScreen.png"), StiTooltipUtil.formatTooltip("FullScreen", "FullScreen", "(F2)"), 113, 0, toolbarUrl);
        this.add(this.buttonFullScreen);
        this.buttonZoomOnePage = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/ZoomOnePage.png"), StiTooltipUtil.formatTooltip("ZoomOnePage", "ZoomOnePage", "(F3)"), 114, 0, toolbarUrl);
        this.add(this.buttonZoomOnePage);
        this.buttonZoomOnePage.setSelected(true);
        this.buttonZoomTwoPages = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/ZoomTwoPages.png"), StiTooltipUtil.formatTooltip("ZoomTwoPages", "ZoomTwoPages", "(F4)"), 115, 0, toolbarUrl);
        this.add(this.buttonZoomTwoPages);
        this.buttonZoomMultiplePages = new StiMultipageButton(null, StiResourceUtil.loadIcon((String)"/icons/ZoomMultiplePages.png"), StiTooltipUtil.formatTooltip("ZoomMultiplePages", "ViewModeMultiplePages", ""), this, toolbarUrl);
        this.add(this.buttonZoomMultiplePages);
        this.buttonZoomPageWidth = new StiToggleFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/ZoomPageWidth.png"), StiTooltipUtil.formatTooltip("ZoomPageWidth", "ZoomPageWidth", "(F5)"), 116, 0, toolbarUrl);
        this.add(this.buttonZoomPageWidth);
        this.add(Box.createHorizontalGlue());
    }

    private void bindEvents() {
        this.buttonZoomOnePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.zoomPages(StiViewState.ZoomOnePage);
            }
        });
        this.buttonZoomPageWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.zoomPages(StiViewState.ZoomPageWidth);
            }
        });
        this.buttonZoomTwoPages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.zoomPages(StiViewState.ZoomTwoPages);
            }
        });
        this.buttonOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiFileChooser stiFileChooser = new StiFileChooser(StiLocalization.getValue((String)"FormViewer", (String)"DocumentFile"), new String[]{".mdc", ".mrt"});
                int result = stiFileChooser.showDialog(StiMainToolBar.this.buttonOpen, StiLocalization.getValue((String)"Buttons", (String)"Open"));
                if (result == 0) {
                    StiMainToolBar.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("LoadDocumentFile", stiFileChooser.getSelectedFile()));
                }
            }
        });
        this.buttonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowFindPannel", StiMainToolBar.this.getButtonFind().isSelected()));
            }
        });
        this.buttonBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowBookmarkPannel", StiMainToolBar.this.getButtonBookmarks().isSelected()));
            }
        });
        this.buttonFullScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowFullScreen", true));
            }
        });
        this.buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("Print", true));
            }
        });
        this.buttonThumbs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowThumbnailPannel", StiMainToolBar.this.buttonThumbs.isSelected()));
            }
        });
        this.stiViewModel.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StiMainToolBar.this.enableControls(evt.getNewValue() != null);
            }
        });
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.exportPopupMenu.show(StiMainToolBar.this.buttonSave, 0, StiMainToolBar.this.buttonSave.getHeight(), false);
            }
        });
        this.buttonSaveEmail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMainToolBar.this.exportPopupMenu.show(StiMainToolBar.this.buttonSaveEmail, 0, StiMainToolBar.this.buttonSaveEmail.getHeight(), true);
            }
        });
    }

    private void zoomPages(StiViewState state) {
        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ChangeViewState", (Object)state));
    }

    private void enableControls(Boolean enabled) {
        this.buttonPrint.setEnabled(enabled);
        this.buttonSave.setEnabled(enabled);
        this.buttonBookmarks.setEnabled(enabled);
        this.buttonParameters.setEnabled(false);
        this.buttonThumbs.setEnabled(enabled);
        this.buttonFind.setEnabled(enabled);
        this.buttonFullScreen.setEnabled(enabled);
        this.buttonZoomOnePage.setEnabled(enabled);
        this.buttonZoomPageWidth.setEnabled(enabled);
        this.buttonZoomMultiplePages.setEnabled(enabled);
        this.buttonZoomTwoPages.setEnabled(enabled);
        this.buttonSaveEmail.setEnabled(enabled);
    }

    @Override
    public StiViewerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public StiToggleFlatButton getButtonFind() {
        return this.buttonFind;
    }

    public StiToggleFlatButton getButtonBookmarks() {
        return this.buttonBookmarks;
    }

    public StiToggleFlatButton getButtonZoomOnePage() {
        return this.buttonZoomOnePage;
    }

    public StiToggleFlatButton getButtonZoomTwoPages() {
        return this.buttonZoomTwoPages;
    }

    public StiToggleFlatButton getButtonZoomPageWidth() {
        return this.buttonZoomPageWidth;
    }

    public StiToggleFlatButton getButtonZoomMultiplePages() {
        return this.buttonZoomMultiplePages;
    }

    public StiToggleFlatButton getButtonThumbs() {
        return this.buttonThumbs;
    }
}

