/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiRtfExportSettings;
import com.stimulsoft.report.export.tools.StiRtfExportMode;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiBaseExportDialog;
import java.awt.HeadlessException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class StiRtfExportDialog
extends StiBaseExportDialog {
    private static final long serialVersionUID = 8504451915597681783L;
    protected JComboBox imageResolutionComboBox;
    protected JComboBox imageQualityComboBox;
    protected JComboBox exportModeComboBox;
    protected JCheckBox usePageCheckBox;
    protected JCheckBox removeEmptyCheckBox;

    private StiRtfExportDialog(JFrame parent, Boolean sendEmail, int curretPage) throws HeadlessException {
        super(parent, sendEmail, curretPage);
    }

    public static StiExportSettings showDialog(JFrame parent, Boolean sendEmail, int curretPage) {
        StiRtfExportDialog dialog = new StiRtfExportDialog(parent, sendEmail, curretPage);
        dialog.setVisible(true);
        return dialog.okResult ? dialog.getExportSettings() : null;
    }

    @Override
    protected void buildComponent() {
        super.buildComponent();
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageResolution")), "ImageResolution"), 0, 0, 1);
        this.imageResolutionComboBox = new JComboBox<String>(RTF_IMAGE_RESOLUTIONS);
        this.addC(this.imageResolutionComboBox, 1, 0, 1, 0.5);
        this.addC(new JLabel("dpi"), 2, 0, 1, 0.0);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageQuality")), "ImageQuality"), 0, 1, 1);
        this.imageQualityComboBox = new JComboBox<String>(IMAGE_QUALITY);
        this.addC(this.imageQualityComboBox, 1, 1, 1, 0.5);
        this.addC(new JLabel("%"), 2, 1, 1, 0.0);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ExportMode").replace(":", "")), "ExportModeRtf"), 0, 2, 1);
        this.exportModeComboBox = new JComboBox<String>(new String[]{StiLocalization.getValue((String)"Export", (String)"ExportModeFrame"), StiLocalization.getValue((String)"Export", (String)"ExportModeTable")});
        this.addC(this.exportModeComboBox, 1, 2, 2, 0.0);
        this.usePageCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"UsePageHeadersAndFooters"));
        this.addC(this.addInfo(this.usePageCheckBox, "UsePageHeadersAndFooters"), 0, 3, 2, 0.5, -1);
        this.removeEmptyCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"RemoveEmptySpaceAtBottom"));
        this.addC(this.addInfo(this.removeEmptyCheckBox, "RemoveEmptySpaceAtBottom"), 0, 4, 2, 0.5, -1);
        this.expandPanel.setWidth(360);
        this.expandPanel.setExpandedHeight(190);
        this.bindEvents();
        this.loadSettings();
    }

    protected void bindEvents() {
        this.exportModeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = ((JComboBox)e.getSource()).getSelectedIndex() == 0;
                StiRtfExportDialog.this.usePageCheckBox.setEnabled(selected);
                StiRtfExportDialog.this.removeEmptyCheckBox.setEnabled(selected);
            }
        });
    }

    @Override
    protected StiExportSettings getExportSettings() {
        StiRtfExportSettings settings = new StiRtfExportSettings(super.getExportSettings());
        settings.setExportMode(this.exportModeComboBox.getSelectedIndex() == 1 ? StiRtfExportMode.Table : StiRtfExportMode.Frame);
        settings.setImageQuality((float)(Integer.parseInt((String)this.imageQualityComboBox.getSelectedItem()) / 100));
        int imageResolution = 75;
        try {
            imageResolution = Integer.parseInt(((String)this.imageResolutionComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
        }
        catch (Exception e) {
            System.out.println("Unable to parse Image Resulution value: " + this.imageResolutionComboBox.getSelectedItem());
            e.printStackTrace();
        }
        settings.setImageResolution((float)imageResolution);
        settings.setRemoveEmptySpaceAtBottom(this.removeEmptyCheckBox.isSelected());
        settings.setUsePageHeadersAndFooters(this.usePageCheckBox.isSelected());
        return settings;
    }

    private void loadSettings() {
        this.selectStringCombo(this.imageResolutionComboBox, StiSettings.getStringValue((String)"Export", (String)"RtfImageResolution", (String)"100"));
        this.exportModeComboBox.setSelectedIndex(StiSettings.getIntValue((String)"Export", (String)"RtfExportModeTable", (Integer)0));
        this.selectStringCombo(this.imageQualityComboBox, StiSettings.getStringValue((String)"Export", (String)"RtfImageQuality", (String)"100"));
        this.usePageCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"RtfUsePageHaaders", (Boolean)true));
        this.removeEmptyCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"RtfRemoveEmptySpace", (Boolean)true));
        this.expandPanel.setExpanded(StiSettings.getBoolValue((String)"Export", (String)"RtfSettingsPanelExpanded", (Boolean)false));
        this.openAfterExport.setSelected(StiSettings.getBoolValue((String)"Export", (String)"RtfOpenAfterExport", (Boolean)true));
    }

    @Override
    protected void saveSettings() {
        StiSettings.setStringValue((String)"Export", (String)"RtfImageResolution", (String)((String)this.imageResolutionComboBox.getSelectedItem()));
        StiSettings.setStringValue((String)"Export", (String)"RtfImageQuality", (String)((String)this.imageQualityComboBox.getSelectedItem()));
        StiSettings.setIntValue((String)"Export", (String)"RtfExportModeTable", (Integer)this.exportModeComboBox.getSelectedIndex());
        StiSettings.setBoolValue((String)"Export", (String)"RtfUsePageHaaders", (Boolean)this.usePageCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"RtfRemoveEmptySpace", (Boolean)this.removeEmptyCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"RtfSettingsPanelExpanded", (Boolean)this.expandPanel.getExpanded());
        StiSettings.setBoolValue((String)"Export", (String)"RtfOpenAfterExport", (Boolean)this.openAfterExport.isSelected());
    }
}

