/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.report.export.settings.StiBmpExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiJpegExportSettings;
import com.stimulsoft.report.export.settings.StiPcxExportSettings;
import com.stimulsoft.report.export.settings.StiPngExportSettings;
import com.stimulsoft.report.export.settings.StiSvgExportSettings;
import com.stimulsoft.report.export.settings.StiSvgzExportSettings;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiBaseExportDialog;
import java.awt.HeadlessException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class StiImageExportDialog
extends StiBaseExportDialog {
    private static final long serialVersionUID = 8504451915597681783L;
    private static String[] DITHERING_TYPES = new String[]{"None", "FloydSteinberg", "Ordered"};
    protected JComboBox zoomComboBox;
    protected JComboBox typeComboBox;
    protected JComboBox imageResolutionComboBox;
    protected JComboBox imageTypeComboBox;
    protected JCheckBox cutEdgesCheckBox;
    protected JComboBox ditheringTypeComboBox;
    protected JComboBox tiffCompressionComboBox;
    protected JLabel ditheringTypeLabel;

    private StiImageExportDialog(JFrame parent, Boolean sendEmail, int curretPage) throws HeadlessException {
        super(parent, sendEmail, curretPage);
    }

    public static StiExportSettings showDialog(JFrame parent, Boolean sendEmail, int curretPage) {
        StiImageExportDialog dialog = new StiImageExportDialog(parent, sendEmail, curretPage);
        dialog.setVisible(true);
        return dialog.okResult ? dialog.getExportSettings() : null;
    }

    @Override
    protected void buildComponent() {
        super.buildComponent();
        this.addC(this.addInfo(new StiLabel("Type:"), "TypeExport"), 0, 0, 1);
        this.typeComboBox = new JComboBox<String>(new String[]{"BMP", "JPEG", "PCX", "PNG", "SVG", "SVGZ"});
        this.addC(this.typeComboBox, 1, 0, 2, 0.0);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"Scale")), "ScaleImage"), 0, 1, 1);
        this.zoomComboBox = new JComboBox<String>(ZOOM_VALUES);
        this.addC(this.zoomComboBox, 1, 1, 2);
        this.zoomComboBox.setEditable(true);
        this.zoomComboBox.setSelectedIndex(3);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageResolution")), "ImageResolution"), 0, 2, 1);
        this.imageResolutionComboBox = new JComboBox<String>(RTF_IMAGE_RESOLUTIONS);
        this.addC(this.imageResolutionComboBox, 1, 2, 1, 0.5);
        this.addC(new JLabel("dpi"), 2, 2, 1, 0.0);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageType")), "ImageType"), 0, 3, 1);
        this.imageTypeComboBox = new JComboBox<String>(new String[]{StiLocalization.getValue((String)"Export", (String)"Color"), StiLocalization.getValue((String)"Export", (String)"ImageGrayscale"), StiLocalization.getValue((String)"Export", (String)"ImageMonochrome")});
        this.addC(this.imageTypeComboBox, 1, 3, 2);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"MonochromeDitheringType")), "DitheringType"), 0, 4, 1);
        this.ditheringTypeComboBox = new JComboBox<String>(DITHERING_TYPES);
        this.addC(this.ditheringTypeComboBox, 1, 4, 2);
        this.ditheringTypeComboBox.setEnabled(false);
        this.cutEdgesCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"ImageCutEdges"));
        this.addC(this.addInfo(this.cutEdgesCheckBox, "CutEdges"), 0, 5, 3, 0.5, -1);
        this.expandPanel.setWidth(360);
        this.expandPanel.setExpandedHeight(210);
        this.bindEvents();
        this.loadSettings();
    }

    protected void bindEvents() {
        this.imageTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = StiImageExportDialog.this.imageTypeComboBox.getSelectedIndex() == 2;
                if (StiImageExportDialog.this.typeComboBox.getSelectedIndex() >= 4 && selected) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StiImageExportDialog.this.imageTypeComboBox.setSelectedIndex(1);
                        }
                    });
                }
                StiImageExportDialog.this.ditheringTypeComboBox.setEnabled(selected);
            }
        });
        if (this.typeComboBox.getSelectedIndex() >= 4 && this.imageTypeComboBox.getSelectedIndex() == 2) {
            this.imageTypeComboBox.setSelectedIndex(1);
        }
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (StiImageExportDialog.this.typeComboBox.getSelectedIndex() >= 4 && StiImageExportDialog.this.imageTypeComboBox.getSelectedIndex() == 2) {
                    StiImageExportDialog.this.imageTypeComboBox.setSelectedIndex(1);
                }
            }
        });
    }

    @Override
    protected StiExportSettings getExportSettings() {
        StiBmpExportSettings settings = null;
        switch (this.typeComboBox.getSelectedIndex()) {
            case 0: {
                settings = new StiBmpExportSettings(super.getExportSettings());
                break;
            }
            case 1: {
                settings = new StiJpegExportSettings(super.getExportSettings());
                break;
            }
            case 3: {
                settings = new StiPngExportSettings(super.getExportSettings());
                break;
            }
            case 4: {
                settings = new StiSvgExportSettings(super.getExportSettings());
                break;
            }
            case 5: {
                settings = new StiSvgzExportSettings(super.getExportSettings());
                break;
            }
            case 2: {
                settings = new StiPcxExportSettings(super.getExportSettings());
            }
        }
        settings.setCutEdges(this.cutEdgesCheckBox.isSelected());
        int ditheringIndex = this.ditheringTypeComboBox.getSelectedIndex();
        settings.setDitheringType(ditheringIndex == 0 ? StiMonochromeDitheringType.None : (ditheringIndex == 1 ? StiMonochromeDitheringType.FloydSteinberg : StiMonochromeDitheringType.Ordered));
        switch (this.imageTypeComboBox.getSelectedIndex()) {
            case 0: {
                settings.setImageFormat(StiColorImageFormat.Color);
                break;
            }
            case 1: {
                settings.setImageFormat(StiColorImageFormat.Grayscale);
                break;
            }
            case 2: {
                settings.setImageFormat(StiColorImageFormat.Monochrome);
            }
        }
        int imageResolution = 75;
        try {
            imageResolution = Integer.parseInt(((String)this.imageResolutionComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
        }
        catch (Exception e) {
            System.out.println("Unable to parse Image Resulution value: " + this.imageResolutionComboBox.getSelectedItem());
            e.printStackTrace();
        }
        settings.setImageResolution(imageResolution);
        Double zoom = 100.0;
        try {
            zoom = Double.parseDouble(((String)this.zoomComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
        }
        catch (Exception e) {
            System.out.println("Unable to parse zoom value: " + this.zoomComboBox.getSelectedItem());
            e.printStackTrace();
        }
        settings.setImageZoom(zoom / 100.0);
        return settings;
    }

    private void loadSettings() {
        int storedZoom = StiSettings.getDoubleValue((String)"Export", (String)"ImageZoom", (Double)100.0).intValue();
        if (!this.selectStringCombo(this.zoomComboBox, storedZoom + "%")) {
            this.zoomComboBox.setSelectedItem(String.valueOf(storedZoom));
        }
        Integer resolution = StiSettings.getIntValue((String)"Export", (String)"ImageResolution", (Integer)100);
        this.imageResolutionComboBox.setSelectedItem(resolution.toString());
        this.ditheringTypeComboBox.setSelectedIndex(StiSettings.getIntValue((String)"Export", (String)"ImageDitheringType", (Integer)0));
        this.cutEdgesCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"ImageCutEnges", (Boolean)false));
        this.imageTypeComboBox.setSelectedIndex(StiSettings.getIntValue((String)"Export", (String)"ImageColor", (Integer)0));
        this.typeComboBox.setSelectedIndex(StiSettings.getIntValue((String)"Export", (String)"ImageType", (Integer)0));
        this.expandPanel.setExpanded(StiSettings.getBoolValue((String)"Export", (String)"ImageSettingsPanelExpanded", (Boolean)false));
        this.openAfterExport.setSelected(StiSettings.getBoolValue((String)"Export", (String)"ImageOpenAfterExport", (Boolean)true));
    }

    @Override
    protected void saveSettings() {
        try {
            double zoom = Double.parseDouble(((String)this.zoomComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
            StiSettings.setDoubleValue((String)"Export", (String)"ImageZoom", (Double)zoom);
        }
        catch (Exception zoom) {
            // empty catch block
        }
        try {
            Integer resolution = Integer.parseInt(((String)this.imageResolutionComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
            StiSettings.setIntValue((String)"Export", (String)"ImageResolution", (Integer)resolution);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StiSettings.setIntValue((String)"Export", (String)"ImageDitheringType", (Integer)this.ditheringTypeComboBox.getSelectedIndex());
        StiSettings.setBoolValue((String)"Export", (String)"ImageCutEnges", (Boolean)this.cutEdgesCheckBox.isSelected());
        StiSettings.setIntValue((String)"Export", (String)"ImageColor", (Integer)this.imageTypeComboBox.getSelectedIndex());
        StiSettings.setIntValue((String)"Export", (String)"ImageType", (Integer)this.typeComboBox.getSelectedIndex());
        StiSettings.setBoolValue((String)"Export", (String)"ImageSettingsPanelExpanded", (Boolean)this.expandPanel.getExpanded());
        StiSettings.setBoolValue((String)"Export", (String)"ImageOpenAfterExport", (Boolean)this.openAfterExport.isSelected());
    }
}

