/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.utils.StiResourceUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class StiExpandPanel
extends JPanel {
    private static final long serialVersionUID = -8557498791273213597L;
    private ImageIcon expandedIcon = StiResourceUtil.loadIcon((String)"/icons/Expand.png");
    private ImageIcon collapsedIcon = StiResourceUtil.loadIcon((String)"/icons/Collapse.png");
    private Boolean expanded = false;
    private Dimension collapsedDimension = new Dimension(300, 21);
    private Dimension expandedDimension = new Dimension(300, 130);

    public StiExpandPanel(String caption) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "     " + caption));
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(this.collapsedDimension);
        this.setPreferredSize(this.collapsedDimension);
        this.setMinimumSize(this.collapsedDimension);
        this.setMaximumSize(this.collapsedDimension);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getY() < 20) {
                    StiExpandPanel.this.setExpanded(StiExpandPanel.this.expanded == false);
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.expanded != false ? this.collapsedIcon.getImage() : this.expandedIcon.getImage(), 9, 4, this);
    }

    public Boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(Boolean expanded) {
        this.expanded = expanded;
        this.setSize(expanded != false ? this.expandedDimension : this.collapsedDimension);
        this.setPreferredSize(expanded != false ? this.expandedDimension : this.collapsedDimension);
        this.setMinimumSize(expanded != false ? this.expandedDimension : this.collapsedDimension);
        this.setMaximumSize(expanded != false ? this.expandedDimension : this.collapsedDimension);
        for (int i = 0; i < this.getComponents().length; ++i) {
            this.getComponent(i).setVisible(expanded);
        }
    }

    public void setWidth(int width) {
        this.expandedDimension.width = width;
        this.collapsedDimension.width = width;
    }

    public void setExpandedHeight(int height) {
        this.expandedDimension.height = height;
    }

    public void setCollapsedHeight(int height) {
        this.collapsedDimension.height = height;
    }
}

