/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form;

import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.exception.StiPopupTextArea;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.mail.StiMailProperties;
import com.stimulsoft.base.mail.StiMailSender;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.viewer.utils.StiViewSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiMailSenderDialog
extends JDialog
implements StiViewSettings {
    private static final long serialVersionUID = -1240319509073281561L;
    private static final int PANEL_WIDTH = 800;
    private static final int P3_WIDTH = 261;
    private JTextField fromTextField;
    private JTextField hostTextField;
    private JFormattedTextField portTextField;
    private JTextField userTextField;
    private JPasswordField passwordTextField;
    private JTextField recipientsTextField;
    private JTextField subjectTextField;
    private StiPopupTextArea bodyPane;
    private JButton sendButton;
    private JButton closeButton;
    private JCheckBox authCheckBox;
    private JCheckBox sslCheckBox;
    private StiMailProperties mailProperties;
    private JLabel sendingLabel;
    private JProgressBar sendingProgressBar;
    private Frame owner;
    private JLabel fromLabel;
    private JLabel hostLabel;
    private JLabel smtpPortLabel;
    private JLabel userLabel;
    private JLabel passwordLabel;
    private JLabel recipientsLabel;
    private JLabel subjectLabel;
    private JLabel bodyLabel;

    public StiMailSenderDialog(StiMailProperties properties, Frame owner) {
        super(owner, StiLocalization.getValue((String)"Mail", (String)"SendMailCaption"), true);
        this.owner = owner;
        this.mailProperties = properties;
        this.buildComponent();
        this.setDefaultCloseOperation(2);
        this.setSize(800, 415);
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.bindEvents();
        this.loadSettings();
        this.subjectTextField.setText(properties.getSubject());
        this.bodyPane.setText(properties.getBody());
    }

    private void buildComponent() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        NumberFormat portFormat = NumberFormat.getIntegerInstance();
        portFormat.setGroupingUsed(false);
        portFormat.setParseIntegerOnly(true);
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new BoxLayout(settingsPanel, 1));
        settingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StiLocalization.getValue((String)"Mail", (String)"SMTPSettings")));
        JPanel fromHostPanel = new JPanel();
        fromHostPanel.setMaximumSize(new Dimension(800, 25));
        fromHostPanel.setLayout(new BoxLayout(fromHostPanel, 0));
        fromHostPanel.setAlignmentX(0.0f);
        this.fromLabel = this.borderLabel(new JLabel(StiLocalization.getValue((String)"Mail", (String)"From")), 1, 3);
        this.fromTextField = new JTextField();
        fromHostPanel.add(this.createPanel(this.fromTextField, this.fromLabel, 261, 75));
        this.fromLabel.setMaximumSize(new Dimension(45, 22));
        this.fromTextField.setMaximumSize(new Dimension(211, 22));
        this.hostLabel = this.borderLabel(new JLabel(StiLocalization.getValue((String)"Mail", (String)"SMTPHost")), 0, 3);
        this.hostTextField = new JTextField();
        fromHostPanel.add(this.createPanel(this.hostTextField, this.hostLabel, 261, 75));
        this.smtpPortLabel = this.borderLabel(new JLabel(StiLocalization.getValue((String)"Mail", (String)"SMTPPort")), 0, 3);
        this.portTextField = new JFormattedTextField(portFormat);
        fromHostPanel.add(this.createPanel(this.portTextField, this.smtpPortLabel, 261, 75));
        this.smtpPortLabel.setLabelFor(this.portTextField);
        settingsPanel.add(fromHostPanel);
        JPanel authPanel = new JPanel();
        authPanel.setLayout(new BoxLayout(authPanel, 0));
        authPanel.setAlignmentX(0.0f);
        authPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.authCheckBox = new JCheckBox(StiLocalization.getValue((String)"Mail", (String)"SMTPNeedAuth"));
        this.authCheckBox.setSelected(true);
        this.authCheckBox.setMaximumSize(new Dimension(261, 22));
        this.authCheckBox.setHorizontalTextPosition(2);
        authPanel.add(this.authCheckBox);
        this.userLabel = this.borderLabel(new JLabel(StiLocalization.getValue((String)"Mail", (String)"User")), 0, 3);
        this.userTextField = new JTextField();
        authPanel.add(this.createPanel(this.userTextField, this.userLabel, 261, 75));
        this.passwordLabel = this.borderLabel(new JLabel(StiLocalization.getValue((String)"Mail", (String)"Password")), 0, 3);
        this.passwordTextField = new JPasswordField();
        authPanel.add(this.createPanel(this.passwordTextField, this.passwordLabel, 261, 75));
        settingsPanel.add(authPanel);
        JPanel sslPanel = new JPanel();
        sslPanel.setLayout(new BoxLayout(sslPanel, 0));
        sslPanel.setAlignmentX(0.0f);
        sslPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.sslCheckBox = new JCheckBox(StiLocalization.getValue((String)"Mail", (String)"UseSSL"));
        this.sslCheckBox.setMaximumSize(new Dimension(260, 22));
        this.sslCheckBox.setSelected(true);
        this.sslCheckBox.setHorizontalTextPosition(2);
        sslPanel.add(this.sslCheckBox);
        settingsPanel.add(sslPanel);
        this.add(settingsPanel);
        JPanel mailPanel = new JPanel();
        mailPanel.setLayout(new BoxLayout(mailPanel, 1));
        mailPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StiLocalization.getValue((String)"Mail", (String)"Mail")));
        this.recipientsTextField = new JTextField();
        this.recipientsLabel = this.borderLabel(new JLabel(StiLocalization.getValue((String)"Mail", (String)"Recipients")), 0, 3);
        mailPanel.add(this.createPanel(this.recipientsTextField, this.recipientsLabel, 780, 80));
        this.subjectTextField = new JTextField();
        this.subjectLabel = this.borderLabel(new JLabel(StiLocalization.getValue((String)"Mail", (String)"Subject")), 0, 3);
        JPanel subjPanel = this.createPanel(this.subjectTextField, this.subjectLabel, 780, 80);
        mailPanel.add(subjPanel);
        subjPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 0));
        this.bodyLabel = new JLabel(StiLocalization.getValue((String)"Mail", (String)"Body"));
        mailPanel.add(this.borderLabel(this.bodyLabel, 2, 0));
        JPanel bPanel = new JPanel();
        bPanel.setLayout(null);
        this.bodyPane = new StiPopupTextArea();
        this.bodyPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.bodyPane.setWrapStyleWord(true);
        this.bodyPane.setLineWrap(true);
        JScrollPane bodyScrollPane = new JScrollPane((Component)this.bodyPane);
        bodyScrollPane.setBounds(2, 0, 774, 150);
        bPanel.add(bodyScrollPane);
        mailPanel.add(bPanel);
        Dimension bodyDescrSize = new Dimension(780, 240);
        bodyScrollPane.setMaximumSize(bodyDescrSize);
        bodyScrollPane.setMinimumSize(bodyDescrSize);
        this.add(mailPanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.setAlignmentX(0.0f);
        buttonsPanel.setMaximumSize(new Dimension(800, 34));
        buttonsPanel.setPreferredSize(new Dimension(785, 34));
        this.sendButton = new JButton(StiLocalization.getValue((String)"Mail", (String)"SendEmail"));
        this.closeButton = new JButton(StiLocalization.getValue((String)"Buttons", (String)"Close"));
        this.sendingLabel = new JLabel(StiLocalization.getValue((String)"Mail", (String)"Sending"));
        this.sendingLabel.setMaximumSize(new Dimension(80, 22));
        this.sendingLabel.setVisible(false);
        this.sendingLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 15));
        buttonsPanel.add(this.sendingLabel);
        this.sendingProgressBar = new JProgressBar();
        this.sendingProgressBar.setIndeterminate(true);
        this.sendingProgressBar.setVisible(false);
        this.sendingProgressBar.setPreferredSize(new Dimension(800, 14));
        buttonsPanel.add(this.sendingProgressBar);
        buttonsPanel.add(Box.createHorizontalStrut(20));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(this.closeButton);
        buttonsPanel.add(Box.createHorizontalStrut(5));
        buttonsPanel.add(this.sendButton);
        buttonsPanel.add(Box.createHorizontalStrut(14));
        this.add(buttonsPanel);
    }

    private JPanel createPanel(JTextField field, JLabel label, int width, int labelWidth) {
        JPanel panel = new JPanel();
        panel.setMaximumSize(new Dimension(width, 25));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(0.0f);
        panel.add(label);
        panel.add(field);
        label.setHorizontalAlignment(2);
        label.setMaximumSize(new Dimension(labelWidth, 22));
        field.setMaximumSize(new Dimension(width - labelWidth - 5, 22));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        return panel;
    }

    private JLabel borderLabel(JLabel label, int paddingLeft, int paddingRight) {
        label.setBorder(BorderFactory.createEmptyBorder(0, paddingLeft, 0, paddingRight));
        return label;
    }

    private void bindEvents() {
        this.authCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Boolean enabled = ((JCheckBox)e.getSource()).isSelected();
                StiMailSenderDialog.this.userTextField.setEnabled(enabled);
                StiMailSenderDialog.this.passwordTextField.setEnabled(enabled);
                StiMailSenderDialog.this.userLabel.setEnabled(enabled);
                StiMailSenderDialog.this.passwordLabel.setEnabled(enabled);
                if (enabled.booleanValue() && StiValidationUtil.isNotNullOrEmpty((String)StiMailSenderDialog.this.fromTextField.getText()) && StiValidationUtil.isNullOrEmpty((String)StiMailSenderDialog.this.userTextField.getText())) {
                    StiMailSenderDialog.this.userTextField.setText(StiMailSenderDialog.this.fromTextField.getText());
                }
            }
        });
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMailSenderDialog.this.sendEmail();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMailSenderDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                StiMailSenderDialog.this.saveSettings();
            }
        });
    }

    private void loadSettings() {
        this.fromTextField.setText(StiSettings.getStringValue((String)"viewer", (String)"MailFrom", (String)""));
        this.hostTextField.setText(StiSettings.getStringValue((String)"viewer", (String)"MailHost", (String)""));
        this.portTextField.setText(StiSettings.getStringValue((String)"viewer", (String)"MailPort", (String)""));
        this.userTextField.setText(StiSettings.getStringValue((String)"viewer", (String)"MailUser", (String)""));
        this.authCheckBox.setSelected(StiSettings.getBoolValue((String)"viewer", (String)"MailNeedAuth", (Boolean)false));
        this.sslCheckBox.setSelected(StiSettings.getBoolValue((String)"viewer", (String)"MailUseSSL", (Boolean)false));
        this.recipientsTextField.setText(StiSettings.getStringValue((String)"viewer", (String)"MailRecipients", (String)""));
    }

    private void saveSettings() {
        StiSettings.setStringValue((String)"viewer", (String)"MailFrom", (String)this.fromTextField.getText());
        StiSettings.setStringValue((String)"viewer", (String)"MailHost", (String)this.hostTextField.getText());
        StiSettings.setStringValue((String)"viewer", (String)"MailPort", (String)this.portTextField.getText());
        StiSettings.setStringValue((String)"viewer", (String)"MailUser", (String)this.userTextField.getText());
        StiSettings.setStringValue((String)"viewer", (String)"MailRecipients", (String)this.recipientsTextField.getText());
        StiSettings.setBoolValue((String)"viewer", (String)"MailNeedAuth", (Boolean)this.authCheckBox.isSelected());
        StiSettings.setBoolValue((String)"viewer", (String)"MailUseSSL", (Boolean)this.sslCheckBox.isSelected());
    }

    private void enableControls(Boolean enabled) {
        this.fromTextField.setEnabled(enabled);
        this.hostTextField.setEnabled(enabled);
        this.portTextField.setEnabled(enabled);
        this.authCheckBox.setEnabled(enabled);
        this.sslCheckBox.setEnabled(enabled);
        this.recipientsTextField.setEnabled(enabled);
        this.subjectTextField.setEnabled(enabled);
        this.bodyPane.setEnabled(enabled.booleanValue());
        this.sendButton.setEnabled(enabled);
        this.closeButton.setEnabled(enabled);
        this.fromLabel.setEnabled(enabled);
        this.hostLabel.setEnabled(enabled);
        this.smtpPortLabel.setEnabled(enabled);
        this.recipientsLabel.setEnabled(enabled);
        this.subjectLabel.setEnabled(enabled);
        this.bodyLabel.setEnabled(enabled);
        this.sendingLabel.setVisible(enabled == false);
        this.sendingProgressBar.setVisible(enabled == false);
        if (this.authCheckBox.isSelected()) {
            this.userTextField.setEnabled(enabled);
            this.passwordTextField.setEnabled(enabled);
            this.userLabel.setEnabled(enabled);
            this.passwordLabel.setEnabled(enabled);
        }
        this.setEnabled(enabled);
    }

    private void sendEmail() {
        if (this.checkFields().booleanValue()) {
            this.mailProperties.setBody(this.bodyPane.getText());
            this.mailProperties.setFrom(this.fromTextField.getText());
            this.mailProperties.setHost(this.hostTextField.getText());
            this.mailProperties.setPassword(new String(this.passwordTextField.getPassword()));
            this.mailProperties.setRecipients(this.recipientsTextField.getText());
            this.mailProperties.setSmtpNeedAuth(Boolean.valueOf(this.authCheckBox.isSelected()));
            this.mailProperties.setSmtpPort(new Integer(this.portTextField.getText()).intValue());
            this.mailProperties.setSubject(this.subjectTextField.getText());
            this.mailProperties.setUserName(this.userTextField.getText());
            this.mailProperties.setUseSSL(Boolean.valueOf(this.sslCheckBox.isSelected()));
            this.enableControls(false);
            Sender sender = new Sender();
            sender.start();
        }
    }

    private Boolean checkFields() {
        ArrayList<String> emptyFields = new ArrayList<String>();
        if (StiValidationUtil.isNullOrEmpty((String)this.fromTextField.getText())) {
            emptyFields.add("From");
        }
        if (StiValidationUtil.isNullOrEmpty((String)this.hostTextField.getText())) {
            emptyFields.add("SMTPHost");
        }
        if (StiValidationUtil.isNullOrEmpty((String)this.portTextField.getText())) {
            emptyFields.add("SMTPPort");
        }
        if (StiValidationUtil.isNullOrEmpty((String)this.recipientsTextField.getText())) {
            emptyFields.add("Recipients");
        }
        if (this.authCheckBox.isSelected()) {
            if (StiValidationUtil.isNullOrEmpty((String)this.userTextField.getText())) {
                emptyFields.add("User");
            }
            if (StiValidationUtil.isNullOrEmpty((String)new String(this.passwordTextField.getPassword()))) {
                emptyFields.add("Password");
            }
        }
        if (emptyFields.size() > 0) {
            String localizedFields = " ";
            for (int i = 0; i < emptyFields.size(); ++i) {
                localizedFields = localizedFields + StiLocalization.getValue((String)"Mail", (String)((String)emptyFields.get(i))).replaceAll(":", "");
                if (i >= emptyFields.size() - 1) continue;
                localizedFields = localizedFields + ", ";
            }
            String errBundle = emptyFields.size() == 1 ? "FieldIsEmpty" : "FieldsAreEmpty";
            JOptionPane.showMessageDialog(this, StiLocalization.getValue((String)"Mail", (String)errBundle) + localizedFields, StiLocalization.getValue((String)"Mail", (String)"Error"), 0);
            return false;
        }
        return true;
    }

    private class Sender
    extends Thread {
        private Sender() {
        }

        @Override
        public void run() {
            try {
                StiMailSender.sendMail((StiMailProperties)StiMailSenderDialog.this.mailProperties);
                StiMailSenderDialog.this.enableControls(true);
                JOptionPane.showMessageDialog(StiMailSenderDialog.this.owner, StiLocalization.getValue((String)"Mail", (String)"LetterSent"), "", 1);
            }
            catch (Throwable e) {
                System.err.println("Unable to send mail " + StiMailSenderDialog.this.mailProperties.toString());
                e.printStackTrace();
                StiMailSenderDialog.this.enableControls(true);
                StiExceptionProvider.show((Throwable)e, (Frame)StiMailSenderDialog.this.owner);
            }
        }
    }
}

