/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.controls.visual;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.viewer.controls.visual.StiToggleFlatButton;
import com.stimulsoft.viewer.enums.StiViewState;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.utils.StiImageToolTip;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class StiMultipageButton
extends StiToggleFlatButton
implements AncestorListener {
    private static final long serialVersionUID = 8995219928526514760L;
    private JWindow popup;
    private MultipagePanel panel = new MultipagePanel();
    private StiViewEventable parent;
    private String url;

    public StiMultipageButton(String text, Icon icon, String tooltip, StiViewEventable parent, String url) {
        super(text, icon, tooltip);
        this.parent = parent;
        this.url = url;
        this.setFocusable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiMultipageButton.this.popup = new JWindow(StiMultipageButton.this.getFrame(null));
                StiMultipageButton.this.popup.add(StiMultipageButton.this.panel);
                StiMultipageButton.this.popup.addWindowFocusListener(new WindowAdapter(){

                    @Override
                    public void windowLostFocus(WindowEvent evt) {
                        StiMultipageButton.this.hidePopup(false);
                    }
                });
                StiMultipageButton.this.panel.clearSelection();
                StiMultipageButton.this.popup.setSize(StiMultipageButton.this.panel.getSize());
                Point pt = StiMultipageButton.this.getLocationOnScreen();
                pt.translate(0, StiMultipageButton.this.getHeight());
                StiMultipageButton.this.popup.setLocation(pt);
                StiMultipageButton.this.popup.toFront();
                StiMultipageButton.this.popup.setVisible(true);
                StiMultipageButton.this.popup.requestFocusInWindow();
            }
        });
        this.addAncestorListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                MouseEvent event = (MouseEvent)e;
                if ((e.getID() == 500 || e.getID() == 501) && StiMultipageButton.this.popup != null && StiMultipageButton.this.popup.isVisible() && !StiMultipageButton.this.popup.contains(event.getPoint())) {
                    StiMultipageButton.this.hidePopup(false);
                }
            }
        }, 16L);
    }

    private void hidePopup(Boolean resultOK) {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
            if (!resultOK.booleanValue()) {
                this.setSelected(false);
            }
        }
    }

    protected Frame getFrame(Component comp) {
        if (comp == null) {
            comp = this;
        }
        if (comp instanceof Frame) {
            return (Frame)comp;
        }
        return this.getFrame(comp.getParent());
    }

    @Override
    public JToolTip createToolTip() {
        return this.url != null ? new StiImageToolTip(this.url) : super.createToolTip();
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.hidePopup(false);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.hidePopup(false);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (event.getSource() != this.popup) {
            this.hidePopup(false);
        }
    }

    public class StiPageButton
    extends JToggleButton {
        private static final long serialVersionUID = 3453501553182772552L;
        public static final int BUTTON_SIZE = 23;
        private int xPosition;
        private int yPosition;

        public StiPageButton(Integer xPosition, Integer yPosition) {
            super(StiResourceUtil.loadIcon((String)"/icons/MultipagePannelIcon.png"));
            this.xPosition = xPosition;
            this.yPosition = yPosition;
            this.setFocusable(false);
            Dimension size = new Dimension(23, 23);
            this.setSize(size);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }

        public int getXPosition() {
            return this.xPosition;
        }

        public int getYPosition() {
            return this.yPosition;
        }
    }

    private class MultipagePanel
    extends JPanel {
        private static final long serialVersionUID = -6265921804155328409L;
        private static final int ROWS_COUNT = 3;
        private static final int COLS_COUNT = 6;
        private static final int BUTTONS_MARGIN = 5;
        private List<StiPageButton> pageButtons = new ArrayList<StiPageButton>();
        private JPanel infoPanel = new JPanel();
        private JLabel infoLabel = new JLabel();
        private JPanel mainPanel = new JPanel();

        public MultipagePanel() {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 6; ++j) {
                    StiPageButton button = new StiPageButton(j, i);
                    this.pageButtons.add(button);
                    this.mainPanel.add(button);
                    button.setLocation(i * (5 + button.getWidth()), j * (5 + button.getHeight()));
                    button.addMouseMotionListener(new MouseMotionAdapter(){

                        @Override
                        public void mouseMoved(MouseEvent e) {
                            for (int i = 0; i < MultipagePanel.this.pageButtons.size(); ++i) {
                                ((StiPageButton)MultipagePanel.this.pageButtons.get(i)).setSelected(false);
                            }
                            int xPos = ((StiPageButton)e.getSource()).getXPosition();
                            int yPos = ((StiPageButton)e.getSource()).getYPosition();
                            for (int i = 0; i < 3; ++i) {
                                for (int j = 0; j < 6; ++j) {
                                    if (j > xPos || i > yPos) continue;
                                    ((StiPageButton)MultipagePanel.this.pageButtons.get(j + i * 6)).setSelected(true);
                                }
                            }
                            MultipagePanel.this.infoLabel.setText(String.format(StiLocalization.getFormatValue((String)"FormViewer", (String)"ZoomXXPages"), xPos + 1, yPos + 1));
                        }
                    });
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            StiMultipageButton.this.hidePopup(true);
                            int xPos = ((StiPageButton)e.getSource()).getXPosition();
                            int yPos = ((StiPageButton)e.getSource()).getYPosition();
                            StiMultipageButton.this.parent.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ChangeViewState", (Object)StiViewState.ZoomMultiplePages, new Dimension(xPos + 1, yPos + 1)));
                        }
                    });
                }
            }
            this.setFocusable(false);
            Dimension infoPanelSize = new Dimension(163, 26);
            this.infoPanel.setLayout(new FlowLayout(1));
            this.infoPanel.setSize(infoPanelSize);
            this.infoPanel.setPreferredSize(infoPanelSize);
            this.infoPanel.setMinimumSize(infoPanelSize);
            this.infoPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.infoPanel.add(this.infoLabel);
            this.infoPanel.setBackground(Color.WHITE);
            this.infoLabel.setBounds(-3, -5, 100, 15);
            this.mainPanel.add(this.infoPanel);
            Dimension mainPanelSize = new Dimension(173, 121);
            this.mainPanel.setSize(mainPanelSize);
            this.mainPanel.setPreferredSize(mainPanelSize);
            this.mainPanel.setMinimumSize(mainPanelSize);
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.add(this.mainPanel);
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.setBackground(Color.WHITE);
            this.setSize(183, 133);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    MultipagePanel.this.clearSelection();
                }
            });
        }

        public void clearSelection() {
            this.infoLabel.setText(StiLocalization.getHingValue((String)"Buttons", (String)"Cancel"));
            for (StiPageButton button : this.pageButtons) {
                button.setSelected(false);
            }
        }
    }
}

