/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer;

import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.viewer.FullScreenSupportable;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import com.stimulsoft.viewer.controls.visual.StiSplitPane;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventListener;
import com.stimulsoft.viewer.logic.StiViewController;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.panels.StiBookmarkPannel;
import com.stimulsoft.viewer.panels.StiDesignToolBar;
import com.stimulsoft.viewer.panels.StiFindToolBar;
import com.stimulsoft.viewer.panels.StiMainToolBar;
import com.stimulsoft.viewer.panels.StiNavigateToolBar;
import com.stimulsoft.viewer.panels.StiThumbnailsPannel;
import com.stimulsoft.viewer.panels.StiViewModeToolBar;
import com.stimulsoft.viewer.panels.StiViewPannel;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.utils.StiNavigateButtonsProcessor;
import com.stimulsoft.viewer.utils.StiViewSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class StiViewerFx
extends JPanel
implements StiViewSettings {
    private static final long serialVersionUID = 748370808611603977L;
    public static final String LOCALIZATION_FILE_NAME = "/en.xml";
    public static final Color BACKGROUND_COLOR = new Color(192, 195, 204);
    private StiViewModel stiViewModel;
    private StiMainToolBar stiMainToolBar;
    private StiDesignToolBar stiDesignToolBar;
    private StiNavigateToolBar stiNavigateToolBar;
    private StiViewModeToolBar stiViewModeToolBar;
    private StiViewPannel stiViewPannel;
    private StiThumbnailsPannel stiThumbnailsPannel;
    private StiBookmarkPannel stiBookmarkPannel;
    private StiSplitPane centerPane;
    private StiFindToolBar stiFindToolBar;
    private JPanel bottomPanel;
    private StiSplitPane rightPane;
    private JFrame parentFrame;
    private StiRequestPanel panelDialogs;
    private JPanel centerBorderPanel;
    private Boolean fullScreenResizeable;
    private int fullScreenState;
    private int fullScreenVerticalScrollbar;
    private int fullScreenHorizontalScrollbar;

    public StiViewerFx(JFrame parentFrame) {
        super(new BorderLayout());
        this.parentFrame = parentFrame;
        this.initView();
    }

    private void initView() {
        this.stiViewModel = new StiViewModel(this.parentFrame);
        this.initTopPanel();
        this.initBottomPanel();
        this.initCenterPanel();
        new StiViewController(this, this.stiViewModel);
        this.bindEvents();
        StiNavigateButtonsProcessor.setup(this.stiViewPannel, this.stiThumbnailsPannel);
    }

    private void bindEvents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StiViewerFx.this.stiViewPannel.onScrollViewerResize();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (!StiViewerFx.this.stiViewModel.getFullScreen().booleanValue()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StiViewerFx.this.showThumbsPannel(StiViewerFx.this.stiViewModel.getThumbnailPannelVisible());
                        }
                    });
                }
            }
        });
        this.parentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StiSettings.setIntValue((String)"viewer", (String)"ThumbnailsWidth", (Integer)StiViewerFx.this.rightPane.getResizeWidht());
                StiSettings.setIntValue((String)"viewer", (String)"BookmarksWidth", (Integer)StiViewerFx.this.centerPane.getResizeWidht());
                StiSettings.flush();
            }
        });
        int c = 2;
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(c).put(ks, "hotPress");
        this.getActionMap().put("hotPress", new AbstractAction(){
            private static final long serialVersionUID = 8935120731439858452L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StiViewerFx.this.stiViewModel.getFullScreen().booleanValue()) {
                    StiViewerFx.this.stiViewModel.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowFullScreen", false));
                }
            }
        });
    }

    public void updateTitle(String fileName) {
        String title = StiLocalization.getValue((String)"FormView", (String)"AppTitle");
        if (fileName != null) {
            title = fileName + " - " + title;
        }
    }

    private void initTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        this.stiMainToolBar = new StiMainToolBar(this.stiViewModel);
        topPanel.add(this.stiMainToolBar);
        this.add((Component)topPanel, "North");
    }

    private void initCenterPanel() {
        this.centerBorderPanel = new JPanel(new BorderLayout());
        JPanel dPanel = new JPanel();
        dPanel.setBackground(BACKGROUND_COLOR);
        dPanel.setLayout(new BoxLayout(dPanel, 0));
        this.stiViewPannel = new StiViewPannel(this.stiViewModel);
        dPanel.add(this.stiViewPannel);
        this.stiViewPannel.setBackground(BACKGROUND_COLOR);
        this.panelDialogs = new StiRequestPanel();
        this.panelDialogs.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.panelDialogs.setBackground(BACKGROUND_COLOR);
        this.panelDialogs.setLayout(new BoxLayout(this.panelDialogs, 1));
        this.panelDialogs.setPreferredSize(new Dimension(10000, 0));
        this.centerBorderPanel.add((Component)dPanel, "Center");
        this.centerBorderPanel.setBackground(BACKGROUND_COLOR);
        this.stiThumbnailsPannel = new StiThumbnailsPannel(this.stiViewModel);
        this.rightPane = new StiSplitPane(1, this.centerBorderPanel, this.stiThumbnailsPannel, 1, StiSettings.getIntValue((String)"viewer", (String)"ThumbnailsWidth", (Integer)StiThumbnailsPannel.DEFAULT_DIMENSION.width));
        this.rightPane.setBackground(BACKGROUND_COLOR);
        this.stiThumbnailsPannel.setBackground(BACKGROUND_COLOR);
        this.rightPane.setDividerSize(2);
        this.rightPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        this.centerPane = new StiSplitPane(1, null, this.rightPane, 0, StiSettings.getIntValue((String)"viewer", (String)"BookmarksWidth", (Integer)180));
        this.centerPane.setDividerSize(2);
        this.centerPane.setBackground(BACKGROUND_COLOR);
        this.add((Component)this.centerPane, "Center");
        this.stiBookmarkPannel = new StiBookmarkPannel(this.stiViewModel);
        this.stiBookmarkPannel.setBackground(BACKGROUND_COLOR);
    }

    private void initBottomPanel() {
        JPanel bottomPanel2 = new JPanel();
        bottomPanel2.setLayout(new BoxLayout(bottomPanel2, 0));
        bottomPanel2.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.stiNavigateToolBar = new StiNavigateToolBar(this.stiViewModel, this.parentFrame);
        bottomPanel2.add(this.stiNavigateToolBar);
        this.stiViewModeToolBar = new StiViewModeToolBar(this.stiViewModel);
        bottomPanel2.add(this.stiViewModeToolBar);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.stiFindToolBar = new StiFindToolBar(this.stiViewModel, this.parentFrame);
        this.bottomPanel.add(this.stiFindToolBar);
        this.stiFindToolBar.setVisible(false);
        this.bottomPanel.add(bottomPanel2);
        this.add((Component)this.bottomPanel, "South");
    }

    public void showThumbsPannel(Boolean show) {
        this.rightPane.setRightComponent(show != false ? this.stiThumbnailsPannel : null);
    }

    public void showBookmarksPannel(Boolean show) {
        if (this.centerPane.getLeftComponent() == null == show) {
            this.centerPane.setLeftComponent(show != false ? this.stiBookmarkPannel : null);
        }
    }

    public void showFullScreen(final Boolean fullScreen) {
        this.stiViewPannel.requestFocusInWindow();
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.parentFrame.dispose();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (StiViewerFx.this.stiViewModel.getThumbnailPannelVisible().booleanValue()) {
                    StiViewerFx.this.showThumbsPannel(fullScreen == false);
                }
                if (StiViewerFx.this.stiViewModel.getBookmarksPannelVisible().booleanValue()) {
                    StiViewerFx.this.showBookmarksPannel(fullScreen == false);
                }
            }
        });
        this.getBottomPanel().setVisible(fullScreen == false);
        this.getStiMainToolBar().setVisible(fullScreen == false);
        if (this.parentFrame instanceof FullScreenSupportable) {
            ((FullScreenSupportable)((Object)this.parentFrame)).switchFullScreen(fullScreen);
        }
        if (fullScreen.booleanValue()) {
            this.fullScreenResizeable = this.parentFrame.isResizable();
            this.fullScreenState = this.parentFrame.getExtendedState();
            this.fullScreenVerticalScrollbar = this.stiViewPannel.getVerticalScrollBarPolicy();
            this.fullScreenHorizontalScrollbar = this.stiViewPannel.getHorizontalScrollBarPolicy();
            this.parentFrame.setResizable(false);
            this.stiViewPannel.setVerticalScrollBarPolicy(21);
            this.stiViewPannel.setHorizontalScrollBarPolicy(31);
            if (!this.isDisplayable()) {
                this.parentFrame.setUndecorated(true);
            }
            if (gd.isFullScreenSupported()) {
                gd.setFullScreenWindow(this.parentFrame);
            }
            this.parentFrame.setVisible(true);
            this.addExitFullScreenButton();
        } else {
            this.parentFrame.setResizable(this.fullScreenResizeable);
            this.stiViewPannel.setVerticalScrollBarPolicy(this.fullScreenVerticalScrollbar);
            this.stiViewPannel.setHorizontalScrollBarPolicy(this.fullScreenHorizontalScrollbar);
            if (!this.isDisplayable()) {
                this.parentFrame.setUndecorated(false);
            }
            gd.setFullScreenWindow(null);
            this.parentFrame.setVisible(true);
            this.parentFrame.setExtendedState(this.fullScreenState);
            this.requestFocusInWindow();
        }
        this.stiViewModel.setFullScreen(fullScreen);
    }

    public void addExitFullScreenButton() {
        Dimension viewRect = Toolkit.getDefaultToolkit().getScreenSize();
        final JPanel glass = (JPanel)this.parentFrame.getGlassPane();
        final StiFlatButton exitFullScreenButton = new StiFlatButton(StiLocalization.getHingValue((String)"Buttons", (String)"Close"), StiResourceUtil.loadIcon((String)"/icons/FindClose.png"), null, 27, 0, null);
        exitFullScreenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewerFx.this.stiViewModel.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowFullScreen", false));
                glass.remove(exitFullScreenButton);
                glass.setVisible(false);
            }
        });
        this.stiViewModel.getEventDispatcher().addStiEventListener(new StiViewEventListener(){

            @Override
            public void stiCommonEventPerformed(StiViewCommonEvent stiCommonEvent) {
                String eventType = stiCommonEvent.getEventType();
                if ("ShowFullScreen".equals(eventType) && !((Boolean)stiCommonEvent.getSource()).booleanValue()) {
                    glass.remove(exitFullScreenButton);
                    glass.setVisible(false);
                }
            }
        });
        glass.setVisible(true);
        glass.setLayout(null);
        exitFullScreenButton.setBounds((int)viewRect.getWidth() - 126, 2, 100, 30);
        glass.add(exitFullScreenButton);
    }

    public StiMainToolBar getStiMainToolBar() {
        return this.stiMainToolBar;
    }

    public StiDesignToolBar getStiDesignToolBar() {
        return this.stiDesignToolBar;
    }

    public StiNavigateToolBar getStiNavigateToolBar() {
        return this.stiNavigateToolBar;
    }

    public StiViewModeToolBar getStiViewModeToolBar() {
        return this.stiViewModeToolBar;
    }

    public StiViewPannel getStiViewPannel() {
        return this.stiViewPannel;
    }

    public StiThumbnailsPannel getStiThumbnailsPannel() {
        return this.stiThumbnailsPannel;
    }

    public StiBookmarkPannel getStiBookmarkPannel() {
        return this.stiBookmarkPannel;
    }

    public StiSplitPane getCenterPane() {
        return this.centerPane;
    }

    public StiFindToolBar getStiFindToolBar() {
        return this.stiFindToolBar;
    }

    public JPanel getBottomPanel() {
        return this.bottomPanel;
    }

    public StiSplitPane getRightPane() {
        return this.rightPane;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public StiViewModel getStiViewModel() {
        return this.stiViewModel;
    }

    public StiRequestPanel getPanelDialogs() {
        return this.panelDialogs;
    }

    public JPanel getCenterBorderPanel() {
        return this.centerBorderPanel;
    }

    public JDialog createPopup(Frame parentFrame, boolean modal) {
        JDialog dialog = new JDialog(parentFrame, modal);
        dialog.setSize(800, 600);
        dialog.setLayout(new BoxLayout(dialog.getContentPane(), 0));
        dialog.add(this);
        SwingUtilities.updateComponentTreeUI(this);
        dialog.setLocationRelativeTo(parentFrame);
        return dialog;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.put("swing.boldMetal", Boolean.FALSE);
                    JFrame frame = new JFrame();
                    frame.setTitle("Viewer");
                    frame.setIconImage(StiResourceUtil.loadIcon((String)"/ico/icon.png").getImage());
                    frame.setSize(new Dimension(1100, 650));
                    frame.setExtendedState(frame.getExtendedState() | 6);
                    frame.setLayout(new BoxLayout(frame.getContentPane(), 0));
                    frame.setDefaultCloseOperation(3);
                    StiViewerFx stiViewerPanel = new StiViewerFx(frame);
                    frame.add(stiViewerPanel);
                    frame.setVisible(true);
                }
                catch (Throwable e) {
                    StiExceptionProvider.show((Throwable)e, null);
                }
            }
        });
    }
}

