/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.demo.button;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.demo.panels.StiTreeReportsPanel;
import com.stimulsoft.viewer.utils.StiURLHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;

public class StiHelpResourcesButton
extends JButton {
    private static final long serialVersionUID = -8834500262718358934L;
    private HelpPopupMenu menu = new HelpPopupMenu();
    private List<MenuElement> reportItems = new ArrayList<MenuElement>();
    private Timer blinkTimer;

    public StiHelpResourcesButton() {
        super(StiLocalization.getValue((String)"Localization", (String)"ButtonHelpResources"), StiResourceUtil.loadIcon((String)"/HelpResources.png"));
        this.setHorizontalTextPosition(2);
        final StiHelpResourcesButton this_ = this;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiHelpResourcesButton.this.menu.show(this_, 0, this_.getHeight());
            }
        });
    }

    public void reportSelected(StiTreeReportsPanel.Report report) {
        for (MenuElement item : this.reportItems) {
            this.menu.remove((Component)((Object)item));
        }
        if (report != null) {
            JMenuItem item;
            if (report.getSamples().size() > 0) {
                for (int i = report.getSamples().size() - 1; i >= 0; --i) {
                    StiTreeReportsPanel.Sample sample = report.getSamples().get(i);
                    item = new JMenuItem(sample.getName(), StiResourceUtil.loadIcon((String)"/VBProject.png"));
                    this.menu.add((Component)item, 0);
                    item.setHorizontalTextPosition(4);
                    this.reportItems.add(item);
                }
                MenuCaption caption = new MenuCaption(StiLocalization.getValue((String)"Localization", (String)"LabelSamples"));
                this.menu.add((Component)caption, 0);
                this.reportItems.add(caption);
            }
            if (report.getVideos().size() > 0) {
                for (int i = report.getVideos().size() - 1; i >= 0; --i) {
                    final StiTreeReportsPanel.Video video = report.getVideos().get(i);
                    String text = "<html><b>" + video.getName() + "</b><br><font size='2'>" + video.getDescription() + "</html>";
                    item = new JMenuItem(text, StiResourceUtil.loadIcon((String)"/Video.png"));
                    this.menu.add((Component)item, 0);
                    item.setHorizontalTextPosition(4);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            StiURLHelper.openURL((String)video.getUrl());
                        }
                    });
                    this.reportItems.add(item);
                }
                MenuCaption caption = new MenuCaption(StiLocalization.getValue((String)"Localization", (String)"LabelVideos"));
                this.menu.add((Component)caption, 0);
                this.reportItems.add(caption);
            }
            if (report.getSamples().size() > 0 || report.getVideos().size() > 0) {
                this.blink();
            }
        }
    }

    private void blink() {
        this.blinkTimer = new Timer(500, new BlinkListener(this, 5));
        this.blinkTimer.setInitialDelay(0);
        this.blinkTimer.start();
    }

    private void stopBlink() {
        this.blinkTimer.stop();
    }

    private class BlinkListener
    implements ActionListener {
        private Color BLINK_COLOR = new Color(151, 151, 190);
        private StiHelpResourcesButton button;
        private Color bkColor;
        private Integer blinkCount;
        private Integer blinked = 0;

        public BlinkListener(StiHelpResourcesButton button, Integer blinkCount) {
            this.button = button;
            this.blinkCount = blinkCount;
            this.bkColor = button.getBackground();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.BLINK_COLOR.equals(this.button.getBackground())) {
                this.button.setBackground(this.bkColor);
            } else {
                this.button.setBackground(this.BLINK_COLOR);
            }
            Integer n = this.blinked;
            Integer n2 = this.blinked = Integer.valueOf(this.blinked + 1);
            if (this.blinked > this.blinkCount) {
                this.button.setBackground(this.bkColor);
                this.button.stopBlink();
            }
        }
    }

    private class MenuCaption
    extends JPanel
    implements MenuElement {
        private static final long serialVersionUID = -8537825000543585175L;
        private MenuElement[] NO_SUB_ELEMENTS = new MenuElement[0];
        private String text;

        public MenuCaption(String text) {
            this.text = text;
            this.setBackground(new Color(221, 231, 238));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(new Color(0, 21, 110));
            g.setFont(new Font("Arial", 0, 12));
            g2d.drawString(this.text, 3, 13);
            g.setColor(new Color(197, 197, 197));
            g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }

        @Override
        public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }

        @Override
        public MenuElement[] getSubElements() {
            return this.NO_SUB_ELEMENTS;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    private class HelpPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 3819435406445736051L;

        public HelpPopupMenu() {
            this.setBorder(BorderFactory.createLineBorder(new Color(99, 130, 191)));
            this.add(new MenuCaption(StiLocalization.getValue((String)"Localization", (String)"LabelHelp")));
            JMenuItem item = new JMenuItem(StiLocalization.getValue((String)"Localization", (String)"ButtonDocumentation"), StiResourceUtil.loadIcon((String)"/Documentation.png"));
            this.add(item);
            item.setHorizontalTextPosition(4);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiURLHelper.openURL((String)"http://www.stimulsoft.com/Documentation.aspx");
                }
            });
            item = new JMenuItem(StiLocalization.getValue((String)"Localization", (String)"ButtonKnowledgebase"), StiResourceUtil.loadIcon((String)"/Knowledgebase.png"));
            this.add(item);
            item.setHorizontalTextPosition(4);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiURLHelper.openURL((String)"http://stimulsoft.helpserve.com/index.php?_m=knowledgebase&_a=view");
                }
            });
            item = new JMenuItem(StiLocalization.getValue((String)"Localization", (String)"ButtonForum"), StiResourceUtil.loadIcon((String)"/Forum.png"));
            this.add(item);
            item.setHorizontalTextPosition(4);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiURLHelper.openURL((String)"http://forum.stimulsoft.com/");
                }
            });
            item = new JMenuItem(StiLocalization.getValue((String)"Localization", (String)"ButtonSupport"), StiResourceUtil.loadIcon((String)"/Support.png"));
            this.add(item);
            item.setHorizontalTextPosition(4);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiURLHelper.openURL((String)"http://www.stimulsoft.com/support.aspx");
                }
            });
            item = new JMenuItem(StiLocalization.getValue((String)"Localization", (String)"ButtonVideos"), StiResourceUtil.loadIcon((String)"/Video.png"));
            this.add(item);
            item.setHorizontalTextPosition(4);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiURLHelper.openURL((String)"http://www.stimulsoft.com/Videos.aspx");
                }
            });
        }
    }
}

