/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class StiCharsetHelper {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset WINDOWS_1251 = Charset.forName("windows-1251");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_16 = Charset.forName("UTF-16");
    public static final Charset WINDOWS_1252 = Charset.forName("windows-1252");
    public static final Charset IBM437 = Charset.forName("IBM437");
    public static final Charset IBM850 = Charset.forName("IBM850");
    public static final Charset IBM852 = Charset.forName("IBM852");
    public static final Charset IBM857 = Charset.forName("IBM857");
    public static final Charset IBM860 = Charset.forName("IBM860");
    public static final Charset IBM861 = Charset.forName("IBM861");
    public static final Charset IBM862 = Charset.forName("IBM862");
    public static final Charset IBM863 = Charset.forName("IBM863");
    public static final Charset IBM865 = Charset.forName("IBM865");
    public static final Charset IBM866 = Charset.forName("IBM866");
    public static final Charset IBM869 = Charset.forName("IBM869");
    public static Charset[] CHARSETS = new Charset[]{WINDOWS_1251, US_ASCII, UTF_16, UTF8};
    public static String[] CHARSET_NAMES = new String[]{WINDOWS_1251.displayName(), US_ASCII.displayName(), UTF_16.displayName(), UTF8.displayName()};
    public static Map<String, Integer> ENCODINGS = new HashMap<String, Integer>();
    public static Map<Integer, String> ENCODINGS2 = new HashMap<Integer, String>();

    public static Charset getCharsetFromName(String charsetName) {
        return StiCharsetHelper.getCharsetFromName(charsetName, CHARSETS);
    }

    public static Charset getCharsetFromName(String charsetName, Charset[] charsets) {
        for (Charset chraset : charsets) {
            if (!chraset.displayName().equals(charsetName)) continue;
            return chraset;
        }
        return UTF8;
    }

    public static Charset findCharset(String charsetName) {
        for (String name : Charset.availableCharsets().keySet()) {
            if (name.indexOf("windows-" + charsetName) <= 0) continue;
            return (Charset)Charset.availableCharsets().get(name);
        }
        for (String name : Charset.availableCharsets().keySet()) {
            if (name.indexOf(charsetName) <= 0) continue;
            return (Charset)Charset.availableCharsets().get(name);
        }
        return UTF8;
    }

    public static Charset findCharset(int codePage) {
        if (ENCODINGS2.containsKey(codePage)) {
            return StiCharsetHelper.findCharset(ENCODINGS2.get(codePage));
        }
        return UTF8;
    }

    static {
        ENCODINGS.put("IBM037", 37);
        ENCODINGS2.put(37, "IBM037");
        ENCODINGS.put("IBM437", 437);
        ENCODINGS2.put(437, "IBM437");
        ENCODINGS.put("IBM500", 500);
        ENCODINGS2.put(500, "IBM500");
        ENCODINGS.put("ASMO-708", 708);
        ENCODINGS2.put(708, "ASMO-708");
        ENCODINGS.put("DOS-720", 720);
        ENCODINGS2.put(720, "DOS-720");
        ENCODINGS.put("ibm737", 737);
        ENCODINGS2.put(737, "ibm737");
        ENCODINGS.put("ibm775", 775);
        ENCODINGS2.put(775, "ibm775");
        ENCODINGS.put("ibm850", 850);
        ENCODINGS2.put(850, "ibm850");
        ENCODINGS.put("ibm852", 852);
        ENCODINGS2.put(852, "ibm852");
        ENCODINGS.put("IBM855", 855);
        ENCODINGS2.put(855, "IBM855");
        ENCODINGS.put("ibm857", 857);
        ENCODINGS2.put(857, "ibm857");
        ENCODINGS.put("IBM00858", 858);
        ENCODINGS2.put(858, "IBM00858");
        ENCODINGS.put("IBM860", 860);
        ENCODINGS2.put(860, "IBM860");
        ENCODINGS.put("ibm861", 861);
        ENCODINGS2.put(861, "ibm861");
        ENCODINGS.put("DOS-862", 862);
        ENCODINGS2.put(862, "DOS-862");
        ENCODINGS.put("IBM863", 863);
        ENCODINGS2.put(863, "IBM863");
        ENCODINGS.put("IBM864", 864);
        ENCODINGS2.put(864, "IBM864");
        ENCODINGS.put("IBM865", 865);
        ENCODINGS2.put(865, "IBM865");
        ENCODINGS.put("cp866", 866);
        ENCODINGS2.put(866, "cp866");
        ENCODINGS.put("ibm869", 869);
        ENCODINGS2.put(869, "ibm869");
        ENCODINGS.put("IBM870", 870);
        ENCODINGS2.put(870, "IBM870");
        ENCODINGS.put("windows-874", 874);
        ENCODINGS2.put(874, "windows-874");
        ENCODINGS.put("cp875", 875);
        ENCODINGS2.put(875, "cp875");
        ENCODINGS.put("shift_jis", 932);
        ENCODINGS2.put(932, "shift_jis");
        ENCODINGS.put("gb2312", 936);
        ENCODINGS2.put(936, "gb2312");
        ENCODINGS.put("ks_c_5601-1987", 949);
        ENCODINGS2.put(949, "ks_c_5601-1987");
        ENCODINGS.put("big5", 950);
        ENCODINGS2.put(950, "big5");
        ENCODINGS.put("IBM1026", 1026);
        ENCODINGS2.put(1026, "IBM1026");
        ENCODINGS.put("IBM01047", 1047);
        ENCODINGS2.put(1047, "IBM01047");
        ENCODINGS.put("IBM01140", 1140);
        ENCODINGS2.put(1140, "IBM01140");
        ENCODINGS.put("IBM01141", 1141);
        ENCODINGS2.put(1141, "IBM01141");
        ENCODINGS.put("IBM01142", 1142);
        ENCODINGS2.put(1142, "IBM01142");
        ENCODINGS.put("IBM01143", 1143);
        ENCODINGS2.put(1143, "IBM01143");
        ENCODINGS.put("IBM01144", 1144);
        ENCODINGS2.put(1144, "IBM01144");
        ENCODINGS.put("IBM01145", 1145);
        ENCODINGS2.put(1145, "IBM01145");
        ENCODINGS.put("IBM01146", 1146);
        ENCODINGS2.put(1146, "IBM01146");
        ENCODINGS.put("IBM01147", 1147);
        ENCODINGS2.put(1147, "IBM01147");
        ENCODINGS.put("IBM01148", 1148);
        ENCODINGS2.put(1148, "IBM01148");
        ENCODINGS.put("IBM01149", 1149);
        ENCODINGS2.put(1149, "IBM01149");
        ENCODINGS.put("utf-16", 1200);
        ENCODINGS2.put(1200, "utf-16");
        ENCODINGS.put("utf-16BE", 1201);
        ENCODINGS2.put(1201, "utf-16BE");
        ENCODINGS.put("windows-1250", 1250);
        ENCODINGS2.put(1250, "windows-1250");
        ENCODINGS.put("windows-1251", 1251);
        ENCODINGS2.put(1251, "windows-1251");
        ENCODINGS.put("Windows-1252", 1252);
        ENCODINGS2.put(1252, "Windows-1252");
        ENCODINGS.put("windows-1253", 1253);
        ENCODINGS2.put(1253, "windows-1253");
        ENCODINGS.put("windows-1254", 1254);
        ENCODINGS2.put(1254, "windows-1254");
        ENCODINGS.put("windows-1255", 1255);
        ENCODINGS2.put(1255, "windows-1255");
        ENCODINGS.put("windows-1256", 1256);
        ENCODINGS2.put(1256, "windows-1256");
        ENCODINGS.put("windows-1257", 1257);
        ENCODINGS2.put(1257, "windows-1257");
        ENCODINGS.put("windows-1258", 1258);
        ENCODINGS2.put(1258, "windows-1258");
        ENCODINGS.put("Johab", 1361);
        ENCODINGS2.put(1361, "Johab");
        ENCODINGS.put("macintosh", 10000);
        ENCODINGS2.put(10000, "macintosh");
        ENCODINGS.put("x-mac-japanese", 10001);
        ENCODINGS2.put(10001, "x-mac-japanese");
        ENCODINGS.put("x-mac-chinesetrad", 10002);
        ENCODINGS2.put(10002, "x-mac-chinesetrad");
        ENCODINGS.put("x-mac-korean", 10003);
        ENCODINGS2.put(10003, "x-mac-korean");
        ENCODINGS.put("x-mac-arabic", 10004);
        ENCODINGS2.put(10004, "x-mac-arabic");
        ENCODINGS.put("x-mac-hebrew", 10005);
        ENCODINGS2.put(10005, "x-mac-hebrew");
        ENCODINGS.put("x-mac-greek", 10006);
        ENCODINGS2.put(10006, "x-mac-greek");
        ENCODINGS.put("x-mac-cyrillic", 10007);
        ENCODINGS2.put(10007, "x-mac-cyrillic");
        ENCODINGS.put("x-mac-chinesesimp", 10008);
        ENCODINGS2.put(10008, "x-mac-chinesesimp");
        ENCODINGS.put("x-mac-romanian", 10010);
        ENCODINGS2.put(10010, "x-mac-romanian");
        ENCODINGS.put("x-mac-ukrainian", 10017);
        ENCODINGS2.put(10017, "x-mac-ukrainian");
        ENCODINGS.put("x-mac-thai", 10021);
        ENCODINGS2.put(10021, "x-mac-thai");
        ENCODINGS.put("x-mac-ce", 10029);
        ENCODINGS2.put(10029, "x-mac-ce");
        ENCODINGS.put("x-mac-icelandic", 10079);
        ENCODINGS2.put(10079, "x-mac-icelandic");
        ENCODINGS.put("x-mac-turkish", 10081);
        ENCODINGS2.put(10081, "x-mac-turkish");
        ENCODINGS.put("x-mac-croatian", 10082);
        ENCODINGS2.put(10082, "x-mac-croatian");
        ENCODINGS.put("utf-32", 12000);
        ENCODINGS2.put(12000, "utf-32");
        ENCODINGS.put("utf-32BE", 12001);
        ENCODINGS2.put(12001, "utf-32BE");
        ENCODINGS.put("x-Chinese-CNS", 20000);
        ENCODINGS2.put(20000, "x-Chinese-CNS");
        ENCODINGS.put("x-cp20001", 20001);
        ENCODINGS2.put(20001, "x-cp20001");
        ENCODINGS.put("x-Chinese-Eten", 20002);
        ENCODINGS2.put(20002, "x-Chinese-Eten");
        ENCODINGS.put("x-cp20003", 20003);
        ENCODINGS2.put(20003, "x-cp20003");
        ENCODINGS.put("x-cp20004", 20004);
        ENCODINGS2.put(20004, "x-cp20004");
        ENCODINGS.put("x-cp20005", 20005);
        ENCODINGS2.put(20005, "x-cp20005");
        ENCODINGS.put("x-IA5", 20105);
        ENCODINGS2.put(20105, "x-IA5");
        ENCODINGS.put("x-IA5-German", 20106);
        ENCODINGS2.put(20106, "x-IA5-German");
        ENCODINGS.put("x-IA5-Swedish", 20107);
        ENCODINGS2.put(20107, "x-IA5-Swedish");
        ENCODINGS.put("x-IA5-Norwegian", 20108);
        ENCODINGS2.put(20108, "x-IA5-Norwegian");
        ENCODINGS.put("us-ascii", 20127);
        ENCODINGS2.put(20127, "us-ascii");
        ENCODINGS.put("x-cp20261", 20261);
        ENCODINGS2.put(20261, "x-cp20261");
        ENCODINGS.put("x-cp20269", 20269);
        ENCODINGS2.put(20269, "x-cp20269");
        ENCODINGS.put("IBM273", 20273);
        ENCODINGS2.put(20273, "IBM273");
        ENCODINGS.put("IBM277", 20277);
        ENCODINGS2.put(20277, "IBM277");
        ENCODINGS.put("IBM278", 20278);
        ENCODINGS2.put(20278, "IBM278");
        ENCODINGS.put("IBM280", 20280);
        ENCODINGS2.put(20280, "IBM280");
        ENCODINGS.put("IBM284", 20284);
        ENCODINGS2.put(20284, "IBM284");
        ENCODINGS.put("IBM285", 20285);
        ENCODINGS2.put(20285, "IBM285");
        ENCODINGS.put("IBM290", 20290);
        ENCODINGS2.put(20290, "IBM290");
        ENCODINGS.put("IBM297", 20297);
        ENCODINGS2.put(20297, "IBM297");
        ENCODINGS.put("IBM420", 20420);
        ENCODINGS2.put(20420, "IBM420");
        ENCODINGS.put("IBM423", 20423);
        ENCODINGS2.put(20423, "IBM423");
        ENCODINGS.put("IBM424", 20424);
        ENCODINGS2.put(20424, "IBM424");
        ENCODINGS.put("x-EBCDIC-KoreanExtended", 20833);
        ENCODINGS2.put(20833, "x-EBCDIC-KoreanExtended");
        ENCODINGS.put("IBM-Thai", 20838);
        ENCODINGS2.put(20838, "IBM-Thai");
        ENCODINGS.put("koi8-r", 20866);
        ENCODINGS2.put(20866, "koi8-r");
        ENCODINGS.put("IBM871", 20871);
        ENCODINGS2.put(20871, "IBM871");
        ENCODINGS.put("IBM880", 20880);
        ENCODINGS2.put(20880, "IBM880");
        ENCODINGS.put("IBM905", 20905);
        ENCODINGS2.put(20905, "IBM905");
        ENCODINGS.put("IBM00924", 20924);
        ENCODINGS2.put(20924, "IBM00924");
        ENCODINGS.put("EUC-JP", 20932);
        ENCODINGS2.put(20932, "EUC-JP");
        ENCODINGS.put("x-cp20936", 20936);
        ENCODINGS2.put(20936, "x-cp20936");
        ENCODINGS.put("x-cp20949", 20949);
        ENCODINGS2.put(20949, "x-cp20949");
        ENCODINGS.put("cp1025", 21025);
        ENCODINGS2.put(21025, "cp1025");
        ENCODINGS.put("koi8-u", 21866);
        ENCODINGS2.put(21866, "koi8-u");
        ENCODINGS.put("iso-8859-1", 28591);
        ENCODINGS2.put(28591, "iso-8859-1");
        ENCODINGS.put("iso-8859-2", 28592);
        ENCODINGS2.put(28592, "iso-8859-2");
        ENCODINGS.put("iso-8859-3", 28593);
        ENCODINGS2.put(28593, "iso-8859-3");
        ENCODINGS.put("iso-8859-4", 28594);
        ENCODINGS2.put(28594, "iso-8859-4");
        ENCODINGS.put("iso-8859-5", 28595);
        ENCODINGS2.put(28595, "iso-8859-5");
        ENCODINGS.put("iso-8859-6", 28596);
        ENCODINGS2.put(28596, "iso-8859-6");
        ENCODINGS.put("iso-8859-7", 28597);
        ENCODINGS2.put(28597, "iso-8859-7");
        ENCODINGS.put("iso-8859-8", 28598);
        ENCODINGS2.put(28598, "iso-8859-8");
        ENCODINGS.put("iso-8859-9", 28599);
        ENCODINGS2.put(28599, "iso-8859-9");
        ENCODINGS.put("iso-8859-13", 28603);
        ENCODINGS2.put(28603, "iso-8859-13");
        ENCODINGS.put("iso-8859-15", 28605);
        ENCODINGS2.put(28605, "iso-8859-15");
        ENCODINGS.put("x-Europa", 29001);
        ENCODINGS2.put(29001, "x-Europa");
        ENCODINGS.put("iso-8859-8-i", 38598);
        ENCODINGS2.put(38598, "iso-8859-8-i");
        ENCODINGS.put("iso-2022-jp", 50220);
        ENCODINGS2.put(50220, "iso-2022-jp");
        ENCODINGS.put("csISO2022JP", 50221);
        ENCODINGS2.put(50221, "csISO2022JP");
        ENCODINGS.put("iso-2022-jp", 50222);
        ENCODINGS2.put(50222, "iso-2022-jp");
        ENCODINGS.put("iso-2022-kr", 50225);
        ENCODINGS2.put(50225, "iso-2022-kr");
        ENCODINGS.put("x-cp50227", 50227);
        ENCODINGS2.put(50227, "x-cp50227");
        ENCODINGS.put("euc-jp", 51932);
        ENCODINGS2.put(51932, "euc-jp");
        ENCODINGS.put("EUC-CN", 51936);
        ENCODINGS2.put(51936, "EUC-CN");
        ENCODINGS.put("euc-kr", 51949);
        ENCODINGS2.put(51949, "euc-kr");
        ENCODINGS.put("hz-gb-2312", 52936);
        ENCODINGS2.put(52936, "hz-gb-2312");
        ENCODINGS.put("GB18030", 54936);
        ENCODINGS2.put(54936, "GB18030");
        ENCODINGS.put("x-iscii-de", 57002);
        ENCODINGS2.put(57002, "x-iscii-de");
        ENCODINGS.put("x-iscii-be", 57003);
        ENCODINGS2.put(57003, "x-iscii-be");
        ENCODINGS.put("x-iscii-ta", 57004);
        ENCODINGS2.put(57004, "x-iscii-ta");
        ENCODINGS.put("x-iscii-te", 57005);
        ENCODINGS2.put(57005, "x-iscii-te");
        ENCODINGS.put("x-iscii-as", 57006);
        ENCODINGS2.put(57006, "x-iscii-as");
        ENCODINGS.put("x-iscii-or", 57007);
        ENCODINGS2.put(57007, "x-iscii-or");
        ENCODINGS.put("x-iscii-ka", 57008);
        ENCODINGS2.put(57008, "x-iscii-ka");
        ENCODINGS.put("x-iscii-ma", 57009);
        ENCODINGS2.put(57009, "x-iscii-ma");
        ENCODINGS.put("x-iscii-gu", 57010);
        ENCODINGS2.put(57010, "x-iscii-gu");
        ENCODINGS.put("x-iscii-pa", 57011);
        ENCODINGS2.put(57011, "x-iscii-pa");
        ENCODINGS.put("utf-7", 65000);
        ENCODINGS2.put(65000, "utf-7");
        ENCODINGS.put("utf-8", 65001);
        ENCODINGS2.put(65001, "utf-8");
    }
}

