/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system.type;

import com.stimulsoft.base.system.type.ParameterType;
import com.stimulsoft.base.system.type.StiSystemByte;
import com.stimulsoft.base.system.type.StiSystemChar;
import com.stimulsoft.base.system.type.StiSystemDateTime;
import com.stimulsoft.base.system.type.StiSystemDecimal;
import com.stimulsoft.base.system.type.StiSystemDouble;
import com.stimulsoft.base.system.type.StiSystemGuid;
import com.stimulsoft.base.system.type.StiSystemInt16;
import com.stimulsoft.base.system.type.StiSystemInt32;
import com.stimulsoft.base.system.type.StiSystemInt64;
import com.stimulsoft.base.system.type.StiSystemSingle;
import com.stimulsoft.base.system.type.StiSystemString;
import com.stimulsoft.base.system.type.StiSystemTimeSpan;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiTypeRange;
import com.stimulsoft.base.system.type.StiTypeValue;
import java.util.HashMap;

public enum StiRangeTypeEnum {
    StimulsoftStringRange("Stimulsoft.Report.StringRange", StiSystemString.class, ParameterType.RANGE),
    StimulsoftFloatRange("Stimulsoft.Report.FloatRange", StiSystemSingle.class, ParameterType.RANGE),
    StimulsoftDoubleRange("Stimulsoft.Report.DoubleRange", StiSystemDouble.class, ParameterType.RANGE),
    StimulsoftDecimalRange("Stimulsoft.Report.DecimalRange", StiSystemDecimal.class, ParameterType.RANGE),
    StimulsoftDateTimeRange("Stimulsoft.Report.DateTimeRange", StiSystemDateTime.class, ParameterType.RANGE),
    StimulsoftTimeSpanRange("Stimulsoft.Report.TimeSpanRange", StiSystemTimeSpan.class, ParameterType.RANGE),
    StimulsoftByteRange("Stimulsoft.Report.ByteRange", StiSystemByte.class, ParameterType.RANGE),
    StimulsoftShortRange("Stimulsoft.Report.ShortRange", StiSystemInt16.class, ParameterType.RANGE),
    StimulsoftIntRange("Stimulsoft.Report.IntRange", StiSystemInt32.class, ParameterType.RANGE),
    StimulsoftLongRange("Stimulsoft.Report.LongRange", StiSystemInt64.class, ParameterType.RANGE),
    StimulsoftCharRange("Stimulsoft.Report.CharRange", StiSystemChar.class, ParameterType.RANGE),
    StimulsoftGuidRange("Stimulsoft.Report.GuidRange", StiSystemGuid.class, ParameterType.RANGE);

    private static HashMap<String, StiSystemType> mappingsType;
    private StiTypeRange systemType;

    static synchronized HashMap<String, StiSystemType> getMappingsType() {
        if (mappingsType == null) {
            mappingsType = new HashMap();
        }
        return mappingsType;
    }

    private StiRangeTypeEnum(String systemTypeName, Class<? extends StiTypeValue> systemClass, ParameterType type) {
        this.systemType = new StiTypeRange(this.newInstance(systemClass));
        this.systemType.setSerializeValue(systemTypeName);
        StiRangeTypeEnum.getMappingsType().put(systemTypeName, this.systemType);
    }

    public StiSystemType newInstance() {
        return this.systemType;
    }

    public Object getValueByString(String str) {
        return this.newInstance().getInstanceValueByString(str);
    }

    public StiTypeValue newInstance(Class<? extends StiTypeValue> systemClass) {
        try {
            return systemClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exist(String systemTypeName) {
        return StiRangeTypeEnum.getMappingsType().containsKey(systemTypeName);
    }

    public static StiSystemType getSystemType(String systemTypeName) {
        if (StiRangeTypeEnum.exist(systemTypeName)) {
            return StiRangeTypeEnum.getMappingsType().get(systemTypeName);
        }
        return StiRangeTypeEnum.getMappingsType().get("Stimulsoft.Report.StringRange");
    }
}

