/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.utils.StiMath;

public class StiSize
implements IStiSerializableToString,
IStiDefault {
    public static final StiSize EMPTY = new StiSize(0, 0);
    public double width;
    public double height;

    public StiSize() {
        this(0.0, 0.0);
    }

    public StiSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public StiSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Boolean isEmpty() {
        return this.width == 0.0 && this.height == 0.0;
    }

    public StiSize round() {
        return this.round(0.0);
    }

    public StiSize round(double digits) {
        this.width = StiMath.round((Double)this.width, digits);
        this.height = StiMath.round((Double)this.height, digits);
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void rotation90() {
        double newWidth;
        double newHeight = this.width;
        this.width = newWidth = this.height;
        this.height = newHeight;
    }

    public StiSize getStiSize() {
        return new StiSize(this.width, this.height);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StiSize other = (StiSize)obj;
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
            return false;
        }
        return Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width);
    }

    public String toString() {
        return String.format("w=%s h=%s", this.width, this.height);
    }

    public static StiSize getEmpty() {
        return new StiSize(0, 0);
    }

    @Override
    public boolean isDefault() {
        return this.width == 0.0 && this.height == 0.0;
    }

    @Override
    public String serialize() {
        return StiSerializerUtil.serializFormat("{0},{1}", this.width, this.height);
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.width = StiSerializTypeConverter.stringToDouble(values[0]);
        this.height = StiSerializTypeConverter.stringToDouble(values[1]);
    }

    public StiSize clone() {
        return new StiSize(this.width, this.height);
    }
}

