/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.UUID;

public class StiGuid {
    public static final StiGuid EMPTY = new StiGuid("00000000-0000-0000-0000-000000000000");
    private final UUID uid;

    public StiGuid(String value) {
        this.uid = StiValidationUtil.isNotEmpty((String)value) ? UUID.fromString(value) : StiGuid.EMPTY.uid;
    }

    public static StiGuid getEmpty() {
        return new StiGuid("00000000-0000-0000-0000-000000000000");
    }

    public static StiGuid parse(String value) {
        return new StiGuid(value);
    }

    public static StiGuid newGuid() {
        return new StiGuid(UUID.randomUUID().toString().replace("/-/gi", "").toLowerCase());
    }

    public static StiGuid newGuid(Object item) {
        if (item != null) {
            return new StiGuid(item.toString());
        }
        return StiGuid.newGuid();
    }

    public String toString() {
        return this.uid.toString();
    }

    public static void main(String[] args) {
        String value = "74f4b587-8bd7-4323-9a43-9fb67b2cc254";
        StiGuid guid = new StiGuid(value);
        System.out.println(guid);
    }

    public static String newGuidString() {
        return StiGuid.newGuid().toString();
    }

    public static String newGuidStringPlain() {
        return StiGuid.newGuid().toString().replaceAll("-", "");
    }
}

