/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing.utils;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class StiSerializTypeConverter {
    private static final String DATE_TIME_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    private static final String DATE_TIME_FORMAT_EN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm:ss a", Locale.ENGLISH);
    private static final DateTimeFormatter FORMATTER_EN = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("#.######");

    private StiSerializTypeConverter() {
    }

    public static String booleanToString(Object value) {
        return StiSerializTypeConverter.booleanToString(Boolean.valueOf(value.toString()));
    }

    public static String booleanToString(Boolean value) {
        return StiSerializTypeConverter.booleanToString((boolean)value);
    }

    public static String booleanToString(boolean value) {
        return value ? "True" : "False";
    }

    public static boolean stringToBoolean(String value) {
        return value.equalsIgnoreCase("True");
    }

    public static String integerToString(Object value) {
        return value.toString();
    }

    public static int stringToInteger(String value) {
        return Integer.valueOf(value);
    }

    public static long stringToLong(String value) {
        return Long.valueOf(value);
    }

    public static int stringToInt(String value) {
        return StiSerializTypeConverter.stringToInteger(value);
    }

    public static String doubleToString(Object value) {
        return StiSerializTypeConverter.numberToString(value);
    }

    private static String numberToString(Object value) {
        return DOUBLE_FORMAT.format(value).replace(",", ".");
    }

    public static double stringToDouble(String value) {
        value = value.trim();
        return Double.valueOf(value);
    }

    public static String floatToString(Object value) {
        return StiSerializTypeConverter.numberToString(value);
    }

    public static float stringToFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public static String dateTimeToString(ZonedDateTime value) {
        return FORMATTER.format(value);
    }

    public static String dateTimeToStringEN(ZonedDateTime value) {
        return FORMATTER_EN.format(value);
    }

    public static Calendar stringToCalendar(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.ENGLISH);
            Date date = sdf.parse(value);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StiBorder getInstanceBorderBySerializString(String value) {
        StiBorder border = value.startsWith("Adv") ? new StiAdvancedBorder() : new StiBorder();
        return border;
    }

    public static StiBrush getInstanceBrushBySerializString(String value) {
        StiBrush brush = value.startsWith("EmptyBrush") ? new StiEmptyBrush() : (value.startsWith("HatchBrush") ? new StiHatchBrush() : (value.startsWith("GradientBrush") ? new StiGradientBrush() : (value.startsWith("GlareBrush") ? new StiGlareBrush() : (value.startsWith("GlassBrush") ? new StiGlassBrush() : new StiSolidBrush()))));
        return brush;
    }

    public static byte stringToByte(String value) {
        return Byte.valueOf(value);
    }

    public static String bigDecimalToString(BigDecimal value) {
        return StiSerializTypeConverter.numberToString(value);
    }

    public static BigDecimal stringToBigDecimal(String decodeName) {
        return new BigDecimal(decodeName);
    }

    public static <T extends Enum<T>> StiEnumSet<T> stringToEnums(Class<T> enumType, String value) {
        return StiEnumSet.stringToEnums(enumType, value);
    }

    public static String enumsToString(StiEnumSet<?> emums) {
        String result = StiStringUtil.join(emums.collection(), (String)", ");
        return !"".equals(result) ? result : "0";
    }

    public static String getDataByClass(Object returnValue) {
        String result;
        Class<?> returnClass = returnValue.getClass();
        if (returnClass == Double.TYPE || returnClass == Double.class) {
            result = StiSerializTypeConverter.doubleToString(returnValue);
        } else if (returnClass == Float.TYPE || returnClass == Float.class) {
            result = StiSerializTypeConverter.floatToString(returnValue);
        } else if (returnClass == Boolean.TYPE || returnClass == Boolean.class) {
            result = StiSerializTypeConverter.booleanToString(returnValue);
        } else if (returnValue instanceof StiEnumSet) {
            result = StiSerializTypeConverter.enumsToString((StiEnumSet)returnValue);
        } else if (returnClass.isEnum()) {
            result = ((Enum)returnValue).name();
        } else if (returnValue instanceof ZonedDateTime) {
            result = StiSerializTypeConverter.dateTimeToString((ZonedDateTime)returnValue);
        } else if (returnValue instanceof Calendar) {
            Calendar calendar = (Calendar)returnValue;
            result = StiSerializTypeConverter.dateTimeToString(ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()));
        } else {
            result = String.valueOf(returnValue);
        }
        return result;
    }

    public static Object getDataFromString(Class<?> returnType, String strValue) {
        Object result = strValue;
        if (returnType == Calendar.class) {
            result = StiSerializTypeConverter.stringToCalendar(strValue);
        } else if (returnType == ZonedDateTime.class) {
            Calendar calendar = StiSerializTypeConverter.stringToCalendar(strValue);
            result = ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        } else if (returnType.isEnum()) {
            try {
                result = Enum.valueOf(returnType, strValue);
            }
            catch (Exception e) {
                int intValue = Integer.parseInt(strValue);
                for (Enum en : (Enum[])returnType.getEnumConstants()) {
                    if (en.ordinal() != intValue) continue;
                    result = en;
                }
            }
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            result = StiSerializTypeConverter.stringToLong(strValue);
        } else if (returnType == Double.TYPE || returnType == Double.class) {
            result = StiSerializTypeConverter.stringToDouble(strValue);
        } else if (returnType == Float.TYPE || returnType == Float.class) {
            result = Float.valueOf(StiSerializTypeConverter.stringToFloat(strValue));
        } else if (returnType == Integer.TYPE || returnType == Integer.class) {
            result = StiSerializTypeConverter.stringToInteger(strValue);
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            result = StiSerializTypeConverter.stringToBoolean(strValue);
        } else if (returnType == Charset.class) {
            result = Charset.forName(strValue);
        }
        return result;
    }

    public static StiRectangle deserializeStringToRectangle(String strValue) {
        StiRectangle result = new StiRectangle(0L, 0L, 0L, 0L);
        result.deserialize(strValue);
        return result;
    }

    public static StiBrush deserializeStringToBrush(String strValue) {
        StiBrush result = StiSerializTypeConverter.getInstanceBrushBySerializString(strValue);
        result.deserialize(strValue);
        return result;
    }

    public static StiBorder deserializeStringToBorder(String strValue) {
        StiBorder result = StiSerializTypeConverter.getInstanceBorderBySerializString(strValue);
        result.deserialize(strValue);
        return result;
    }

    public static void main(String[] args) {
        Float value = Float.valueOf(4.091f);
        DecimalFormat twoPlaces = new DecimalFormat("#.######");
        System.out.println(StiSerializTypeConverter.floatToString(value) + "|" + twoPlaces.format(value));
    }
}

