/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.serializing.StiBranch;
import com.stimulsoft.base.serializing.StiClassProperties;
import com.stimulsoft.base.serializing.StiProperties;
import com.stimulsoft.base.serializing.StiProperty;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiClassConverter;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.xmlelements.BaseElement;
import com.stimulsoft.base.serializing.xmlelements.IsNullElement;
import com.stimulsoft.base.serializing.xmlelements.ListElement;
import com.stimulsoft.base.serializing.xmlelements.ReferenceElement;
import com.stimulsoft.base.serializing.xmlelements.ReferenceToObjectElement;
import com.stimulsoft.base.serializing.xmlelements.SimpleElement;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class StiSerializerReport {
    private final IStiSerializable instance;
    private final StiProperties propertys;
    private final StiSerializerControler controler;
    private final StiBranch branch;
    private Hashtable<String, Object> memoryStore = new Hashtable();
    protected boolean enhanced;
    protected boolean forceDocumentSerialize;
    private StiProperty currentProperty;
    private Object propertyValue;

    StiSerializerReport(StiSerializerControler helper, StiBranch branch, IStiSerializableRef instance, boolean enhanced, boolean forceDocumentSerialize) {
        this(helper, branch, (IStiSerializable)instance, enhanced, forceDocumentSerialize);
    }

    public Hashtable<String, Object> getMemoryStore() {
        return this.memoryStore;
    }

    StiSerializerReport(StiSerializerControler helper, StiBranch branch, IStiSerializable instance, boolean enhanced, boolean forceDocumentSerialize) {
        this.branch = branch;
        this.controler = helper;
        this.instance = instance;
        this.enhanced = enhanced;
        this.forceDocumentSerialize = forceDocumentSerialize;
        this.propertys = StiClassProperties.getPropertys(instance);
    }

    public void serialize(List<IStiSerializableRef> refs) {
        for (StiProperty property : this.propertys.getProperties()) {
            if (!this.isSerializableProperty(property)) continue;
            this.serializProperty(property, refs);
        }
    }

    protected boolean isSerializableProperty(StiProperty property) {
        return property.isSerializableToReport(this.enhanced) && !property.isDeprecated();
    }

    private void serializProperty(StiProperty property, List<IStiSerializableRef> refs) {
        this.currentProperty = property;
        this.propertyValue = this.currentProperty.getReturnValue(this.instance);
        if (this.currentProperty.memoryStore()) {
            String guid = StiGuid.newGuid().toString();
            this.memoryStore.put(guid, this.propertyValue);
            if (this.currentProperty.isCollection()) {
                this.propertyValue = new ArrayList();
                ((ArrayList)this.propertyValue).add(guid);
            } else {
                this.propertyValue = guid;
            }
        }
        this.processOnDependingType(refs);
    }

    protected StiProperty getCurrentProperty() {
        return this.currentProperty;
    }

    protected void processOnDependingType(List<IStiSerializableRef> refs) {
        if (this.currentProperty.isObject()) {
            this.serializeObject(refs);
        } else if (this.currentProperty.isCollection()) {
            this.serializeCollection(refs);
        } else {
            this.serializePrimitive();
        }
    }

    private void serializeObject(List<IStiSerializableRef> refs) {
        if (this.propertyValue == null) {
            return;
        }
        if (this.isDefaultObject()) {
            return;
        }
        if (this.isSerializableToString()) {
            this.serializableToString();
        } else if (this.isReferenceToObject()) {
            this.serializeReference();
        } else {
            this.serializeParent((IStiSerializableRef)this.propertyValue, this.branch, this.getPropertyName(), refs);
        }
    }

    private boolean isSerializableToString() {
        return IStiSerializableToString.class.isAssignableFrom(this.propertyValue.getClass());
    }

    private boolean isReferenceToObject() {
        IStiSerializableRef serializableReference = (IStiSerializableRef)this.propertyValue;
        boolean referenceToObject = this.currentProperty.isReferenceToObject();
        boolean existReference = serializableReference.getReference() > -1;
        return referenceToObject || existReference;
    }

    private boolean memoryStore() {
        return this.currentProperty.memoryStore();
    }

    protected void serializableToString() {
        IStiSerializableToString serializableToString = (IStiSerializableToString)this.propertyValue;
        String serializeData = serializableToString.serialize();
        this.serializePrimitive(this.getPropertyName(), serializeData);
    }

    private void serializeReference() {
        IStiSerializableRef serializableReference = (IStiSerializableRef)this.propertyValue;
        int reference = serializableReference.getReference();
        BaseElement newRootElement = this.isEmptyReference(reference) ? this.serializeEmptyReference(serializableReference) : new ReferenceToObjectElement(this.controler, this.getPropertyName(), reference);
        this.branch.appendChild(newRootElement);
    }

    private BaseElement serializeEmptyReference(IStiSerializableRef serializableReference) {
        SimpleElement newRootElement = new SimpleElement(this.controler, this.getPropertyName());
        this.controler.addUndefinedRef(newRootElement, serializableReference);
        return newRootElement;
    }

    private boolean isEmptyReference(int reference) {
        return reference == -1;
    }

    private void serializeParent(IStiSerializableRef serializableParent, StiBranch branch, String propertyName, List<IStiSerializableRef> refs) {
        try {
            this.controler.setNextReferenceForParent(serializableParent, refs);
            String className = StiClassConverter.getNetClass(serializableParent.getClass());
            ReferenceElement referenceElement = new ReferenceElement(this.controler, propertyName, className, serializableParent.getReference());
            branch.appendChild(referenceElement);
            this.controler.serializeBranch(referenceElement.createNewBranch(), serializableParent, refs, this.enhanced);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void serializeCollection(List<IStiSerializableRef> refs) {
        if (this.currentProperty.isValueCollection()) {
            this.serializeValueCollection();
        } else if (this.currentProperty.isPrimitiveCollection()) {
            this.serializePrimitiveCollection();
        } else {
            this.serializeObjectCollection(refs);
        }
    }

    private void serializeValueCollection() {
        StiBranch newBranch = this.createListBranch();
        for (Object object : (List)this.propertyValue) {
            if (object == null) continue;
            String serializeData = ((IStiSerializableToString)object).serialize();
            this.simpleSerialiseAsValue(newBranch, serializeData);
        }
    }

    private void simpleSerialiseAsValue(StiBranch newBranch, String serializeData) {
        this.simpleSerialise("value", serializeData, newBranch);
    }

    private void serializePrimitiveCollection() {
        StiBranch newBranch = this.createListBranch();
        for (Object object : (List)this.propertyValue) {
            this.simpleSerialiseAsValue(newBranch, object != null ? object.toString() : "");
        }
    }

    protected void serializeObjectCollection(List<IStiSerializableRef> refs) {
        StiBranch newBranch = this.createListBranch();
        for (Object object : (List)this.propertyValue) {
            if (object == null) continue;
            this.serializeParentInCollection(newBranch, object, refs);
        }
    }

    protected void serializeParentInCollection(StiBranch newBranch, Object object, List<IStiSerializableRef> refs) {
        IStiSerializableRef parent = (IStiSerializableRef)object;
        this.serializeParent(parent, newBranch, this.getNamePropertyInCollection(parent), refs);
    }

    private void serializePrimitive() {
        this.serializePrimitive(this.getPropertyName(), this.propertyValue);
    }

    protected void serializePrimitive(String propertyName, Object value) {
        if (this.isDefaulValue(value)) {
            return;
        }
        if (value == null) {
            IsNullElement isNullElement = new IsNullElement(this.controler, propertyName);
            this.branch.appendChild(isNullElement);
            return;
        }
        String data = StiSerializTypeConverter.getDataByClass(value);
        this.simpleSerialise(propertyName, data, this.branch);
    }

    private void simpleSerialise(String name, String data, StiBranch branch) {
        Element newElement = this.controler.createElement(name);
        Text textNode = this.controler.createTextNode(data);
        newElement.appendChild(textNode);
        branch.appendChild(newElement);
    }

    protected String getPropertyName() {
        return this.currentProperty.getName();
    }

    protected StiSerializerControler getControler() {
        return this.controler;
    }

    protected Object getPropertyValue() {
        return this.propertyValue;
    }

    protected String getNamePropertyInCollection(IStiSerializableRef serializable) {
        if (serializable instanceof IStiName) {
            String name = ((IStiName)serializable).getName();
            if (StiValidationUtil.isEmpty((String)name)) {
                throw new RuntimeException("did not specify the name of the element " + serializable);
            }
            return name;
        }
        return serializable.toString();
    }

    protected StiBranch createListBranch() {
        this.ifNullCreatEmptyProperty();
        List list = (List)this.propertyValue;
        ListElement listElement = new ListElement(this.controler, this.getPropertyName(), list.size());
        this.branch.appendChild(listElement);
        return listElement.createNewBranch();
    }

    private void ifNullCreatEmptyProperty() {
        if (this.propertyValue == null) {
            this.propertyValue = new ArrayList();
        }
    }

    protected boolean isDefaulValue(Object value) {
        return this.currentProperty.isDefaulValue(value);
    }

    private boolean isDefaultObject() {
        boolean defInterface = IStiDefault.class.isAssignableFrom(this.propertyValue.getClass());
        return defInterface && ((IStiDefault)this.propertyValue).isDefault();
    }
}

