/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.serializing.ItemCounter;
import com.stimulsoft.base.serializing.StiBranch;
import com.stimulsoft.base.serializing.StiClassProperties;
import com.stimulsoft.base.serializing.StiDocumentItemAttribut;
import com.stimulsoft.base.serializing.StiDocumentItemAttributes;
import com.stimulsoft.base.serializing.StiProperties;
import com.stimulsoft.base.serializing.StiProperty;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.StiSerializerReport;
import com.stimulsoft.base.serializing.interfaceobject.IStiForceSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToAttributes;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToDocument;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.serializing.xmlelements.ItemInDocumentElement;
import com.stimulsoft.lib.commoninterface.IStiName;
import java.util.List;

public class StiSerializerDocument
extends StiSerializerReport {
    private ItemCounter itemCounter;

    StiSerializerDocument(StiSerializerControler helper, StiBranch branch, IStiSerializableRef instance, boolean enhanced, boolean forceDocumentSerialize) {
        super(helper, branch, instance, enhanced, forceDocumentSerialize);
    }

    StiSerializerDocument(StiSerializerControler helper, StiBranch branch, IStiSerializable instance, boolean enhanced, boolean forceDocumentSerialize) {
        super(helper, branch, instance, enhanced, forceDocumentSerialize);
    }

    @Override
    protected void serializeObjectCollection(List<IStiSerializableRef> refs) {
        StiBranch newBranch = this.createListBranch();
        this.itemCounter = new ItemCounter();
        for (IStiSerializable object : (List)this.getPropertyValue()) {
            boolean forceSerializeToReport;
            if (object == null) continue;
            boolean bl = forceSerializeToReport = object instanceof IStiForceSerializable && ((IStiForceSerializable)((Object)object)).isForceSerializeToReport();
            if (StiSerializerUtil.isSerializableToDocument(object) && !forceSerializeToReport) {
                this.serializeItemInDocument(newBranch, object, this.itemCounter, refs);
                continue;
            }
            if (forceSerializeToReport) {
                newBranch.getRootElement().setAttribute("forceSerializeToReport", "true");
            }
            this.serializeParentInCollection(newBranch, object, refs);
        }
    }

    private void serializeItemInDocument(StiBranch newBranch, Object object, ItemCounter itemCounter, List<IStiSerializableRef> refs) {
        IStiSerializableToAttributes objToDocument = (IStiSerializableToAttributes)object;
        this.getControler().setNextReferenceForParent(objToDocument, refs);
        StiDocumentItemAttributes attributes = this.getAttributes(objToDocument);
        newBranch.appendChild(new ItemInDocumentElement(this.getControler(), itemCounter.getName(), attributes));
    }

    private StiDocumentItemAttributes getAttributes(IStiSerializableToAttributes instance) {
        StiDocumentItemAttributes result = new StiDocumentItemAttributes(instance);
        StiProperties propertysDocument = StiClassProperties.getPropertys(instance);
        for (StiProperty property : propertysDocument.getProperties()) {
            StiDocumentItemAttribut attribut = this.processingProperty(instance, property);
            result.addNotDefault(attribut);
        }
        return result;
    }

    private StiDocumentItemAttribut processingProperty(IStiSerializableToAttributes instance, StiProperty property) {
        StiDocumentItemAttribut result = StiDocumentItemAttribut.DEFAULT;
        boolean serializable = this.isSerializableProperty(property);
        Object value = property.getReturnValue(instance);
        boolean defaulValue = property.isDefaulValue(value);
        if (value != null && serializable && !defaulValue) {
            String name = property.getShorNameOrName();
            if (property.isObject()) {
                if (value instanceof IStiSerializableToString) {
                    result = new StiDocumentItemAttribut(name, (IStiSerializableToString)value);
                } else if (value instanceof IStiSerializableToDocument) {
                    result = new StiDocumentItemAttribut(name, ((IStiSerializableToDocument)value).serialize());
                }
            } else {
                result = property.isCollection() ? StiDocumentItemAttribut.DEFAULT : new StiDocumentItemAttribut(name, value);
            }
        }
        return result;
    }

    @Override
    protected boolean isSerializableProperty(StiProperty property) {
        return property.isSerializableToDocument(this.forceDocumentSerialize);
    }

    @Override
    protected String getPropertyName() {
        return this.getMdcPropertyName(super.getPropertyName());
    }

    @Override
    protected String getNamePropertyInCollection(IStiSerializableRef serializable) {
        if (this.isInterfaceIStiName(serializable)) {
            return this.getMdcPropertyName(super.getNamePropertyInCollection(serializable));
        }
        return this.itemCounter.getName();
    }

    private boolean isInterfaceIStiName(IStiSerializableRef serializable) {
        return IStiName.class.isAssignableFrom(serializable.getClass());
    }

    private String getMdcPropertyName(String propertyName) {
        return this.getCurrentProperty().getShorNameOrDefault(propertyName);
    }
}

