/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.serializing.CounterReference;
import com.stimulsoft.base.serializing.SerializeMode;
import com.stimulsoft.base.serializing.StiBranch;
import com.stimulsoft.base.serializing.StiSerializerDocument;
import com.stimulsoft.base.serializing.StiSerializerReport;
import com.stimulsoft.base.serializing.StiSerializerToXmlString;
import com.stimulsoft.base.serializing.UndefinedReference;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.serializing.xmlelements.BaseElement;
import com.stimulsoft.base.serializing.xmlelements.XMLSerializerRootElement;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class StiSerializerControler {
    private final Document document;
    private final UndefinedReference undefinedReference = new UndefinedReference();
    private final CounterReference counterReference = new CounterReference();
    private final SerializeMode serializeMode;
    private Hashtable<String, Object> memoryStore = new Hashtable();

    private StiSerializerControler(SerializeMode serializeMode) throws ParserConfigurationException {
        this.serializeMode = serializeMode;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        this.document.setXmlVersion("1.0");
    }

    public Element createElement(String propertyName) {
        try {
            return this.document.createElement(propertyName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to sreate Xml element '" + propertyName + "'", e);
        }
    }

    public void addUndefinedRef(Element xmlElement, IStiSerializableRef object) {
        this.undefinedReference.add(xmlElement, object);
    }

    public void addUndefinedRef(BaseElement element, IStiSerializableRef object) {
        this.undefinedReference.add(element.getXmlElement(), object);
    }

    private int getNextReference() {
        return this.counterReference.getNextReference();
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public static void serializeReport(IStiSerializableRef report, File file) {
        StiSerializerControler.serializeReport(report, file.getAbsolutePath());
    }

    public static void serializeReport(IStiSerializableRef instance, String fileName) {
        try {
            StiSerializerControler controler = StiSerializerControler.serializeRep(instance, false);
            controler.saveResult(fileName, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Hashtable<String, Object> serializeReport(IStiSerializableRef instance, OutputStream os, boolean formatOutput, boolean enhanced) {
        try {
            StiSerializerControler controler = StiSerializerControler.serializeRep(instance, enhanced);
            controler.saveResult(os, formatOutput);
            return controler.memoryStore;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static StiSerializerControler serializeRep(IStiSerializableRef instance, boolean enhanced) {
        ArrayList<IStiSerializableRef> refs = new ArrayList<IStiSerializableRef>();
        try {
            block8: {
                if (instance.getClass().toString().contains("com.stimulsoft.report.StiReport")) {
                    try {
                        Method setReportChanged = Class.forName("com.stimulsoft.report.StiReport").getMethod("setReportChanged", Calendar.class);
                        setReportChanged.invoke((Object)instance, Calendar.getInstance());
                    }
                    catch (Exception e) {
                        if (StiLoggingUtil.getLogLevel() < 10) break block8;
                        e.printStackTrace();
                    }
                }
            }
            StiSerializerControler controler = new StiSerializerControler(SerializeMode.report);
            StiBranch branch = controler.getRootElement("StiReport", null).createNewBranch();
            controler.document.appendChild(branch.getRootElement());
            StiSerializerReport stiSerializerReport = new StiSerializerReport(controler, branch, instance, enhanced, false);
            stiSerializerReport.serialize(refs);
            controler.undefinedReference.updateReference();
            controler.memoryStore.putAll(stiSerializerReport.getMemoryStore());
            StiSerializerControler stiSerializerControler = controler;
            return stiSerializerControler;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StiSerializerControler.resetRefs(refs);
        }
    }

    public static void serializeDocument(IStiSerializableRef instance, File file, boolean formatOutput) {
        StiSerializerControler.serializeDocument(instance, file.getAbsolutePath(), formatOutput);
    }

    public static void serializeDocument(IStiSerializableRef instance, String fileName, boolean formatOutput) {
        ArrayList<IStiSerializableRef> refs = new ArrayList<IStiSerializableRef>();
        try {
            StiSerializerControler controler = new StiSerializerControler(SerializeMode.document);
            StiBranch branch = controler.getRootElement("StiDocument", null).createNewBranch();
            controler.document.appendChild(branch.getRootElement());
            new StiSerializerDocument(controler, branch, instance, false, false).serialize(refs);
            controler.undefinedReference.updateReference();
            controler.saveResult(fileName, formatOutput);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StiSerializerControler.resetRefs(refs);
        }
    }

    public static void serializeDocument(IStiSerializableRef instance, OutputStream outputStream) {
        StiSerializerControler.serializeDocument(instance, null, outputStream, false);
    }

    public static void serializeDocument(IStiSerializableRef instance, OutputStream outputStream, boolean formatOutput) {
        StiSerializerControler.serializeDocument(instance, null, outputStream, formatOutput);
    }

    public static void serializeDocument(IStiSerializableRef instance, String isDocument, OutputStream outputStream) {
        StiSerializerControler.serializeDocument(instance, isDocument, outputStream, false);
    }

    public static void serializeDocument(IStiSerializableRef instance, String isDocument, OutputStream outputStream, boolean formatOutput) {
        StiSerializerControler.serializeDocument(instance, isDocument, outputStream, formatOutput, false);
    }

    public static void serializeDocument(IStiSerializableRef instance, String isDocument, OutputStream outputStream, boolean formatOutput, boolean enhanced) {
        StiSerializerControler.serializeDocument(instance, isDocument, outputStream, formatOutput, enhanced, false);
    }

    public static void serializeDocument(IStiSerializableRef instance, String isDocument, OutputStream outputStream, boolean formatOutput, boolean enhanced, boolean forceDocumentSerialize) {
        ArrayList<IStiSerializableRef> refs = new ArrayList<IStiSerializableRef>();
        try {
            StiSerializerControler controler = new StiSerializerControler(SerializeMode.document);
            StiBranch branch = controler.getRootElement("StiDocument", isDocument).createNewBranch();
            controler.document.appendChild(branch.getRootElement());
            new StiSerializerDocument(controler, branch, instance, enhanced, forceDocumentSerialize).serialize(refs);
            controler.undefinedReference.updateReference();
            controler.saveResult(outputStream, formatOutput);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StiSerializerControler.resetRefs(refs);
        }
    }

    private static void resetRefs(List<IStiSerializableRef> refs) {
        for (IStiSerializableRef ref : refs) {
            ref.setReference(-1);
        }
    }

    public static String serializedObjectAsString(IStiSerializable instance) {
        return StiSerializerControler.serializedObjectAsString(instance, "State");
    }

    public static String serializedObjectAsString(IStiSerializable instance, String application) {
        ArrayList<IStiSerializableRef> refs = new ArrayList<IStiSerializableRef>();
        try {
            StiSerializerControler controler = new StiSerializerControler(SerializeMode.xmlString);
            StiBranch branch = controler.getRootElement(application, null).createNewBranch();
            controler.document.appendChild(branch.getRootElement());
            new StiSerializerToXmlString(controler, branch, instance, false, false).serialize(refs);
            controler.undefinedReference.updateReference();
            String string = StiXmlUtil.convertXMLFileToString((Document)controler.document);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StiSerializerControler.resetRefs(refs);
        }
    }

    private XMLSerializerRootElement getRootElement(String atributeApplication, String isDocument) {
        return new XMLSerializerRootElement(this, atributeApplication, isDocument);
    }

    private void saveResult(String fileName, boolean formatOutput) throws IOException, TransformerException {
        StiXmlUtil.saveDocumentInFile((Document)this.document, (String)fileName, (boolean)formatOutput);
    }

    private void saveResult(OutputStream outputStream, boolean formatOutput) throws IOException, TransformerException {
        StiXmlUtil.xmlDocumentToOutputStream((Document)this.document, (OutputStream)outputStream, (boolean)formatOutput);
    }

    public void setNextReferenceForParent(IStiSerializableRef serializableParent, List<IStiSerializableRef> refs) {
        serializableParent.setReference(this.getNextReference());
        refs.add(serializableParent);
    }

    public void serializeBranch(StiBranch branch, IStiSerializableRef serializableParent, List<IStiSerializableRef> refs, boolean enhanced) {
        switch (this.serializeMode) {
            case report: {
                StiSerializerReport serializer = new StiSerializerReport(this, branch, serializableParent, enhanced, false);
                serializer.serialize(refs);
                this.memoryStore.putAll(serializer.getMemoryStore());
                break;
            }
            case document: {
                StiSerializerDocument serializer2 = new StiSerializerDocument(this, branch, serializableParent, enhanced, false);
                serializer2.serialize(refs);
                this.memoryStore.putAll(serializer2.getMemoryStore());
                break;
            }
            case xmlString: {
                new StiSerializerToXmlString(this, branch, serializableParent, enhanced, false).serialize(refs);
                break;
            }
            default: {
                throw new RuntimeException("Serialization mode not defined");
            }
        }
    }
}

