/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiValidationUtil;

public class TimeSpanRange
extends Range {
    public StiTimeSpan From = null;
    public StiTimeSpan To = null;

    public TimeSpanRange() {
    }

    public TimeSpanRange(StiTimeSpan from, StiTimeSpan to) {
        this.From = from;
        this.To = to;
    }

    public TimeSpanRange(long from, long to) {
        this.From = new StiTimeSpan(from);
        this.To = new StiTimeSpan(to);
    }

    public final StiTimeSpan getFromTime() {
        if (this.From == null) {
            return StiTimeSpan.ZERO;
        }
        return this.From;
    }

    public final StiTimeSpan getToTime() {
        if (this.From == null) {
            return StiTimeSpan.ZERO;
        }
        return this.To;
    }

    @Override
    public String getRangeName() {
        return "TimeSpanRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemTimeSpan;
    }

    @Override
    public Object getFromObject() {
        return this.From;
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof StiTimeSpan) {
            this.From = (StiTimeSpan)value;
        }
    }

    @Override
    public Object getToObject() {
        return this.To;
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof StiTimeSpan) {
            this.To = (StiTimeSpan)value;
        }
    }

    public final boolean Contains(StiTimeSpan value) {
        if (this.From == null && this.To == null) {
            return true;
        }
        if (this.From == null && this.To != null) {
            return this.To.getTicks() >= value.getTicks();
        }
        if (this.From != null && this.To == null) {
            return this.From.getTicks() <= value.getTicks();
        }
        return this.From.getTicks() <= value.getTicks() && this.To.getTicks() >= value.getTicks();
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        String strFrom = StiXMLConvert.decodeName(values[1]).trim();
        String strTo = StiXMLConvert.decodeName(values[2]).trim();
        this.From = StiValidationUtil.isNullOrEmpty((String)strFrom) ? null : StiTimeSpan.valueOf(strFrom);
        this.To = StiValidationUtil.isNullOrEmpty((String)strTo) ? null : StiTimeSpan.valueOf(strTo);
    }

    @Override
    protected String getSerializeName() {
        return "TimeSpan";
    }

    public static TimeSpanRange fromSerializeValue(String str) {
        TimeSpanRange resulty = new TimeSpanRange();
        resulty.deserialize(str);
        return resulty;
    }
}

