/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;

public class ShortRange
extends Range {
    public short From = 0;
    public short To = 0;

    @Override
    public String getRangeName() {
        return "ShortRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemInt16;
    }

    @Override
    public Object getFromObject() {
        return this.From;
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof Short) {
            this.From = (Short)value;
        }
    }

    @Override
    public Object getToObject() {
        return this.To;
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof Short) {
            this.To = (Short)value;
        }
    }

    public final boolean Contains(short value) {
        return this.From <= value && this.To >= value;
    }

    public ShortRange() {
    }

    public ShortRange(short from, short to) {
        this.From = from;
        this.To = to;
    }

    @Override
    public String serialize() {
        String data = String.format(this.getSerializeName() + ",%s,%s", this.getFromObject(), this.getToObject());
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.From = (short)StiSerializTypeConverter.stringToInt(values[1]);
        this.To = (short)StiSerializTypeConverter.stringToInt(values[2]);
    }

    @Override
    protected String getSerializeName() {
        return "Short";
    }

    public static ShortRange fromSerializeValue(String str) {
        ShortRange result = new ShortRange();
        result.deserialize(str);
        return result;
    }
}

