/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.mail;

import com.stimulsoft.base.mail.StiMailProperties;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class StiMailSender {
    public static void sendMail(final StiMailProperties properties) throws AddressException, MessagingException, IOException {
        MimeBodyPart fileMail;
        MimeMultipart contentMultipart;
        MimeMultipart rootMultipart;
        Properties props = new Properties();
        props.put("mail.smtp.host", properties.getHost());
        props.put("mail.smtp.auth", properties.getSmtpNeedAuth());
        props.put("mail.smtp.port", (Object)properties.getSmtpPort());
        props.put("mail.smtp.timeout", "200000");
        if (properties.isMailDebug()) {
            props.put("session.debug", "true");
            props.put("mail.debug", "true");
        }
        if (properties.getUseSSL().booleanValue()) {
            props.put("mail.smtp.socketFactory.port", (Object)properties.getSmtpPort());
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        } else {
            props.put("mail.smtp.starttls.enable", "true");
        }
        Session session = properties.getSmtpNeedAuth() != false ? Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(properties.getUserName(), properties.getPassword());
            }
        }) : Session.getDefaultInstance((Properties)props);
        if (properties.getAttachments().isEmpty() && properties.getStreamAttachments().isEmpty()) {
            contentMultipart = rootMultipart = new MimeMultipart("alternative");
        } else {
            rootMultipart = new MimeMultipart();
            contentMultipart = new MimeMultipart("alternative");
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            contentPartRoot.setContent((Multipart)contentMultipart);
            rootMultipart.addBodyPart((BodyPart)contentPartRoot);
        }
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)properties.getBody(), "text/plain; charset=UTF-8");
        contentMultipart.addBodyPart((BodyPart)textPart);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(properties.getFrom()));
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)properties.getRecipients()));
        message.setSubject(properties.getSubject());
        for (File attachment : properties.getAttachments()) {
            fileMail = new MimeBodyPart();
            fileMail.attachFile(attachment);
            rootMultipart.addBodyPart((BodyPart)fileMail);
        }
        for (StiMailProperties.StiStreamAttachment attachemnt : properties.getStreamAttachments()) {
            fileMail = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(attachemnt.getStream(), "attachment/file");
            fileMail.setDataHandler(new DataHandler((DataSource)source));
            fileMail.setFileName(attachemnt.getName());
            rootMultipart.addBodyPart((BodyPart)fileMail);
        }
        message.setContent((Multipart)rootMultipart);
        message.setSentDate(new Date());
        Transport.send((Message)message);
    }
}

