/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;

public class StiHatchBrush
extends StiBrush {
    private StiColor backColor;
    private StiColor foreColor;
    private BufferedImage image;
    private TexturePaint paint;
    private StiHatchStyle style;

    public final StiColor getBackColor() {
        return this.backColor;
    }

    public final void setBackColor(StiColor value) {
        this.backColor = value;
        this.invalidate();
    }

    @Override
    public String serialize() {
        return MessageFormat.format("HatchBrush,{0},{1},{2}", this.style.name(), this.foreColor.serializeString(), this.backColor.serializeString());
    }

    @Override
    public void deserialize(String value) {
        String[] values = value.split(",");
        this.style = StiHatchStyle.valueOf(values[1]);
        this.foreColor = StiColor.deserializeString(values[2]);
        this.backColor = StiColor.deserializeString(values[3]);
    }

    public final StiColor getForeColor() {
        return this.foreColor;
    }

    public final void setForeColor(StiColor value) {
        this.foreColor = value;
        this.invalidate();
    }

    public final StiHatchStyle getStyle() {
        return this.style;
    }

    public final void setStyle(StiHatchStyle value) {
        this.style = value;
        this.invalidate();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiHatchBrush brush = (StiHatchBrush)(obj instanceof StiHatchBrush ? obj : null);
        if (brush == null) {
            return false;
        }
        if (this.backColor != brush.backColor) {
            return false;
        }
        if (this.foreColor != brush.foreColor) {
            return false;
        }
        return this.style.equals((Object)brush.style);
    }

    private boolean shouldSerializeBackColor() {
        return this.backColor != StiColor.White;
    }

    private boolean shouldSerializeForeColor() {
        return this.foreColor != StiColor.Black;
    }

    private boolean shouldSerializeStyle() {
        return this.style != StiHatchStyle.BackwardDiagonal;
    }

    public StiHatchBrush() {
        this.style = StiHatchStyle.BackwardDiagonal;
        this.backColor = StiColor.Black;
        this.foreColor = StiColor.White;
    }

    public StiHatchBrush(StiHatchStyle style, StiColor foreColor, StiColor backColor) {
        this.style = style;
        this.foreColor = foreColor;
        this.backColor = backColor;
    }

    public StiHatchBrush(StiHatchStyle style, StiColorEnum foreColor, StiColorEnum backColor) {
        this(style, foreColor.color(), backColor.color());
    }

    public Paint getPaint() {
        if (this.image == null) {
            this.image = new BufferedImage(8, 8, 2);
            Graphics2D g = this.image.createGraphics();
            g.setColor(this.backColor.getAwtColor());
            g.fillRect(0, 0, 8, 8);
            if (this.style.equals((Object)StiHatchStyle.BackwardDiagonal)) {
                this.drawBackwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.LargeGrid)) {
                this.drawLargeGrid();
            } else if (this.style.equals((Object)StiHatchStyle.DarkDownwardDiagonal)) {
                this.drawDarkDownwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.DarkHorizontal)) {
                this.drawDarkHorizontal();
            } else if (this.style.equals((Object)StiHatchStyle.DarkUpwardDiagonal)) {
                this.drawDarkUpwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.DarkVertical)) {
                this.drawDarkVertical();
            } else if (this.style.equals((Object)StiHatchStyle.DashedDownwardDiagonal)) {
                this.drawDashedDownwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.DashedHorizontal)) {
                this.drawDashedHorizontal();
            } else if (this.style.equals((Object)StiHatchStyle.DashedUpwardDiagonal)) {
                this.drawDashedUpwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.DashedVertical)) {
                this.drawDashedVertical();
            } else if (this.style.equals((Object)StiHatchStyle.DiagonalBrick)) {
                this.drawDiagonalBrick();
            } else if (this.style.equals((Object)StiHatchStyle.DiagonalCross)) {
                this.drawDiagonalCross();
            } else if (this.style.equals((Object)StiHatchStyle.Divot)) {
                this.drawDivot();
            } else if (this.style.equals((Object)StiHatchStyle.DottedDiamond)) {
                this.drawDottedDiamond();
            } else if (this.style.equals((Object)StiHatchStyle.DottedGrid)) {
                this.drawDottedGrid();
            } else if (this.style.equals((Object)StiHatchStyle.ForwardDiagonal)) {
                this.drawForwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.Horizontal)) {
                this.drawHorizontal();
            } else if (this.style.equals((Object)StiHatchStyle.HorizontalBrick)) {
                this.drawHorizontalBrick();
            } else if (this.style.equals((Object)StiHatchStyle.LargeCheckerBoard)) {
                this.drawLargeCheckerBoard();
            } else if (this.style.equals((Object)StiHatchStyle.LargeConfetti)) {
                this.drawLargeConfetti();
            } else if (this.style.equals((Object)StiHatchStyle.LightDownwardDiagonal)) {
                this.drawLightDownwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.LightHorizontal)) {
                this.drawLightHorizontal();
            } else if (this.style.equals((Object)StiHatchStyle.LightUpwardDiagonal)) {
                this.drawLightUpwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.LightVertical)) {
                this.drawLightVertical();
            } else if (this.style.equals((Object)StiHatchStyle.NarrowHorizontal)) {
                this.drawNarrowHorizontal();
            } else if (this.style.equals((Object)StiHatchStyle.NarrowVertical)) {
                this.drawNarrowVertical();
            } else if (this.style.equals((Object)StiHatchStyle.OutlinedDiamond)) {
                this.drawOutlinedDiamond();
            } else if (this.style.equals((Object)StiHatchStyle.Percent05)) {
                this.drawPercent05();
            } else if (this.style.equals((Object)StiHatchStyle.Percent10)) {
                this.drawPercent10();
            } else if (this.style.equals((Object)StiHatchStyle.Percent20)) {
                this.drawPercent20();
            } else if (this.style.equals((Object)StiHatchStyle.Percent25)) {
                this.drawPercent25();
            } else if (this.style.equals((Object)StiHatchStyle.Percent30)) {
                this.drawPercent30();
            } else if (this.style.equals((Object)StiHatchStyle.Percent40)) {
                this.drawPercent40();
            } else if (this.style.equals((Object)StiHatchStyle.Percent50)) {
                this.drawPercent50();
            } else if (this.style.equals((Object)StiHatchStyle.Percent60)) {
                this.drawPercent60();
            } else if (this.style.equals((Object)StiHatchStyle.Percent70)) {
                this.drawPercent70();
            } else if (this.style.equals((Object)StiHatchStyle.Percent75)) {
                this.drawPercent75();
            } else if (this.style.equals((Object)StiHatchStyle.Percent80)) {
                this.drawPercent80();
            } else if (this.style.equals((Object)StiHatchStyle.Percent90)) {
                this.drawPercent90();
            } else if (this.style.equals((Object)StiHatchStyle.Plaid)) {
                this.drawPlaid();
            } else if (this.style.equals((Object)StiHatchStyle.Shingle)) {
                this.drawShingle();
            } else if (this.style.equals((Object)StiHatchStyle.SmallCheckerBoard)) {
                this.drawSmallCheckerBoard();
            } else if (this.style.equals((Object)StiHatchStyle.SmallConfetti)) {
                this.drawSmallConfetti();
            } else if (this.style.equals((Object)StiHatchStyle.SmallGrid)) {
                this.drawSmallGrid();
            } else if (this.style.equals((Object)StiHatchStyle.SolidDiamond)) {
                this.drawSolidDiamond();
            } else if (this.style.equals((Object)StiHatchStyle.Sphere)) {
                this.drawSphere();
            } else if (this.style.equals((Object)StiHatchStyle.Trellis)) {
                this.drawTrellis();
            } else if (this.style.equals((Object)StiHatchStyle.Vertical)) {
                this.drawVertical();
            } else if (this.style.equals((Object)StiHatchStyle.Weave)) {
                this.drawWeave();
            } else if (this.style.equals((Object)StiHatchStyle.WideDownwardDiagonal)) {
                this.drawWideDownwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.WideUpwardDiagonal)) {
                this.drawWideUpwardDiagonal();
            } else if (this.style.equals((Object)StiHatchStyle.ZigZag)) {
                this.drawZigZag();
            }
            this.paint = new TexturePaint(this.image, new Rectangle(0, 0, 8, 8));
            g.dispose();
        }
        return this.paint;
    }

    private void drawBackwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        StiColor color = new StiColor();
        color.setR(this.backColor.getR() + (this.foreColor.getR() - this.backColor.getR()) / 3);
        color.setG(this.backColor.getG() + (this.foreColor.getG() - this.backColor.getG()) / 3);
        color.setB(this.backColor.getB() + (this.foreColor.getB() - this.backColor.getB()) / 3);
        int gc = color.getAwtColor().getRGB();
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(6, 0, gc);
        this.image.setRGB(5, 1, gc);
        this.image.setRGB(4, 2, gc);
        this.image.setRGB(3, 3, gc);
        this.image.setRGB(2, 4, gc);
        this.image.setRGB(1, 5, gc);
        this.image.setRGB(0, 6, gc);
        this.image.setRGB(7, 1, gc);
        this.image.setRGB(6, 2, gc);
        this.image.setRGB(5, 3, gc);
        this.image.setRGB(4, 4, gc);
        this.image.setRGB(3, 5, gc);
        this.image.setRGB(2, 6, gc);
        this.image.setRGB(1, 7, gc);
        this.image.setRGB(0, 0, gc);
        this.image.setRGB(7, 7, gc);
    }

    private void drawLargeGrid() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(7, 1, fc);
        this.image.setRGB(7, 2, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(7, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(1, 7, fc);
        this.image.setRGB(2, 7, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(5, 7, fc);
        this.image.setRGB(6, 7, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawDarkDownwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(7, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(7, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(3, 6, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(3, 7, fc);
    }

    private void drawDarkHorizontal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(7, 1, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(7, 5, fc);
    }

    private void drawDarkUpwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawDarkVertical() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(1, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(5, 3, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(5, 7, fc);
    }

    private void drawDashedDownwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 3, fc);
    }

    private void drawDashedHorizontal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
    }

    private void drawDashedUpwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(4, 3, fc);
    }

    private void drawDashedVertical() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(4, 7, fc);
    }

    private void drawDiagonalBrick() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(0, 7, fc);
    }

    private void drawDiagonalCross() {
        int fc = this.foreColor.getAwtColor().getRGB();
        StiColor color = new StiColor(this.foreColor.getR() + (this.backColor.getR() + this.foreColor.getR()) * 200 / 255, this.foreColor.getG() + (this.backColor.getG() + this.foreColor.getG()) * 200 / 255, this.foreColor.getB() + (this.backColor.getB() + this.foreColor.getB()) * 200 / 255);
        int gc = color.getAwtColor().getRGB();
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(0, 1, gc);
        this.image.setRGB(1, 2, gc);
        this.image.setRGB(2, 3, gc);
        this.image.setRGB(2, 4, gc);
        this.image.setRGB(1, 5, gc);
        this.image.setRGB(0, 6, gc);
        this.image.setRGB(1, 0, gc);
        this.image.setRGB(2, 1, gc);
        this.image.setRGB(3, 2, gc);
        this.image.setRGB(4, 2, gc);
        this.image.setRGB(5, 1, gc);
        this.image.setRGB(6, 0, gc);
        this.image.setRGB(7, 1, gc);
        this.image.setRGB(6, 2, gc);
        this.image.setRGB(5, 3, gc);
        this.image.setRGB(5, 4, gc);
        this.image.setRGB(6, 5, gc);
        this.image.setRGB(7, 6, gc);
        this.image.setRGB(1, 7, gc);
        this.image.setRGB(2, 6, gc);
        this.image.setRGB(3, 5, gc);
        this.image.setRGB(4, 5, gc);
        this.image.setRGB(5, 6, gc);
        this.image.setRGB(6, 7, gc);
    }

    private void drawDivot() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(6, 7, fc);
    }

    private void drawDottedDiamond() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(6, 6, fc);
    }

    private void drawDottedGrid() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(0, 6, fc);
    }

    private void drawForwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        StiColor color = new StiColor();
        color.setR(this.backColor.getR() + (this.foreColor.getR() - this.backColor.getR()) / 3);
        color.setG(this.backColor.getG() + (this.foreColor.getG() - this.backColor.getG()) / 3);
        color.setB(this.backColor.getB() + (this.foreColor.getB() - this.backColor.getB()) / 3);
        int gc = color.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(1, 0, gc);
        this.image.setRGB(2, 1, gc);
        this.image.setRGB(3, 2, gc);
        this.image.setRGB(4, 3, gc);
        this.image.setRGB(5, 4, gc);
        this.image.setRGB(6, 5, gc);
        this.image.setRGB(7, 6, gc);
        this.image.setRGB(7, 0, gc);
        this.image.setRGB(0, 1, gc);
        this.image.setRGB(1, 2, gc);
        this.image.setRGB(2, 3, gc);
        this.image.setRGB(3, 4, gc);
        this.image.setRGB(4, 5, gc);
        this.image.setRGB(5, 6, gc);
        this.image.setRGB(6, 7, gc);
        this.image.setRGB(0, 7, gc);
    }

    private void drawHorizontal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 0, fc);
    }

    private void drawHorizontalBrick() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(5, 7, fc);
    }

    private void drawLargeCheckerBoard() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 6, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(5, 7, fc);
        this.image.setRGB(6, 7, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawLargeConfetti() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(5, 7, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(2, 6, fc);
    }

    private void drawLightDownwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(3, 7, fc);
    }

    private void drawLightHorizontal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
    }

    private void drawLightUpwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(4, 7, fc);
    }

    private void drawLightVertical() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(4, 7, fc);
    }

    private void drawNarrowHorizontal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 2, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(3, 6, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 6, fc);
    }

    private void drawNarrowVertical() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(2, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(6, 3, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(6, 7, fc);
    }

    private void drawOutlinedDiamond() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(7, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(5, 3, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(1, 7, fc);
    }

    private void drawPercent05() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(4, 4, fc);
    }

    private void drawPercent10() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(4, 6, fc);
    }

    private void drawPercent20() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(6, 6, fc);
    }

    private void drawPercent25() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(2, 7, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(6, 3, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(6, 7, fc);
    }

    private void drawPercent30() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(4, 6, fc);
    }

    private void drawPercent40() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(5, 3, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(5, 7, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 1, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(1, 7, fc);
    }

    private void drawPercent50() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(5, 3, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(5, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 1, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(1, 7, fc);
    }

    private void drawPercent60() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(5, 3, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(5, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 1, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(1, 7, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(6, 3, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(2, 7, fc);
        this.image.setRGB(6, 7, fc);
    }

    private void drawPercent70() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(2, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(6, 3, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(6, 7, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(7, 1, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawPercent75() {
        this.image.getGraphics().setColor(this.foreColor.getAwtColor());
        this.image.getGraphics().fillRect(0, 0, 8, 8);
        int bc = this.backColor.getAwtColor().getRGB();
        this.image.setRGB(2, 1, bc);
        this.image.setRGB(6, 1, bc);
        this.image.setRGB(0, 3, bc);
        this.image.setRGB(4, 3, bc);
        this.image.setRGB(2, 5, bc);
        this.image.setRGB(6, 5, bc);
        this.image.setRGB(0, 7, bc);
        this.image.setRGB(4, 7, bc);
    }

    private void drawPercent80() {
        Graphics2D g = this.image.createGraphics();
        g.setColor(this.foreColor.getAwtColor());
        g.fillRect(0, 0, 8, 8);
        int bc = this.backColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, bc);
        this.image.setRGB(0, 4, bc);
        this.image.setRGB(4, 2, bc);
        this.image.setRGB(4, 6, bc);
    }

    private void drawPercent90() {
        Graphics2D g = this.image.createGraphics();
        g.setColor(this.foreColor.getAwtColor());
        g.fillRect(0, 0, 8, 8);
        int bc = this.backColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, bc);
        this.image.setRGB(4, 4, bc);
    }

    private void drawPlaid() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(1, 7, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(5, 7, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawShingle() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(7, 2, fc);
        this.image.setRGB(6, 3, fc);
        this.image.setRGB(5, 4, fc);
    }

    private void drawSmallCheckerBoard() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 2, fc);
        this.image.setRGB(6, 3, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(3, 6, fc);
        this.image.setRGB(2, 7, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 6, fc);
        this.image.setRGB(6, 7, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawSmallConfetti() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(3, 7, fc);
    }

    private void drawSmallGrid() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
    }

    private void drawSolidDiamond() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(5, 3, fc);
        this.image.setRGB(6, 3, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(3, 6, fc);
    }

    private void drawSphere() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 0, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(5, 0, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(4, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(1, 4, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 4, fc);
        this.image.setRGB(7, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(7, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(4, 6, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(4, 7, fc);
        this.image.setRGB(5, 7, fc);
        this.image.setRGB(6, 7, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawTrellis() {
        Graphics2D g = this.image.createGraphics();
        g.setColor(this.foreColor.getAwtColor());
        g.fillRect(0, 0, 8, 8);
        int bc = this.backColor.getAwtColor().getRGB();
        this.image.setRGB(2, 0, bc);
        this.image.setRGB(3, 0, bc);
        this.image.setRGB(6, 0, bc);
        this.image.setRGB(7, 0, bc);
        this.image.setRGB(0, 2, bc);
        this.image.setRGB(1, 2, bc);
        this.image.setRGB(4, 2, bc);
        this.image.setRGB(5, 2, bc);
        this.image.setRGB(2, 4, bc);
        this.image.setRGB(3, 4, bc);
        this.image.setRGB(6, 4, bc);
        this.image.setRGB(7, 4, bc);
        this.image.setRGB(0, 6, bc);
        this.image.setRGB(1, 6, bc);
        this.image.setRGB(4, 6, bc);
        this.image.setRGB(5, 6, bc);
    }

    private void drawVertical() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(0, 2, fc);
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(0, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(0, 7, fc);
    }

    private void drawWeave() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(3, 1, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(1, 3, fc);
        this.image.setRGB(5, 3, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(0, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(1, 7, fc);
        this.image.setRGB(3, 7, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawWideDownwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(1, 1, fc);
        this.image.setRGB(2, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
        this.image.setRGB(1, 0, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(3, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(5, 4, fc);
        this.image.setRGB(6, 5, fc);
        this.image.setRGB(7, 6, fc);
        this.image.setRGB(0, 1, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(2, 3, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(4, 5, fc);
        this.image.setRGB(5, 6, fc);
        this.image.setRGB(6, 7, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(7, 0, fc);
    }

    private void drawWideUpwardDiagonal() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(7, 0, fc);
        this.image.setRGB(6, 1, fc);
        this.image.setRGB(5, 2, fc);
        this.image.setRGB(4, 3, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(6, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(4, 2, fc);
        this.image.setRGB(3, 3, fc);
        this.image.setRGB(2, 4, fc);
        this.image.setRGB(1, 5, fc);
        this.image.setRGB(0, 6, fc);
        this.image.setRGB(7, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(5, 3, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(3, 5, fc);
        this.image.setRGB(2, 6, fc);
        this.image.setRGB(1, 7, fc);
        this.image.setRGB(0, 0, fc);
        this.image.setRGB(7, 7, fc);
    }

    private void drawZigZag() {
        int fc = this.foreColor.getAwtColor().getRGB();
        this.image.setRGB(0, 3, fc);
        this.image.setRGB(1, 2, fc);
        this.image.setRGB(2, 1, fc);
        this.image.setRGB(3, 0, fc);
        this.image.setRGB(4, 0, fc);
        this.image.setRGB(5, 1, fc);
        this.image.setRGB(6, 2, fc);
        this.image.setRGB(7, 3, fc);
        this.image.setRGB(0, 7, fc);
        this.image.setRGB(1, 6, fc);
        this.image.setRGB(2, 5, fc);
        this.image.setRGB(3, 4, fc);
        this.image.setRGB(4, 4, fc);
        this.image.setRGB(5, 5, fc);
        this.image.setRGB(6, 6, fc);
        this.image.setRGB(7, 7, fc);
    }

    public void LoadValuesFromJson(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("BackColor")) {
                this.backColor = StiJsonReportObjectHelper.Deserialize.Color(property.Value.toString());
                continue;
            }
            if (property.Name.equals("ForeColor")) {
                this.foreColor = StiJsonReportObjectHelper.Deserialize.Color(property.Value.toString());
                continue;
            }
            if (!property.Name.equals("Style")) continue;
            this.style = StiHatchStyle.valueOf(property.Value.toString());
        }
    }
}

