/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;

public class StiBorderSide
implements Cloneable {
    public StiBorderSides side = StiBorderSides.None;
    private StiColor color = StiColor.Black;
    private double size = 1.0;
    private StiPenStyle style = StiPenStyle.None;

    public final Object clone() {
        StiBorderSide obj = new StiBorderSide();
        obj.setColor(this.getColor().clone());
        obj.setSize(this.getSize());
        obj.setStyle(this.getStyle());
        return obj;
    }

    public boolean equals(Object obj) {
        StiBorderSide borderSide = (StiBorderSide)(obj instanceof StiBorderSide ? obj : null);
        if (borderSide == null) {
            return false;
        }
        if (!this.side.equals(borderSide.side)) {
            return false;
        }
        if (!this.color.equals(borderSide.color)) {
            return false;
        }
        if (this.size != borderSide.size) {
            return false;
        }
        return this.style.equals((Object)borderSide.style);
    }

    public String toString() {
        return "Side=" + this.size + " Color=" + this.color + " Size=" + this.size + " Style=" + (Object)((Object)this.style);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public StiColor getColor() {
        return this.color;
    }

    public void setColor(StiColor value) {
        this.color = value;
    }

    public float getSizeOffset() {
        if (this.style == StiPenStyle.None) {
            return 0.0f;
        }
        if (this.style == StiPenStyle.Double) {
            return 1.0f;
        }
        return (float)this.getSize() / 2.0f;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double value) {
        this.size = value;
    }

    public StiPenStyle getStyle() {
        return this.style;
    }

    public void setStyle(StiPenStyle value) {
        this.style = value;
    }

    public final boolean isDefault() {
        return this.getColor() == StiColor.Black && this.getSize() == 1.0 && this.getStyle() == StiPenStyle.None;
    }

    public StiBorderSide() {
        this(StiColor.Black, 1.0, StiPenStyle.None);
    }

    public StiBorderSide(StiColor color, double size, StiPenStyle style) {
        this.color = color;
        this.size = size;
        this.style = style;
    }
}

