/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.context.chart.geoms;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiGeomType;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.util.List;

public abstract class StiGeom
implements IStiJsonReportObject {
    public abstract StiGeomType getType();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.put("Ident", this.getClass().getName());
        jObject.put("Type", this.getType().toString());
        return jObject;
    }

    protected JSONObject[] SaveGeomListToJsonObject(List<StiSegmentGeom> geoms, StiJsonSaveMode mode) throws JSONException {
        if (geoms != null) {
            JSONObject[] jObjectGeoms = new JSONObject[geoms.size()];
            for (int index = 0; index < geoms.size(); ++index) {
                jObjectGeoms[index] = geoms.get(index).SaveToJsonObject(mode);
            }
            return jObjectGeoms;
        }
        return null;
    }

    protected JSONObject[] SavePointFArrayToJsonObject(StiPoint[] points) throws JSONException {
        if (points != null) {
            JSONObject[] jObjectPoints = new JSONObject[points.length];
            for (int index = 0; index < points.length; ++index) {
                jObjectPoints[index] = StiGeom.SavePointFToJsonObject(points[index]);
            }
            return jObjectPoints;
        }
        return null;
    }

    protected String SaveBrushToJsonObject(Object brush, StiJsonSaveMode mode) {
        if (brush instanceof StiColor) {
            StiColor color = (StiColor)brush;
            return String.format("Color,%s,%s,%s,%s", color.getA(), color.getR(), color.getG(), color.getB());
        }
        if (brush instanceof StiBrush) {
            return StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)brush);
        }
        return null;
    }

    protected JSONObject SaveRectToJsonObject(Object rect) throws JSONException {
        if (rect instanceof StiRectangle) {
            return StiGeom.SaveRectangleToJsonObject((StiRectangle)rect);
        }
        return null;
    }

    public static JSONObject SavePointFToJsonObject(StiPoint pos) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.put("X", pos.x);
        jObject.put("Y", pos.y);
        return jObject;
    }

    public static JSONObject SaveRectangleFToJsonObject(StiRectangle rect) throws JSONException {
        return StiGeom.SaveRectangleToJsonObject(rect);
    }

    public static JSONObject SaveRectangleDToJsonObject(StiRectangle rect) throws JSONException {
        return StiGeom.SaveRectangleToJsonObject(rect);
    }

    public static JSONObject SaveRectangleToJsonObject(StiRectangle rect) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.put("X", rect.x);
        jObject.put("Y", rect.y);
        jObject.put("Width", rect.width);
        jObject.put("Height", rect.height);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
    }
}

