/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.StiTokenType;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.Objects;

public class StiToken {
    public static StiToken EOF = new StiToken(StiTokenType.EOF, 0, 0);
    public int index;
    public int length;
    public StiTokenType type;
    public Object data;

    public boolean isKeyword() {
        return this.isKeyword(null);
    }

    public boolean isKeyword(String keyword) {
        return keyword == null ? this.type == StiTokenType.Keyword : this.type == StiTokenType.Keyword && StiValidationUtil.equals((Object)this.getDataAsString(), (Object)keyword);
    }

    public boolean isIdent() {
        return this.isIdent(null);
    }

    public boolean isIdent(String ident) {
        return ident == null ? this.type == StiTokenType.Ident : this.type == StiTokenType.Ident && Objects.equals(this.getDataAsString(), ident);
    }

    public boolean IsIdentOrKeyword() {
        return this.isIdent(null) || this.isKeyword(null);
    }

    public boolean IsAssign() {
        return this.type == StiTokenType.Assign;
    }

    public boolean IsDot() {
        return this.type == StiTokenType.Dot;
    }

    public boolean IsLBrace() {
        return this.type == StiTokenType.LBrace;
    }

    public boolean IsRBrace() {
        return this.type == StiTokenType.RBrace;
    }

    public boolean IsLBracket() {
        return this.type == StiTokenType.LBracket;
    }

    public boolean IsRBracket() {
        return this.type == StiTokenType.RBracket;
    }

    public boolean IsLPar() {
        return this.type == StiTokenType.LPar;
    }

    public boolean IsRPar() {
        return this.type == StiTokenType.RPar;
    }

    public String getDataAsString() {
        return this.data != null ? this.data.toString() : null;
    }

    public StiToken(StiTokenType type) {
        this(type, 0, 0);
    }

    public StiToken(StiTokenType type, int index, int length) {
        this.type = type;
        this.index = index;
        this.length = length;
    }

    public StiToken(StiTokenType type, int index, int length, char charValue) {
        this(type, index, length);
        this.data = Character.valueOf(charValue);
    }

    public StiToken(StiTokenType type, int index, int length, String stringValue) {
        this(type, index, length);
        this.data = stringValue;
    }

    public StiToken(StiTokenType type, int index, int length, Object obj) {
        this(type, index, length);
        this.data = obj;
    }

    public String toString() {
        switch (this.type) {
            case Value: {
                return this.type.toString() + "=" + this.data.toString();
            }
            case Ident: {
                return this.type.toString() + "(" + this.data.toString() + ")";
            }
        }
        return this.type.toString();
    }
}

