/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.drawing.FontV;
import com.stimulsoft.base.utils.StiLoggingUtil;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.util.HashMap;

public class StiFontCollection {
    private static HashMap<String, Font> fontVHash = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font addResourceFont(String name, byte[] content, String extension) {
        if (content != null && content.length > 0) {
            HashMap<String, Font> hashMap = fontVHash;
            synchronized (hashMap) {
                try {
                    String hash = FontV.getHashName(content);
                    Font fontV = fontVHash.get(hash);
                    if (fontV == null) {
                        fontV = Font.createFont(0, new ByteArrayInputStream(content));
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        ge.registerFont(fontV);
                        fontVHash.put(hash, fontV);
                    }
                    return fontV;
                }
                catch (Exception e) {
                    if (StiLoggingUtil.getLogLevel() >= 10) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeResourceFont(String name, byte[] content) {
        if (content == null || content.length == 0) {
            return;
        }
        HashMap<String, Font> hashMap = fontVHash;
        synchronized (hashMap) {
            String hash = FontV.getHashName(content);
            Font fontV = fontVHash.get(hash);
            if (fontV == null) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllResourceFonts() {
        HashMap<String, Font> hashMap = fontVHash;
        synchronized (hashMap) {
            fontVHash.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFontFamilyByContent(String name, byte[] content, String extension) {
        if (content == null || content.length == 0) {
            return null;
        }
        String hash = FontV.getHashName(content);
        HashMap<String, Font> hashMap = fontVHash;
        synchronized (hashMap) {
            Font font = fontVHash.get(hash);
            return font != null ? font.getFamily() : null;
        }
    }

    public static String getFontFamily(String fontName) {
        return StiFontCollection.getFontFamily(fontName, false);
    }

    public static String getFontFamily(String fontName, boolean allowNullResult) {
        Font font = new Font(fontName, 0, 1);
        String existFontName = font.getName();
        if (!existFontName.equals(fontName) && allowNullResult) {
            return null;
        }
        return existFontName;
    }

    public static boolean isCustomFont(String fontName) {
        if (fontName == null) {
            return false;
        }
        return fontVHash.containsKey(fontName);
    }
}

