/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.utils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class StiValidationUtil {
    public static final String EMPTY_STR = "";

    private StiValidationUtil() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(Object obj) {
        return obj == null || obj.toString().length() == 0;
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotEmpty(List<?> list) {
        return !StiValidationUtil.isEmpty(list);
    }

    public static boolean isNotEmpty(String str) {
        return !StiValidationUtil.isEmpty(str);
    }

    public static boolean isEmpty(Integer value) {
        return value == null;
    }

    public static boolean isNotEmpty(Integer value) {
        return !StiValidationUtil.isEmpty(value);
    }

    public static boolean isFalse(boolean expression) {
        return !expression;
    }

    public static boolean isNotEmpty(Object[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isBlank(String str) {
        if (StiValidationUtil.isEmpty(str)) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!StiValidationUtil.isFalse(Character.isWhitespace(str.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StiValidationUtil.isBlank(str);
    }

    public static void nothing() {
    }

    public static String correct(String value, String defValue) {
        return StiValidationUtil.isEmpty(value) ? defValue : value;
    }

    public static boolean isNullOrEmpty(String str) {
        return StiValidationUtil.isBlank(str);
    }

    public static boolean isNullOrWhiteSpace(String str) {
        return str != null ? StiValidationUtil.isBlank(str) || str.trim().length() == 0 : true;
    }

    public static boolean isNotNullOrEmpty(String str) {
        return !StiValidationUtil.isNullOrEmpty(str);
    }

    public static boolean isNotNumber(Object value) {
        return !StiValidationUtil.isNumber(value);
    }

    public static boolean isNumber(Object value) {
        try {
            new BigDecimal(value.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 == null && obj2 == null || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !StiValidationUtil.isEmpty(map);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }
}

