/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.io;

import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.io.StiLineIterator;
import com.stimulsoft.lib.io.StiUnicodeBOMInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.logging.Logger;

public class StiIOUtil {
    private static final Logger LOG = Logger.getLogger(StiIOUtil.class.getName());
    private static final String ENCODING = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private StiIOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeInputStream(OutputStream out, InputStream input) throws IOException {
        long length = 0L;
        try {
            length = StiIOUtil.copy(input, out);
            out.flush();
        }
        catch (Throwable throwable) {
            StiCloseUtil.close(input, out);
            throw throwable;
        }
        StiCloseUtil.close(input, out);
        return length;
    }

    public static InputStream print(InputStream input) throws IOException {
        String string = StiIOUtil.toString(input);
        LOG.severe("InputStream " + string);
        return StiIOUtil.toInputStream(string);
    }

    public static InputStream toInputStream(String string) throws IOException {
        return new ByteArrayInputStream(string.getBytes(ENCODING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer toStringBuffer(InputStream input) throws IOException {
        try (BufferedReader in = null;){
            StiUnicodeBOMInputStream ub = new StiUnicodeBOMInputStream(input);
            StiUnicodeBOMInputStream.BOM bom = ub.getBOM();
            if (bom == StiUnicodeBOMInputStream.BOM.NONE) {
                in = new BufferedReader(new InputStreamReader((InputStream)ub, ENCODING));
            } else {
                ub.skipBOM();
                in = new BufferedReader(new InputStreamReader((InputStream)ub, bom.getDescription()));
            }
            StringBuffer out = new StringBuffer();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = in.read(buffer))) {
                out.append(new String(buffer, 0, n));
            }
            StringBuffer stringBuffer = out;
            return stringBuffer;
        }
    }

    public static String toString(InputStream input) throws IOException {
        return StiIOUtil.toStringBuffer(input).toString();
    }

    public static String toString(Reader reader) throws IOException {
        StringBuffer out = new StringBuffer();
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        while ((line = br.readLine()) != null) {
            out.append(line + System.getProperty("line.separator"));
        }
        return out.toString();
    }

    public static void writeString(OutputStream os, String value) throws IOException {
        StiIOUtil.writeInputStream(os, StiIOUtil.toInputStream(value));
    }

    public static void write(String data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data.getBytes(ENCODING));
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static StiLineIterator lineIterator(InputStream input) throws IOException {
        InputStreamReader reader = null;
        reader = new InputStreamReader(input, ENCODING);
        return new StiLineIterator(reader);
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StiIOUtil.copy(is, baos);
        return baos.toByteArray();
    }
}

