/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.utils.data;

import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.utils.XmlObject;
import com.stimulsoft.report.utils.data.StiSqlField;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

@XmlRootElement(name="Tables")
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class StiTableFieldsRequest
extends XmlObject {
    private final List<StiSqlField> columns = new ArrayList<StiSqlField>();

    public void add(String name, String type) {
        this.columns.add(new StiSqlField(name, type));
    }

    @XmlElementWrapper(name="RetrieveColumns")
    @XmlAnyElement
    public List<JAXBElement<StiSqlField>> getJAXBColunns() {
        ArrayList<JAXBElement<StiSqlField>> elements = new ArrayList<JAXBElement<StiSqlField>>();
        for (StiSqlField field : this.columns) {
            QName qName = new QName(field.getName());
            field.setType(StiTableFieldsRequest.getFxType(field.getType()));
            JAXBElement e = new JAXBElement(qName, StiSqlField.class, (Object)field);
            elements.add((JAXBElement<StiSqlField>)e);
        }
        return elements;
    }

    public Class<?>[] getClassesToBeBound() {
        Class[] classes = new Class[]{((Object)((Object)this)).getClass(), StiSqlField.class};
        return classes;
    }

    public List<StiSqlField> getColumns() {
        return this.columns;
    }

    private static String getFxType(String columnType) {
        if (StiSystemTypeEnum.SystemString.name().equals(columnType)) {
            return "string";
        }
        if (StiSystemTypeEnum.SystemBoolean.name().equals(columnType)) {
            return "boolean";
        }
        if (StiSystemTypeEnum.SystemInt16.name().equals(columnType) || StiSystemTypeEnum.SystemInt32.name().equals(columnType) || StiSystemTypeEnum.SystemInt64.name().equals(columnType) || StiSystemTypeEnum.SystemByte.name().equals(columnType)) {
            return "int";
        }
        if (StiSystemTypeEnum.SystemDateTime.name().equals(columnType) || StiSystemTypeEnum.SystemTimeSpan.name().equals(columnType)) {
            return "dateTime";
        }
        if (StiSystemTypeEnum.SystemDecimal.name().equals(columnType) || StiSystemTypeEnum.SystemDouble.name().equals(columnType) || StiSystemTypeEnum.SystemFloat.name().equals(columnType) || StiSystemTypeEnum.SystemSingle.name().equals(columnType)) {
            return "decimal";
        }
        return "base64Binary";
    }
}

