/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.lib.utils.StiCollectionsUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiChartStyle;
import com.stimulsoft.report.styles.StiCrossTabStyle;
import com.stimulsoft.report.styles.StiDialogStyle;
import com.stimulsoft.report.styles.StiEmptyStyle;
import com.stimulsoft.report.styles.StiIndicatorStyle;
import com.stimulsoft.report.styles.StiMapStyle;
import com.stimulsoft.report.styles.StiStyle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.xml.sax.SAXException;

public class StiStylesCollection
extends ArrayList<StiBaseStyle>
implements IStiJsonReportObject {
    private static final long serialVersionUID = 844454754218364745L;
    private StiReport report = null;

    public StiBaseStyle getByName(String name) {
        return this.get(name);
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else if (o instanceof String) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == null || !o.equals(((StiBaseStyle)this.get(i)).getName())) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == null || !o.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public void set(String name, StiBaseStyle style) {
        int index = this.indexOf(name);
        if (index == -1) {
            this.add(style);
        } else {
            this.set(index, style);
        }
    }

    public StiBaseStyle get(String name) {
        return (StiBaseStyle)StiCollectionsUtil.getElementOrNull((ArrayList)this, (String)name, StiEmptyStyle.class);
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiBaseStyle style : this) {
            jObject.AddPropertyJObject(index.toString(), style.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        this.clear();
        for (JProperty property : jObject.Properties()) {
            JSONObject styleJObject = (JSONObject)property.Value;
            String ident = (String)styleJObject.Properties().FirstOrDefault((String)"Ident").Value;
            StiBaseStyle style = null;
            if (ident.equals("StiChartStyle")) {
                style = new StiChartStyle();
            } else {
                if (ident.equals("StiGaugeStyle")) {
                    return;
                }
                if (ident.equals("StiCrossTabStyle")) {
                    style = new StiCrossTabStyle();
                } else if (ident.equals("StiDialogStyle")) {
                    style = new StiDialogStyle();
                } else if (ident.equals("StiStyle")) {
                    style = new StiStyle();
                } else if (ident.equals("StiMapStyle")) {
                    style = new StiMapStyle();
                } else if (ident.equals("StiIndicatorStyle")) {
                    style = new StiIndicatorStyle();
                }
            }
            ((StiBaseStyle)style).LoadFromJsonObject(styleJObject);
            this.add(style);
        }
    }

    public void load(InputStream stream) throws IOException, SAXException, StiDeserializationException {
        StiStylesSaver styleSheet = new StiStylesSaver();
        styleSheet = (StiStylesSaver)StiDeserializerControler.deserializeReport((InputStream)stream, (IStiSerializable)styleSheet);
        this.clear();
        this.addAll(styleSheet.getStyles());
        if (this.report != null) {
            this.report.applyStyles();
        }
    }

    public String saveToString() throws UnsupportedEncodingException {
        StiStylesSaver saver = new StiStylesSaver(this);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        saver.setReference(0);
        StiSerializerControler.serializeReport((IStiSerializableRef)saver, (OutputStream)bos, (boolean)true, (boolean)false);
        return new String(bos.toByteArray(), "UTF-8");
    }

    public StiStylesCollection() {
        this((StiReport)null);
    }

    public StiStylesCollection(StiReport report) {
        this.report = report;
    }

    public static class StiStylesSaver
    implements IStiSerializable,
    IStiSerializableRef {
        private StiStylesCollection styles;
        private int reference = -1;

        @StiSerializable
        public StiStylesCollection getStyles() {
            return this.styles;
        }

        public void setStyles(StiStylesCollection styles) {
            this.styles = styles;
        }

        public StiStylesSaver(StiStylesCollection styles) {
            this.styles = styles;
        }

        public StiStylesSaver() {
        }

        public void setReference(int reference) {
            this.reference = reference;
        }

        public int getReference() {
            return this.reference;
        }
    }
}

