/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiStyleElements;
import com.stimulsoft.report.maps.helpers.StiMapHelper;
import com.stimulsoft.report.styles.StiBaseStyle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class StiMapStyle
extends StiBaseStyle {
    public StiColor individualColor = StiColor.fromHtml((String)"#70ad47");
    List<StiColor> colors = new ArrayList<StiColor>();
    List<StiColor> heatmapColors = new ArrayList<StiColor>();
    private StiColor defaultColor = StiColor.fromHtml((String)"#4472c4");
    private StiColor backColor = StiColor.fromHtml((String)"#ffffff");
    private StiColor foreColor = StiColor.fromHtml((String)"#ffffff");
    private double borderSize = 0.5;
    private StiColor borderColor = StiColorEnum.White.color();

    public StiComponentId getComponentId() {
        return StiComponentId.StiMapStyle;
    }

    @StiSerializable
    public StiColor getIndividualColor() {
        return this.individualColor;
    }

    public void setIndividualColor(StiColor individualColor) {
        this.individualColor = individualColor;
    }

    @StiSerializable
    public List<StiColor> getColors() {
        if (this.colors.size() == 0) {
            this.colors.add(StiColor.fromHtml((String)"#70ad47"));
            this.colors.add(StiColor.fromHtml((String)"#4472c4"));
            this.colors.add(StiColor.fromHtml((String)"#ffc000"));
            this.colors.add(StiColor.fromHtml((String)"#43682b"));
            this.colors.add(StiColor.fromHtml((String)"#fd6a37"));
            this.colors.add(StiColor.fromHtml((String)"#997300"));
        }
        return this.colors;
    }

    public void setColors(List<StiColor> colors) {
    }

    @StiSerializable
    public List<StiColor> getHeatmapColors() {
        if (this.heatmapColors.size() == 0) {
            this.heatmapColors.add(StiColor.fromHtml((String)"#70ad47"));
            this.heatmapColors.add(StiColor.fromHtml((String)"#ffc000"));
        }
        return this.heatmapColors;
    }

    public void setHeatmapColors(List<StiColor> heatmapColors) {
    }

    @StiSerializable
    public StiColor getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(StiColor defaultColor) {
        this.defaultColor = defaultColor;
    }

    @StiSerializable
    public StiColor getBackColor() {
        return this.backColor;
    }

    public void setBackColor(StiColor backColor) {
        this.backColor = backColor;
    }

    @StiSerializable
    public StiColor getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(StiColor foreColor) {
        this.foreColor = foreColor;
    }

    @StiSerializable
    public double getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(double borderSize) {
        this.borderSize = borderSize;
    }

    @StiSerializable
    public StiColor getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(StiColor borderColor) {
        this.borderColor = borderColor;
    }

    public void drawStyle(StiGraphics g, StiRectangle rect, boolean paintValue, boolean paintImage, double zoom, double pageZoom) throws IOException {
        g.drawImage(StiMapHelper.getMapIcon(), new StiRectangle(rect.x + 4.0, rect.y + (rect.height - 32.0) / 2.0, 32.0, 32.0), Boolean.valueOf(false), Boolean.valueOf(false), zoom);
        int colorCount = this.getColors().size();
        if (colorCount > 10) {
            colorCount = 10;
        }
        StiRectangle rectElement = new StiRectangle(rect.x + 44.0, rect.y + 6.0, rect.width - 10.0, rect.height - 10.0);
        int xPos = (int)rectElement.getLeft();
        for (int index = 0; index < colorCount; ++index) {
            StiSolidBrush brush = new StiSolidBrush(this.getColors().get(index));
            g.drawRectangle(new StiRectangle((double)xPos, rectElement.getTop(), 10.0, rectElement.height), null, (StiBrush)brush, Double.valueOf(zoom), Double.valueOf(pageZoom));
            xPos += 10;
        }
        rectElement.x = xPos + 5;
        rectElement.width = rectElement.getRight() - rectElement.x;
        StiSolidBrush br = new StiSolidBrush(StiColor.Black);
        StiFont font = new StiFont("Arial", 10.0);
        g.drawText(this.getName(), rectElement, font, (StiBrush)br, StiTextHorAlignment.Center, StiVertAlignment.Center, Boolean.valueOf(false), 1.0f, Double.valueOf(zoom), StiPenStyle.None, null, null);
    }

    public void drawBox(StiGraphics g, StiRectangle rect, boolean paintValue, boolean paintImage, double zoom, double pageZoom) throws IOException {
        rect.x += 1.0;
        rect.y += 1.0;
        rect.width -= 2.0;
        rect.height -= 3.0;
        this.drawStyle(g, rect, paintValue, paintImage, zoom, pageZoom);
        StiPen pen = new StiPen(1.0, StiColor.FromArgb((int)150, (StiColor)StiColorEnum.Gray.color()));
        pen.setDashStyle(StiPenStyle.Dash);
        g.drawRectangle(rect, pen, null, Double.valueOf(zoom), Double.valueOf(pageZoom));
    }

    @Override
    public void GetStyleFromComponent(StiComponent component, StiStyleElements styleElements) {
    }

    @Override
    public void SetStyleToComponent(StiComponent component) {
    }

    public void save(OutputStream stream) {
        StiBaseStyle.StiStyleSaver saver = new StiBaseStyle.StiStyleSaver(this);
        StiSerializerControler.serializedObjectAsString((IStiSerializable)saver);
    }

    public StiMapStyle load(InputStream stream) throws IOException {
        StiBaseStyle.StiStyleSaver saver = new StiBaseStyle.StiStyleSaver();
        StiDeserializerControler.deserializeFromString((String)StiIOUtil.toString((InputStream)stream), (IStiSerializable)saver);
        return (StiMapStyle)saver.getStyle();
    }

    public StiMapStyle(String name, String description, StiReport report) {
        super(name, description, report);
    }

    public StiMapStyle(String name, String description) {
        this(name, description, null);
    }

    public StiMapStyle(String name) {
        this(name, "");
    }

    public StiMapStyle() {
        this("");
    }
}

