/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.dialogs.StiForm;
import com.stimulsoft.report.dialogs.StiReportControl;
import com.stimulsoft.report.enums.StiStyleElements;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.conditions.StiStyleConditionHelper;
import com.stimulsoft.report.styles.conditions.StiStyleConditionsCollection;

public class StiDialogStyle
extends StiBaseStyle {
    private StiFont font = new StiFont("Arial", 8.0);
    private StiColor foreColor = StiColor.Black;
    private StiColor backColor = StiColor.White;
    private boolean allowUseFont = true;
    private boolean allowUseBackColor = true;
    private boolean allowUseForeColor = true;

    public StiDialogStyle(String name, String description, StiReport report) {
        super(name, description, report);
    }

    public StiDialogStyle(String name, String description) {
        this(name, description, null);
    }

    public StiDialogStyle(String name) {
        this(name, "");
    }

    public StiDialogStyle() {
        this("");
    }

    @Override
    public Object clone() {
        try {
            StiDialogStyle style = new StiDialogStyle();
            style.setAllowUseBackColor(this.allowUseBackColor);
            style.setAllowUseFont(this.allowUseFont);
            style.setAllowUseForeColor(this.allowUseForeColor);
            style.setBackColor(this.backColor.clone());
            style.setCollectionName(this.getCollectionName());
            style.setConditions((StiStyleConditionsCollection)this.getConditions().clone());
            style.setDescription(this.getDescription());
            style.setFont((StiFont)this.getFont().clone());
            style.setForeColor(this.getForeColor().clone());
            style.setName(this.getName());
            return style;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @StiSerializable
    public final StiFont getFont() {
        return this.font;
    }

    public final void setFont(StiFont value) {
        this.font = value;
    }

    @StiSerializable
    public final StiColor getForeColor() {
        return this.foreColor;
    }

    public final void setForeColor(StiColor value) {
        this.foreColor = value;
    }

    @StiSerializable
    public final StiColor getBackColor() {
        return this.backColor;
    }

    public final void setBackColor(StiColor value) {
        this.backColor = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseFont() {
        return this.allowUseFont;
    }

    public final void setAllowUseFont(boolean value) {
        this.allowUseFont = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseBackColor() {
        return this.allowUseBackColor;
    }

    public final void setAllowUseBackColor(boolean value) {
        this.allowUseBackColor = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseForeColor() {
        return this.allowUseForeColor;
    }

    public final void setAllowUseForeColor(boolean value) {
        this.allowUseForeColor = value;
    }

    @Override
    public void GetStyleFromComponent(StiComponent component, StiStyleElements styleElements) {
    }

    @Override
    public void SetStyleToComponent(StiComponent component) {
        StiReportControl control;
        StiForm form = component instanceof StiForm ? (StiForm)component : null;
        StiReportControl stiReportControl = control = component instanceof StiReportControl ? (StiReportControl)component : null;
        if (control == null) {
            return;
        }
        if (!StiStyleConditionHelper.isAllowStyle(component, this)) {
            return;
        }
        if (component instanceof IStiFont && this.getAllowUseFont()) {
            if (form != null) {
                form.setFont((StiFont)this.getFont().clone());
            } else {
                control.setFont((StiFont)this.getFont().clone());
            }
        }
        if (this.getAllowUseBackColor()) {
            if (form != null) {
                form.setBackColor(this.getBackColor());
            } else {
                control.setBackColor(this.getBackColor());
            }
        }
        if (this.getAllowUseForeColor() && control != null) {
            control.setForeColor(this.getForeColor());
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.fontDefault((StiFont)this.getFont()));
        jObject.AddPropertyStringNullOfEmpty("ForeColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getForeColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyStringNullOfEmpty("BackColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getBackColor(), (StiColorEnum)StiColorEnum.White));
        jObject.AddPropertyBool("AllowUseFont", this.getAllowUseFont(), true);
        jObject.AddPropertyBool("AllowUseBackColor", this.getAllowUseBackColor(), true);
        jObject.AddPropertyBool("AllowUseForeColor", this.getAllowUseForeColor(), true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Font")) {
                this.font = StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font);
                continue;
            }
            if (property.Name.equals("ForeColor")) {
                this.foreColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("BackColor")) {
                this.backColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("AllowUseFont")) {
                this.allowUseFont = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseBackColor")) {
                this.allowUseBackColor = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("AllowUseForeColor")) continue;
            this.allowUseForeColor = (Boolean)property.Value;
        }
    }
}

