/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.context.chart.IStiContextPainter;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiSparkline;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.painters.StiContextPainter;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.cell.StiColumnSparklinesCellPainter;
import com.stimulsoft.report.painters.cell.StiLineSparklinesCellPainter;
import com.stimulsoft.report.painters.cell.StiWinLossSparklinesCellPainter;
import com.stimulsoft.report.painters.components.StiComponentPainter;
import java.awt.image.BufferedImage;

public class StiSparklinePainter
extends StiComponentPainter {
    public BufferedImage getImage(StiComponent component, double zoom, StiExportFormat format) {
        return null;
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs e) {
        StiSparkline sparkline = (StiSparkline)component;
        if (e.getDrawTopmostBorderSides().booleanValue() && !sparkline.getBorder().getTopmost()) {
            return;
        }
        StiGraphics g = e.getG();
        StiRectangle rect = sparkline.getPaintRectangle();
        double zoom = sparkline.page.getZoom() * 1.0;
        Double pageZoom = sparkline.getReport().getInfo().getPageZoom();
        if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && e.getClipRectangles().isEmpty()) {
            StiSparklinePainter.drawSparkline(g, rect, sparkline, zoom, pageZoom);
        }
    }

    public static void drawSparkline(StiGraphics g, StiRectangle rect, StiSparkline sparkline, double zoom, double pageZoom) {
        StiContextPainter painter = new StiContextPainter(g, zoom, pageZoom);
        StiContext context = new StiContext((IStiContextPainter)painter, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(sparkline.getIsPrinting()), (double)((float)zoom));
        StiSparklinePainter.RenderSparkline(context, rect, sparkline, zoom, pageZoom);
    }

    public static void RenderSparkline(StiContext context, StiRectangle rect, StiSparkline sparkline, double zoom, double pageZoom) {
        double[] values = sparkline.fetchValues();
        switch (sparkline.type) {
            case Column: {
                StiColumnSparklinesCellPainter.draw(context, rect, values, sparkline.getPositiveColor(), sparkline.getNegativeColor());
                break;
            }
            case Line: {
                StiLineSparklinesCellPainter.draw(context, rect, values, zoom, pageZoom, sparkline.getPositiveColor(), false, sparkline.isShowFirstLastPoints(), sparkline.isShowHighLowPoints());
                break;
            }
            case Area: {
                StiLineSparklinesCellPainter.draw(context, rect, values, zoom, pageZoom, sparkline.getPositiveColor(), true, sparkline.isShowFirstLastPoints(), sparkline.isShowHighLowPoints());
                break;
            }
            case WinLoss: {
                StiWinLossSparklinesCellPainter.draw(context, rect, values, sparkline.getPositiveColor(), sparkline.getNegativeColor());
            }
        }
        context.render(rect);
    }
}

