/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;

public class StiShapePainter
extends StiComponentPainter {
    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiShape shape = (StiShape)component;
        if (shape.getEnabled() || shape.getIsDesigning()) {
            StiGraphics g = args.getG();
            StiRectangle rect = shape.getPaintRectangle();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
                Double zoom = shape.getPage().getZoom();
                Double pageZoom = shape.getReport().getInfo().getPageZoom();
                int shift = (int)Math.round(shape.getSize() * zoom / 2.0);
                g.getG().translate(shift, shift);
                shape.getShapeType().paint(g, shape, rect, zoom, shape.getReport().getInfo().getPageZoom());
                this.paintMarkers(shape, g, rect, zoom, pageZoom);
                this.paintEvents(shape, args.getG(), rect);
                this.paintConditions(shape, args.getG(), rect);
            }
        }
    }
}

