/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.drawing.path.StiPathCurveTo;
import com.stimulsoft.base.drawing.path.StiPathLineTo;
import com.stimulsoft.base.drawing.path.StiPathMoveTo;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRoundedRectanglePrimitive;
import com.stimulsoft.report.painters.components.StiRectanglePrimitivePainter;
import java.util.ArrayList;
import java.util.List;

public class StiRoundedRectanglePrimitivePainter
extends StiRectanglePrimitivePainter {
    @Override
    protected void paintPrimitive(StiRectanglePrimitive primitive, StiGraphics g, StiRectangle rect) {
        Double zoom = primitive.getReport().getInfo().getZoom();
        Double pageZoom = primitive.getReport().getInfo().getPageZoom();
        StiRoundedRectanglePrimitive roundedPrimitive = (StiRoundedRectanglePrimitive)primitive;
        if (!(primitive.getHighlightState() != StiHighlightState.Show && primitive.getHighlightState() != StiHighlightState.Active || primitive.getReport().getInfo().getIsComponentsMoving())) {
            StiPen pen2 = new StiPen(primitive.getSize(), StiColor.fromAColor((int)150, (StiColor)StiColorEnum.Gold.color()));
            ArrayList<StiPathCommand> path = new ArrayList<StiPathCommand>();
            this.addRoundedRectangleToPath(roundedPrimitive, rect, path);
            g.drawPath(path, pen2, null, zoom.doubleValue(), pageZoom.doubleValue());
        }
        Double space = Math.min(rect.getHeight() < rect.getWidth() ? rect.getHeight() : rect.getWidth(), 100.0) * (double)roundedPrimitive.getRound();
        if (rect.getWidth() >= space * 2.0 && rect.getHeight() >= space * 2.0) {
            StiPen pen = new StiPen(primitive.getSize(), primitive.getColor(), roundedPrimitive.getStyle());
            if (primitive.getStyle() == StiPenStyle.Double) {
                StiRectangle rectIn = rect.clone();
                StiRectangle rectOut = rect.clone();
                rectIn.inflate(Double.valueOf(-zoom.doubleValue()), Double.valueOf(-zoom.doubleValue()));
                rectOut.inflate(zoom, zoom);
                pen.setWidth(Double.valueOf(1.0));
                this.drawRoundedRectangleToPath(g, pen, roundedPrimitive, rectIn, zoom, pageZoom);
                this.drawRoundedRectangleToPath(g, pen, roundedPrimitive, rectOut, zoom, pageZoom);
            } else {
                this.drawRoundedRectangleToPath(g, pen, roundedPrimitive, rect, zoom, pageZoom);
            }
        }
    }

    private void addRoundedRectangleToPath(StiRoundedRectanglePrimitive roundedPrimitive, StiRectangle rect, List<StiPathCommand> path) {
        Double space = Math.min(rect.getHeight() < rect.getWidth() ? rect.getHeight() : rect.getWidth(), 100.0) * (double)roundedPrimitive.getRound();
        if (rect.getWidth() >= space * 2.0 && rect.getHeight() >= space * 2.0) {
            if ((space = Double.valueOf(StiMath.round((Double)space, (Double)2.0))) < 0.01) {
                space = 0.01;
            }
            path.add((StiPathCommand)new StiPathMoveTo(Double.valueOf(rect.getX() + space), Double.valueOf(rect.getY())));
            path.add((StiPathCommand)new StiPathLineTo(Double.valueOf(rect.getRight() - space), Double.valueOf(rect.getY())));
            path.add((StiPathCommand)new StiPathCurveTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getY()), Double.valueOf(rect.getRight()), Double.valueOf(rect.getY() + space)));
            path.add((StiPathCommand)new StiPathLineTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom() - space)));
            path.add((StiPathCommand)new StiPathCurveTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getRight() - space), Double.valueOf(rect.getBottom())));
            path.add((StiPathCommand)new StiPathLineTo(Double.valueOf(rect.getX() + space), Double.valueOf(rect.getBottom())));
            path.add((StiPathCommand)new StiPathCurveTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom() - space)));
            path.add((StiPathCommand)new StiPathLineTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getY() + space)));
            path.add((StiPathCommand)new StiPathCurveTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getY()), Double.valueOf(rect.getX() + space), Double.valueOf(rect.getY())));
        }
    }

    private void drawRoundedRectangleToPath(StiGraphics g, StiPen pen, StiRoundedRectanglePrimitive roundedPrimitive, StiRectangle rect, Double zoom, Double pageZoom) {
        Double space = Math.min(rect.getHeight() < rect.getWidth() ? rect.getHeight() : rect.getWidth(), 100.0) * (double)roundedPrimitive.getRound();
        if (rect.getWidth() >= space * 2.0 && rect.getHeight() >= space * 2.0) {
            space = space * zoom;
            if ((space = Double.valueOf(StiMath.round((Double)space, (Double)2.0))) < 0.01) {
                space = 0.01;
            }
            ArrayList<Object> path = new ArrayList<Object>();
            if (roundedPrimitive.getTopSide() && roundedPrimitive.getLeftSide() && roundedPrimitive.getBottomSide() && roundedPrimitive.getRightSide()) {
                path.add(new StiPathMoveTo(Double.valueOf(rect.getX() + space), Double.valueOf(rect.getY())));
                path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - space), Double.valueOf(rect.getY())));
                path.add(new StiPathCurveTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getY()), Double.valueOf(rect.getRight()), Double.valueOf(rect.getY() + space)));
                path.add(new StiPathLineTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom() - space)));
                path.add(new StiPathCurveTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getRight() - space), Double.valueOf(rect.getBottom())));
                path.add(new StiPathLineTo(Double.valueOf(rect.getX() + space), Double.valueOf(rect.getBottom())));
                path.add(new StiPathCurveTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom() - space)));
                path.add(new StiPathLineTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getY() + space)));
                path.add(new StiPathCurveTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getY()), Double.valueOf(rect.getX() + space), Double.valueOf(rect.getY())));
            } else {
                Double space1 = 0.0;
                Double space2 = 0.0;
                if (roundedPrimitive.getTopSide()) {
                    if (roundedPrimitive.getLeftSide()) {
                        space1 = space;
                    }
                    if (roundedPrimitive.getRightSide()) {
                        space2 = space;
                    }
                    path.add(new StiPathMoveTo(Double.valueOf(rect.getX() + space1), Double.valueOf(rect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - space2), Double.valueOf(rect.getY())));
                    if (roundedPrimitive.getRightSide()) {
                        path.add(new StiPathCurveTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getY()), Double.valueOf(rect.getRight()), Double.valueOf(rect.getY() + space)));
                    }
                    space1 = 0.0;
                    space2 = 0.0;
                }
                if (roundedPrimitive.getRightSide()) {
                    if (roundedPrimitive.getTopSide()) {
                        space1 = space;
                    }
                    if (roundedPrimitive.getBottomSide()) {
                        space2 = space;
                    }
                    path.add(new StiPathMoveTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getY() + space1)));
                    path.add(new StiPathLineTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom() - space2)));
                    if (roundedPrimitive.getBottomSide()) {
                        path.add(new StiPathCurveTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getRight() - space), Double.valueOf(rect.getBottom())));
                    }
                    space1 = 0.0;
                    space2 = 0.0;
                }
                if (roundedPrimitive.getBottomSide()) {
                    if (roundedPrimitive.getRightSide()) {
                        space1 = space;
                    }
                    if (roundedPrimitive.getLeftSide()) {
                        space2 = space;
                    }
                    path.add(new StiPathMoveTo(Double.valueOf(rect.getRight() - space1), Double.valueOf(rect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(rect.getX() + space2), Double.valueOf(rect.getBottom())));
                    if (roundedPrimitive.getLeftSide()) {
                        path.add(new StiPathCurveTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom() - space)));
                    }
                    space1 = 0.0;
                    space2 = 0.0;
                }
                if (roundedPrimitive.getLeftSide()) {
                    if (roundedPrimitive.getBottomSide()) {
                        space1 = space;
                    }
                    if (roundedPrimitive.getTopSide()) {
                        space2 = space;
                    }
                    path.add(new StiPathMoveTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom() - space1)));
                    path.add(new StiPathLineTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getY() + space2)));
                    if (roundedPrimitive.getTopSide()) {
                        path.add(new StiPathCurveTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getY()), Double.valueOf(rect.getX() + space), Double.valueOf(rect.getY())));
                    }
                    space1 = 0.0;
                    space2 = 0.0;
                }
            }
            g.drawPath(path, pen, null, zoom.doubleValue(), pageZoom.doubleValue());
        }
    }
}

