/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeV2InitHelper;
import com.stimulsoft.report.painters.StiGdiGaugeContextPainter;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;

public class StiGaugePainter
extends StiComponentPainter {
    @Override
    public void paint(StiComponent component, StiPaintArgs e) {
        StiGauge gauge = (StiGauge)component;
        if (component.getIsEnabled() || component.getIsDesigning()) {
            StiGraphics g = e.getG();
            StiRectangle rect = component.getPaintRectangle();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && (e.getClipRectangles().isEmpty() || rect.intersectsWith(rect).booleanValue())) {
                g.setTransformedClip(rect);
                StiRectangle rectF = rect;
                this.drawGauge(g, gauge, rectF);
                g.restoreClip();
            }
        }
    }

    public void drawGauge(StiGauge gauge, StiGraphics g, StiRectangle rect, double zoom) {
        boolean fillComponent;
        Double pageZoom = gauge.getReport().getInfo().getPageZoom();
        boolean bl = fillComponent = gauge.getReport() != null && gauge.getReport().getInfo() != null && gauge.getReport().getInfo().getFillComponent();
        if (gauge.getBrush() instanceof StiSolidBrush && ((StiSolidBrush)gauge.getBrush()).getColor().equals(StiColorEnum.Transparent.color()) && fillComponent && gauge.getIsDesigning()) {
            StiColor color = StiColor.FromArgb((int)150, (StiColor)StiColorEnum.White.color());
            g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), Double.valueOf(zoom), pageZoom);
        } else {
            g.drawRectangle(rect, null, gauge.getBrush(), Double.valueOf(zoom), pageZoom);
        }
        if (gauge.isDesigning()) {
            StiGaugeV2InitHelper.prepare(gauge);
        }
        StiGdiGaugeContextPainter context = new StiGdiGaugeContextPainter(g, gauge, rect, zoom, pageZoom);
        gauge.drawGauge(context);
        context.render();
        if ((gauge.getBorder().getSide().size() == 0 || gauge.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None)) && gauge.getIsDesigning()) {
            StiPen pen = new StiPen(gauge.getBorder().getSize(), StiColorEnum.Gray.color());
            pen.setDashStyle(StiPenStyle.Dash);
            g.drawRectangle(rect, pen, null, Double.valueOf(zoom), pageZoom);
        }
        if (gauge.getHighlightState() == StiHighlightState.Hide) {
            this.paintBorder(gauge, g, rect.clone(), true, true, zoom, pageZoom);
        }
    }

    public void drawGauge(StiGraphics g, StiGauge gauge, StiRectangle rect) {
        this.drawGauge(gauge, g, rect, gauge.getPage() != null ? gauge.getPage().getZoom() : 1.0);
    }

    public StiImage getImage(StiComponent component, double zoom, StiExportFormat format) {
        return null;
    }
}

