/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.context.chart.IStiContextPainter;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.painters.StiContextPainter;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;
import java.awt.Graphics2D;

public class StiChartPainter
extends StiComponentPainter {
    public void drawChart(StiChart chart, StiGraphics g, StiRectangle rect, boolean useMargins, boolean useBackground) {
        Double zoom = chart.getReport().getInfo().getZoom();
        Double pageZoom = chart.getReport().getInfo().getPageZoom();
        if (useBackground) {
            if (chart.getBrush() instanceof StiSolidBrush && StiColorEnum.Transparent.color().equals(((StiSolidBrush)chart.getBrush()).getColor()) && chart.getReport().getInfo().getFillComponent() && chart.getIsDesigning()) {
                StiColor color = StiColor.fromArgb((int)150, (StiColor)StiColorEnum.White.color());
                g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), zoom, pageZoom);
            } else {
                g.drawRectangle(rect, null, chart.getBrush(), zoom, pageZoom);
            }
        }
        Graphics2D savedGraphics = g.getG();
        g.setG((Graphics2D)savedGraphics.create());
        StiGraphicsHelper.setDefaultRenderingHints((Graphics2D)g.getG());
        double angle = 0.0;
        double deltaX = 0.0;
        double deltaY = 0.0;
        double scaleX = 1.0;
        double scaleY = 1.0;
        double sx = g.getOffsetX();
        double sy = g.getOffsetY();
        StiRectangle originalRect = rect.clone();
        switch (chart.getRotation()) {
            case Rotate90CCW: {
                angle = -90.0;
                deltaX = (rect.width - rect.height) / 2.0;
                deltaY = (rect.width - rect.height) / 2.0;
                break;
            }
            case Rotate90CW: {
                angle = 90.0;
                deltaX = (rect.height - rect.width) / 2.0;
                deltaY = (rect.height - rect.width) / 2.0;
                break;
            }
            case Rotate180: {
                angle = -180.0;
                deltaX = 0.0;
                deltaY = 0.0;
                break;
            }
            case FlipVertical: {
                scaleY = -1.0;
                deltaY = rect.height;
                break;
            }
            case FlipHorizontal: {
                scaleX = -1.0;
                deltaX = 1000.0;
            }
        }
        g.setTransformedClip(rect);
        g.setOffset(rect.x, rect.y);
        switch (chart.getRotation()) {
            case Rotate90CCW: 
            case Rotate90CW: {
                StiRectangle rectTemp = rect.clone();
                rect.width = rectTemp.height;
                rect.height = rectTemp.width;
            }
        }
        rect.setX(0.0);
        rect.setY(0.0);
        StiContextPainter painter = new StiContextPainter(g, zoom, pageZoom);
        StiContext context = new StiContext((IStiContextPainter)painter, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(chart.getIsPrinting()), (double)zoom.floatValue());
        if (!useMargins) {
            rect.width -= 1.0;
            rect.height -= 1.0;
        }
        g.getG().rotate(Math.toRadians(angle), g.getOffsetX() + rect.width / 2.0, g.getOffsetY() + rect.height / 2.0);
        g.getG().translate(deltaX, deltaY);
        g.getG().scale(scaleX, scaleY);
        StiCellGeom chartGeom = chart.getCore().Render(context, new StiRectangle(0.0, 0.0, rect.getWidth(), rect.getHeight()), useMargins);
        chartGeom.DrawGeom(context);
        context.render(rect);
        g.clearOffset();
        g.restoreClip();
        g.setG(savedGraphics);
    }

    public void paintChart(StiChart chart, StiGraphics g, StiRectangle rect, boolean topMost, boolean drawFormatting, boolean isThumnail) {
        Double zoom = chart.getReport().getInfo().getZoom();
        Double pageZoom = chart.getReport().getInfo().getPageZoom();
        if (!topMost) {
            this.drawChart(chart, g, rect.clone(), true, true);
        }
        if (chart.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None) && chart.getIsDesigning()) {
            StiPen pen = new StiPen(1.0, StiColorEnum.Gray.color(), StiPenStyle.Dash);
            g.drawRectangle(rect, pen, null, zoom, pageZoom);
        }
        this.paintBorder(chart, g, rect.clone(), topMost, isThumnail, zoom, pageZoom);
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs e) {
        StiChart chart = (StiChart)component;
        chart.invokePainting(chart, e);
        if (chart.getEnabled() || chart.getIsDesigning()) {
            StiGraphics g = e.getG();
            StiRectangle rect = chart.getPaintRectangle();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0) {
                this.paintChart(chart, g, rect, e.getDrawTopmostBorderSides(), true, e.isThumbPaint());
                if (chart.getHighlightState() != StiHighlightState.Hide || !chart.getBorder().getSide().contains((IStiEnum)StiBorderSides.All)) {
                    // empty if block
                }
            }
            this.paintQuickButtons(chart, e.getG());
            this.paintEvents(chart, e.getG(), rect);
        }
    }
}

