/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.cell;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiSimplifyHelper;
import java.util.ArrayList;
import java.util.List;

public class StiLineSparklinesCellPainter {
    public static void draw(StiContext context, StiRectangle rect, double[] array, double zoom, double pageZoom, StiColor sparklineColor, boolean showArea, boolean showFirstLastMarker, boolean showHighLowMarker) {
        double[] svalues;
        if (array == null || array.length < 2) {
            return;
        }
        rect.inflate(Double.valueOf(-4.0 * zoom), Double.valueOf(-rect.height / 4.0));
        double[] values = array;
        boolean allZero = true;
        for (double d : values) {
            if (d == 0.0) continue;
            allZero = false;
        }
        if (allZero) {
            return;
        }
        double min = values[0];
        for (double i : values) {
            min = Math.min(i, min);
        }
        double max = values[0];
        double[] dArray = values;
        int i = dArray.length;
        for (int j = 0; j < i; ++j) {
            double i2 = dArray[j];
            max = Math.max(i2, max);
        }
        if (min == 0.0 && max == 0.0) {
            return;
        }
        if (min > 0.0) {
            svalues = new double[values.length];
            for (i = 0; i < values.length; ++i) {
                svalues[i] = values[i] - min;
            }
            values = svalues;
            max -= min;
            min = 0.0;
        }
        if (max < 0.0) {
            svalues = new double[values.length];
            for (i = 0; i < values.length; ++i) {
                svalues[i] = values[i] + -max;
            }
            values = svalues;
            min += -max;
            max = 0.0;
        }
        double stepWidth = rect.width / (double)(values.length - 1);
        double totalHeight = max + Math.abs(min);
        if (totalHeight == 0.0) {
            return;
        }
        double maxPart = rect.height * max / totalHeight;
        double x = rect.x;
        List<StiPoint> points = new ArrayList<StiPoint>();
        for (double value : values) {
            double valuePart = rect.height * Math.abs(value) / totalHeight;
            double y = rect.y + (value > 0.0 ? maxPart - valuePart : maxPart);
            StiPoint point = new StiPoint(x, value > 0.0 ? y : y + valuePart);
            x += stepWidth;
            points.add(point);
        }
        if (points.size() > 1) {
            points = StiLineSparklinesCellPainter.SimplifyPoints(points);
            if (showArea) {
                StiLineSparklinesCellPainter.drawArea(context, rect, points, pageZoom, sparklineColor);
            }
            StiLineSparklinesCellPainter.drawLines(context, points, pageZoom, sparklineColor);
            if (showFirstLastMarker) {
                StiLineSparklinesCellPainter.drawFirstLastMarkers(context, points, zoom);
            }
            if (showHighLowMarker) {
                StiLineSparklinesCellPainter.drawHighLowMarkers(context, points, zoom);
            }
        }
    }

    private static void drawArea(StiContext context, StiRectangle rect, List<StiPoint> points, double zoom, StiColor sparklineColor) {
        ArrayList<StiLinesSegmentGeom> path = new ArrayList<StiLinesSegmentGeom>();
        ArrayList<StiPoint> pointsPath = new ArrayList<StiPoint>(points);
        pointsPath.add(0, new StiPoint(points.get((int)0).x, rect.getBottom() + 2.0 * zoom));
        pointsPath.add(new StiPoint(points.get((int)(points.size() - 1)).x, rect.getBottom() + 2.0 * zoom));
        path.add(new StiLinesSegmentGeom(pointsPath.toArray(new StiPoint[0])));
        context.FillPath((Object)StiColor.FromArgb((int)60, (StiColor)sparklineColor), path, (Object)rect, null);
    }

    private static void drawLines(StiContext context, List<StiPoint> points, double zoom, StiColor sparklineColor) {
        double minY = points.get((int)0).y;
        for (StiPoint i : points) {
            minY = Math.min(i.y, minY);
        }
        double maxY = points.get((int)0).y;
        for (StiPoint i : points) {
            maxY = Math.max(i.y, maxY);
        }
        StiPoint firstPoint = points.get(0);
        StiPoint lastPoint = points.get(points.size() - 1);
        StiRectangle clipRect = new StiRectangle(firstPoint.x, minY, lastPoint.x - firstPoint.x, maxY - minY);
        clipRect.inflate(1, 1);
        context.PushSmoothingModeToAntiAlias();
        double penWidth = 2.0 * zoom;
        context.DrawLines(new StiPenGeom(sparklineColor, (double)((float)penWidth)), points.toArray(new StiPoint[0]));
        context.PopSmoothingMode();
    }

    private static void drawFirstLastMarkers(StiContext context, List<StiPoint> points, double zoom) {
        StiLineSparklinesCellPainter.drawMarker(context, points.get(0), StiColorEnum.DimGray.color(), zoom);
        StiLineSparklinesCellPainter.drawMarker(context, points.get(points.size() - 1), StiColorEnum.DimGray.color(), zoom);
    }

    private static void drawHighLowMarkers(StiContext context, List<StiPoint> points, double zoom) {
        if (points.size() < 2) {
            return;
        }
        StiPoint maxPoint = points.get(0);
        StiPoint minPoint = points.get(0);
        for (StiPoint p : points) {
            if (p.y > minPoint.y) {
                minPoint = p;
            }
            if (!(p.y < maxPoint.y)) continue;
            maxPoint = p;
        }
        StiLineSparklinesCellPainter.drawMarker(context, maxPoint, StiColorEnum.Green.color(), zoom);
        StiLineSparklinesCellPainter.drawMarker(context, minPoint, StiColorEnum.Red.color(), zoom);
    }

    private static void drawMarker(StiContext context, StiPoint p, StiColor color, double zoom) {
        context.PushSmoothingModeToAntiAlias();
        double w = 3.5 * zoom;
        context.FillEllipse((Object)StiColorEnum.White.color(), new StiRectangle(p.x - w, p.y - w, w * 2.0, w * 2.0), null);
        context.FillEllipse((Object)color, new StiRectangle(p.x - (w -= zoom), p.y - w, w * 2.0, w * 2.0), null);
        context.PopSmoothingMode();
    }

    private static List<StiPoint> SimplifyPoints(List<StiPoint> points) {
        if (points.size() <= 30) {
            return points;
        }
        return StiSimplifyHelper.simplify(points.toArray(new StiPoint[0]), 10.0, false);
    }
}

