/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import java.util.ArrayList;
import java.util.List;

public class StiPaintArgs {
    private Integer shiftX = 0;
    private Integer shiftY = 0;
    private List<StiRectangle> clipRectangles = new ArrayList<StiRectangle>();
    private StiGraphics g;
    private Boolean drawTopmostBorderSides = false;
    private Integer segmentX = -1;
    private Integer segmentY = -1;
    private Boolean thumbPaint = false;
    private StiRectangle paintRect;

    public StiPaintArgs(StiGraphics g, StiRectangle clipRectangle) {
        this.g = g;
        this.addClipRectangle(clipRectangle);
    }

    public StiPaintArgs(StiGraphics g) {
        this.g = g;
    }

    public StiPaintArgs(StiGraphics g, Boolean thumbPaint) {
        this(g);
        this.thumbPaint = thumbPaint;
    }

    public StiPaintArgs(StiGraphics g, Integer segmentX, Integer segmentY) {
        this(g);
        this.segmentX = segmentX;
        this.segmentY = segmentY;
    }

    public Boolean intersectsWith(StiRectangle rect) {
        if (this.clipRectangles.size() == 0) {
            return true;
        }
        for (StiRectangle clipRectangle : this.clipRectangles) {
            StiRectangle shiftRectangle = clipRectangle.clone();
            shiftRectangle.setX(shiftRectangle.getX() - (double)this.shiftX.intValue());
            shiftRectangle.setY(shiftRectangle.getY() - (double)this.shiftY.intValue());
            if (!shiftRectangle.intersectsWith(rect).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void shift(Integer x, Integer y) {
        this.shiftX = x;
        this.shiftY = y;
    }

    public void addClipRectangle(StiRectangle clipRectangle) {
        if (clipRectangle != null) {
            clipRectangle.setLeft((double)StiMath.roundDown((Double)clipRectangle.getLeft()));
            clipRectangle.setTop((double)StiMath.roundDown((Double)clipRectangle.getTop()));
            clipRectangle.setRight((double)StiMath.roundUp((Double)clipRectangle.getRight()));
            clipRectangle.setBottom((double)StiMath.roundUp((Double)clipRectangle.getBottom()));
            this.clipRectangles.add(clipRectangle);
        }
    }

    public void addClipRectangles(List<StiRectangle> clipRectangles) {
        for (StiRectangle clipRectangle : clipRectangles) {
            this.addClipRectangle(clipRectangle);
        }
    }

    public List<StiRectangle> getClipRectangles() {
        return this.clipRectangles;
    }

    public StiGraphics getG() {
        return this.g;
    }

    public Boolean getDrawTopmostBorderSides() {
        return this.drawTopmostBorderSides;
    }

    public void setDrawTopmostBorderSides(Boolean drawTopmostBorderSides) {
        this.drawTopmostBorderSides = drawTopmostBorderSides;
    }

    public Boolean getSegmentPrint() {
        return this.segmentX >= 0 || this.segmentY >= 0;
    }

    public Integer getSegmentX() {
        return this.segmentX;
    }

    public Integer getSegmentY() {
        return this.segmentY;
    }

    public Boolean isThumbPaint() {
        return this.thumbPaint;
    }

    public StiRectangle getPaintRect() {
        return this.paintRect;
    }

    public void setPaintRect(StiRectangle paintRect) {
        this.paintRect = paintRect;
    }
}

