/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.maps.gis.StiGisMapHelper;
import com.stimulsoft.report.maps.gis.StiGisMapImage;
import com.stimulsoft.report.maps.gis.StiGisPoint;
import com.stimulsoft.report.maps.gis.StiGisProjection;
import com.stimulsoft.report.maps.gis.StiGisRectLatLng;
import com.stimulsoft.report.maps.gis.StiMercatorGisProjection;
import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;

public final class StiOpenStreetMapProvider {
    private static final String urlFormatEn = "https://%s.tile.openstreetmap.org/%s/%s/%s.png";
    public static final String ServerLetters = "abc";
    public String languageStr = "en";
    public StiGisRectLatLng area = null;
    public static int timeoutMs = 5000;
    public String refererUrl = "";
    public String copyright = "\u00a9 OpenStreetMap";
    private boolean isInitialized;

    public int getMaxZoom() {
        return 18;
    }

    public final int getMinZoom() {
        return 1;
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public final void setInitialized(boolean value) {
        this.isInitialized = value;
    }

    protected final StiGisMapImage getTileImageUsingHttp(String urlStr) {
        StiGisMapImage ret = null;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31");
            BufferedImage bi = ImageIO.read(connection.getInputStream());
            ret = StiGisMapImage.fromBufferedImage(bi);
            if (ret != null) {
                ret.data = new byte[1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    protected static int getServerNum(StiGisPoint pos, int max) {
        return (pos.getX() + 2 * pos.getY()) % max;
    }

    public StiGisProjection getProjection() {
        return StiMercatorGisProjection.instance();
    }

    public StiGisMapImage getTileImage(StiGisPoint pos, int zoom) {
        String url = this.makeTileImageUrl(pos, zoom);
        return this.getTileImageUsingHttp(url);
    }

    private String makeTileImageUrl(StiGisPoint pos, int zoom) {
        if (!StiValidationUtil.isNullOrEmpty((String)StiGisMapHelper.customOpenStreetMapUrl)) {
            return String.format(StiGisMapHelper.customOpenStreetMapUrl, zoom, pos.getX(), pos.getY());
        }
        char letter = ServerLetters.charAt(StiOpenStreetMapProvider.getServerNum(pos, 3));
        return String.format(urlFormatEn, Character.valueOf(letter), zoom, pos.getX(), pos.getY());
    }
}

