/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.maps.gis.StiGisMapImage;
import com.stimulsoft.report.maps.gis.StiGisPoint;

public final class StiGisTile {
    public boolean notEmpty;
    public StiGisMapImage image;
    private int zoom;
    private StiGisPoint pos = new StiGisPoint();

    public StiGisTile() {
    }

    public StiGisTile(int zoom, StiGisPoint pos) {
        this.notEmpty = true;
        this.zoom = zoom;
        this.setPos(pos.clone());
        this.image = null;
    }

    public static StiGisTile empty() {
        return new StiGisTile();
    }

    public int getZoom() {
        return this.zoom;
    }

    public StiGisPoint getPos() {
        return this.pos;
    }

    public void setPos(StiGisPoint value) {
        this.pos = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StiGisTile)) {
            return false;
        }
        StiGisTile comp = (StiGisTile)obj;
        return comp.getZoom() == this.getZoom() && StiValidationUtil.equals((Object)comp.getPos(), (Object)this.getPos());
    }

    public int hashCode() {
        return this.getZoom() ^ this.getPos().hashCode();
    }

    public void Dispose() {
        if (this.image != null) {
            this.image.close();
        }
        this.image = null;
    }

    public static boolean opEquals(StiGisTile m1, StiGisTile m2) {
        return StiValidationUtil.equals((Object)m1.getPos(), (Object)m2.getPos()) && m1.getZoom() == m2.getZoom();
    }

    public static boolean opNotEquals(StiGisTile m1, StiGisTile m2) {
        return !StiGisTile.opEquals(m1, m2);
    }

    public StiGisTile clone() {
        StiGisTile varCopy = new StiGisTile();
        varCopy.notEmpty = this.notEmpty;
        varCopy.image = this.image;
        varCopy.zoom = this.zoom;
        varCopy.pos = this.pos.clone();
        return varCopy;
    }
}

