/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.report.maps.gis.StiGisPoint;
import com.stimulsoft.report.maps.gis.StiGisSize;

public final class StiGisRect {
    public static final StiGisRect empty = new StiGisRect();
    private int x;
    private int y;
    private int width;
    private int height;

    public StiGisRect() {
    }

    public StiGisRect(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public StiGisRect(StiGisPoint location, StiGisSize size) {
        this.setX(location.getX());
        this.setY(location.getY());
        this.setWidth(size.getWidth());
        this.setHeight(size.getHeight());
    }

    public StiGisPoint getLocation() {
        return new StiGisPoint(this.getX(), this.getY());
    }

    public void setLocation(StiGisPoint value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public StiGisPoint getRightBottom() {
        return new StiGisPoint(this.getRight(), this.getBottom());
    }

    public StiGisPoint getRightTop() {
        return new StiGisPoint(this.getRight(), this.getTop());
    }

    public StiGisPoint getLeftBottom() {
        return new StiGisPoint(this.getLeft(), this.getBottom());
    }

    public StiGisSize getSize() {
        return new StiGisSize(this.getWidth(), this.getHeight());
    }

    public void setSize(StiGisSize value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    public int getX() {
        return this.x;
    }

    public void setX(int value) {
        this.x = value;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int value) {
        this.y = value;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int value) {
        this.width = value;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int value) {
        this.height = value;
    }

    public int getLeft() {
        return this.getX();
    }

    public int getTop() {
        return this.getY();
    }

    public int getRight() {
        return this.getX() + this.getWidth();
    }

    public int getBottom() {
        return this.getY() + this.getHeight();
    }

    public boolean isEmpty() {
        return this.getHeight() == 0 && this.getWidth() == 0 && this.getX() == 0 && this.getY() == 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StiGisRect)) {
            return false;
        }
        StiGisRect comp = (StiGisRect)obj;
        return comp.getX() == this.getX() && comp.getY() == this.getY() && comp.getWidth() == this.getWidth() && comp.getHeight() == this.getHeight();
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.getX() ^ (this.getY() << 13 | this.getY() >> 19) ^ (this.getWidth() << 26 | this.getWidth() >> 6) ^ (this.getHeight() << 7 | this.getHeight() >> 25);
    }

    public String toString() {
        return String.format("X=%1$s, Y=%2$s, Width=%3$s, Height=%4$s", this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public static boolean opEquals(StiGisRect left, StiGisRect right) {
        return left.getX() == right.getX() && left.getY() == right.getY() && left.getWidth() == right.getWidth() && left.getHeight() == right.getHeight();
    }

    public static boolean opNotEquals(StiGisRect left, StiGisRect right) {
        return !StiGisRect.opEquals(left, right);
    }

    public boolean contains(int x, int y) {
        return this.getX() <= x && x < this.getX() + this.getWidth() && this.getY() <= y && y < this.getY() + this.getHeight();
    }

    public boolean contains(StiGisPoint pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public boolean contains(StiGisRect rect) {
        return this.getX() <= rect.getX() && rect.getX() + rect.getWidth() <= this.getX() + this.getWidth() && this.getY() <= rect.getY() && rect.getY() + rect.getHeight() <= this.getY() + this.getHeight();
    }

    public void inflate(int width, int height) {
        this.setX(this.getX() - width);
        this.setY(this.getY() - height);
        this.setWidth(this.getWidth() + 2 * width);
        this.setHeight(this.getHeight() + 2 * height);
    }

    public void offsetNegative(StiGisPoint pos) {
        this.offset(-pos.getX(), -pos.getY());
    }

    public void offset(int x, int y) {
        this.setX(this.getX() + x);
        this.setY(this.getY() + y);
    }
}

