/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.report.maps.gis.StiGisPoint;
import com.stimulsoft.report.maps.gis.StiGisPointLatLng;
import com.stimulsoft.report.maps.gis.StiGisSize;

public abstract class StiGisProjection {
    protected static final double HALF_PI = 1.5707963267948966;
    protected static final double TWO_PI = Math.PI * 2;
    protected static final double EPSLoN = 1.0E-10;
    protected static final double MAX_VAL = 4.0;
    protected static final double MAXLONG = 2.147483647E9;
    protected static final double DBLLONG = 4.61168601E18;
    protected static final double R2D = 57.29577951308232;
    protected static final double D2R = Math.PI / 180;
    private final int tileSize = this.getTileValue();

    protected StiGisProjection() {
    }

    protected int getTileValue() {
        return 256;
    }

    public final int getTileSize() {
        return this.tileSize;
    }

    public abstract StiGisPoint fromLatLngToPixel(double var1, double var3, int var5);

    public abstract StiGisPointLatLng fromPixelToLatLng(int var1, int var2, int var3);

    public final StiGisPoint fromLatLngToPixel(StiGisPointLatLng p, int zoom) {
        return this.fromLatLngToPixel(p.getLat(), p.getLng(), zoom);
    }

    public final StiGisPointLatLng fromPixelToLatLng(StiGisPoint p, int zoom) {
        return this.fromPixelToLatLng(p.getX(), p.getY(), zoom);
    }

    public StiGisPoint fromPixelToTileXY(StiGisPoint p) {
        return new StiGisPoint(p.getX() / this.getTileSize(), p.getY() / this.getTileSize());
    }

    public StiGisSize getTileMatrixSizeXY(int zoom) {
        StiGisSize sMin = this.getTileMatrixMinXY(zoom);
        StiGisSize sMax = this.getTileMatrixMaxXY(zoom);
        return new StiGisSize(sMax.getWidth() - sMin.getWidth() + 1, sMax.getHeight() - sMin.getHeight() + 1);
    }

    public StiGisSize getTileMatrixSizePixel(int zoom) {
        StiGisSize s = this.getTileMatrixSizeXY(zoom);
        return new StiGisSize(s.getWidth() * this.getTileSize(), s.getHeight() * this.getTileSize());
    }

    public abstract StiGisSize getTileMatrixMinXY(int var1);

    public abstract StiGisSize getTileMatrixMaxXY(int var1);

    protected static double clip(double n, double minValue, double maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }
}

