/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.tick.linear.label;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.events.StiGetValueEvent;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.collections.StiCustomValuesCollection;
import com.stimulsoft.report.infographics.gauge.expressions.StiTextExpression;
import com.stimulsoft.report.infographics.gauge.expressions.StiValueExpression;
import com.stimulsoft.report.infographics.gauge.helpers.StiRectangleHelper;
import com.stimulsoft.report.infographics.gauge.interfaces.IStiTickCustom;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiLinearTickLabelBase;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.tick.StiCustomValueBase;
import com.stimulsoft.report.infographics.gauge.tick.linear.label.StiLinearTickLabelCustomValue;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiLinearTickLabelCustom
extends StiLinearTickLabelBase
implements IStiTickCustom {
    private double valueObj = 0.0;
    private String textObj = null;
    private StiCustomValuesCollection values = new StiCustomValuesCollection();
    private StiGetValueEvent getValueEvent = new StiGetValueEvent();
    private StiValueExpression value = new StiValueExpression();
    private StiTextExpression text = new StiTextExpression();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyJObject("GetValueEvent", this.getValueEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("value", this.value.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Text", this.text.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Values", this.values.SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("GetValueEvent".equals(property.Name)) {
                StiGetValueEvent _getValueEvent = new StiGetValueEvent();
                _getValueEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getValueEvent = _getValueEvent;
                continue;
            }
            if ("GetTextEvent".equals(property.Name)) continue;
            if ("value".equals(property.Name)) {
                StiValueExpression _valueObj = new StiValueExpression();
                _valueObj.LoadFromJsonObject((JSONObject)property.Value);
                this.setValue(_valueObj);
                continue;
            }
            if ("Text".equals(property.Name)) {
                StiTextExpression _textObj = new StiTextExpression();
                _textObj.LoadFromJsonObject((JSONObject)property.Value);
                this.text = _textObj;
                continue;
            }
            if (!"Values".equals(property.Name)) continue;
            this.values.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiLinearTickLabelCustom;
    }

    @Override
    public Object clone() {
        StiLinearTickLabelCustom label = (StiLinearTickLabelCustom)super.clone();
        label.value = this.value != null ? (StiValueExpression)this.value.clone() : null;
        label.text = this.text != null ? (StiTextExpression)this.text.clone() : null;
        label.values = new StiCustomValuesCollection();
        label.textObj = this.textObj;
        label.valueObj = this.valueObj;
        for (StiCustomValueBase customValue : this.values) {
            label.values.add((StiCustomValueBase)customValue.clone());
        }
        return label;
    }

    @Override
    @StiSerializable
    public double getValueObj() {
        return this.valueObj;
    }

    @Override
    public void setValueObj(double valueObj) {
        this.valueObj = valueObj;
    }

    @StiSerializable
    public String getTextObj() {
        return this.textObj;
    }

    public void setTextObj(String textObj) {
        this.textObj = textObj;
    }

    @Override
    @StiSerializable
    public StiCustomValuesCollection getValues() {
        return this.values;
    }

    @Override
    public void setValues(StiCustomValuesCollection values) {
        this.values = values;
    }

    @Override
    public String getLocalizeName() {
        return "LinearTickLabelCustom";
    }

    @StiSerializable
    public StiGetValueEvent getGetValueEvent() {
        return this.getValueEvent;
    }

    public void setGetValueEvent(StiGetValueEvent getValueEvent) {
        this.getValueEvent = getValueEvent;
    }

    @StiSerializable
    public StiValueExpression getValue() {
        return this.value;
    }

    public void setValue(StiValueExpression value) {
        this.value = value;
    }

    @StiSerializable
    public StiTextExpression getText() {
        return this.text;
    }

    public void setText(StiTextExpression text) {
        this.text = text;
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiLinearTickLabelCustom();
    }

    @Override
    public void prepareGaugeElement() {
        super.prepareGaugeElement();
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiLinearScale linearScale;
        StiLinearScale stiLinearScale = linearScale = this.scale instanceof StiLinearScale ? (StiLinearScale)this.scale : null;
        if (linearScale == null || StiValidationUtil.isNullOrEmpty((String)this.getTextObj())) {
            return;
        }
        StiSize size = linearScale.barGeometry.getSize();
        StiRectangle rect = linearScale.barGeometry.getRectGeometry();
        double rest = this.scale.barGeometry.getRestToLenght();
        double scaleOffset = linearScale.getOrientation() == StiOrientation.Horizontal ? size.height : size.width;
        scaleOffset *= super.getOffset();
        double startValue = this.scale.scaleHelper.ActualMinimum;
        double endValue = this.scale.scaleHelper.ActualMaximum;
        String textFormat = super.getTextFormat();
        double[] skipValues = super.getSkipValuesObj();
        double[] skipIndices = super.getSkipIndicesObj();
        StiCustomValuesCollection values = this.values;
        if (values == null || values.size() == 0) {
            values = new StiCustomValuesCollection();
            values.add(new StiLinearTickLabelCustomValue(this.valueObj, this.textObj, this.getOffset(), this.getPlacement()));
        }
        int index = -1;
        for (StiCustomValueBase kk : values) {
            double restValue;
            double top;
            double left;
            double offset;
            StiLinearTickLabelCustomValue key = (StiLinearTickLabelCustomValue)kk;
            if (key.value < startValue || key.value > endValue || this.checkTickValue(skipValues, skipIndices, key.value, ++index) || this.getMinimumValue() != null && key.value < this.getMinimumValue() || this.getMaximumValue() != null && key.value > this.getMaximumValue()) continue;
            double actualScaleOffset = scaleOffset * this.getOffset(key.getOffset());
            double position = linearScale.getPosition(key.value);
            String text = this.getTextForRender(key.getText(), textFormat);
            StiFont zoomFont = StiGaugeContextPainter.changeFontSize(this.getFont(), context.zoom);
            StiSize textSize = context.measureString(text, zoomFont);
            if (linearScale.getOrientation() == StiOrientation.Horizontal) {
                double d = offset = linearScale.getIsReversed() ? rect.width - rect.width * position : rect.width * position;
                if (this.getPlacement(key.getPlacement()) == StiPlacement.Overlay) {
                    left = rect.getLeft() + offset - textSize.width / 2.0;
                    top = StiRectangleHelper.centerY(rect) - textSize.height / 2.0 - actualScaleOffset;
                } else {
                    double d2 = restValue = linearScale.getStartWidth() < linearScale.getEndWidth() ? (1.0 - position) * rest : rest * position;
                    if (this.getPlacement(key.getPlacement()) == StiPlacement.Outside) {
                        left = rect.getLeft() + offset - textSize.width / 2.0;
                        top = rect.getTop() - textSize.height - actualScaleOffset + restValue;
                    } else {
                        left = rect.getLeft() + offset - textSize.width / 2.0;
                        top = rect.getBottom() + actualScaleOffset - restValue;
                    }
                }
            } else {
                double d = offset = linearScale.getIsReversed() ? rect.height * position : rect.height - rect.height * position;
                if (this.getPlacement(key.getPlacement()) == StiPlacement.Overlay) {
                    left = StiRectangleHelper.centerX(rect) - textSize.width / 2.0;
                    top = rect.getTop() + offset - textSize.height / 2.0;
                } else {
                    double d3 = restValue = linearScale.getStartWidth() < linearScale.getEndWidth() ? (1.0 - position) * rest : rest * position;
                    if (this.getPlacement(key.getPlacement()) == StiPlacement.Outside) {
                        left = rect.getLeft() - textSize.width - 3.0 - actualScaleOffset + restValue;
                        top = rect.getTop() + offset - textSize.height / 2.0;
                    } else {
                        left = rect.getRight() + 3.0 + actualScaleOffset - restValue;
                        top = rect.getTop() + offset - textSize.height / 2.0;
                    }
                }
            }
            context.addTextGaugeGeom(text, zoomFont, this.getTextBrush(), new StiRectangle(new StiPoint(left, top), textSize), null);
        }
    }
}

