/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.skins.needleindicator;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StringFormat;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.infographics.gauge.indicators.StiNeedle;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;

public class StiNeedleIndicator3Skin
extends StiGaugeElementSkin {
    @Override
    public void draw(StiGaugeContextPainter context, StiGaugeElement element, StiRectangle rect, Double angle, StiPoint centerPoint) {
        boolean rotate;
        StiPoint[] points;
        StiNeedle indicator = (StiNeedle)element;
        double minumum = Math.min(rect.width, rect.height);
        double value = minumum * (double)0.6f;
        StiRectangle arrayRect = new StiRectangle(rect.getLeft() + minumum / 2.0, rect.getTop() + (rect.height - value) / 2.0, rect.width - minumum / 2.0, value);
        StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom(arrayRect, arrayRect.getLocation(), indicator.getBrush(), indicator.getBorderBrush(), indicator.getBorderWidth());
        double offsetX = arrayRect.width * (double)0.111f;
        double offsetY = arrayRect.height * (double)0.15f;
        points = new StiPoint[]{arrayRect.getLocation(), new StiPoint(arrayRect.getRight() - offsetX, arrayRect.getTop() + offsetY), new StiPoint(arrayRect.getRight(), arrayRect.getTop() + arrayRect.height / 2.0), new StiPoint(arrayRect.getRight() - offsetX, arrayRect.getBottom() - offsetY), new StiPoint(arrayRect.getLeft(), arrayRect.getBottom()), points[0]};
        pathGeom.addGraphicsPathLinesGaugeGeom(points);
        boolean bl = rotate = angle != null && centerPoint != null;
        if (rotate) {
            context.addPushMatrixGaugeGeom(angle, centerPoint.getValue());
        }
        context.addGraphicsPathGaugeGeom(pathGeom);
        StiRectangle ellipseRect = new StiRectangle(rect.getLocation(), new StiSize(minumum, minumum));
        StiGradientBrush ellipseBrush = new StiGradientBrush(StiColor.fromArgb((int)230, (int)229, (int)229), StiColor.fromArgb((int)80, (int)80, (int)80), 45.0);
        StiSolidBrush borderBrush = new StiSolidBrush(StiColor.fromArgb((int)98, (int)94, (int)90));
        context.addEllipseGaugeGeom(ellipseRect, (StiBrush)ellipseBrush, (StiBrush)borderBrush, 1.5);
        if (rotate) {
            context.addPopTranformGaugeGeom();
        }
        if (element.getAnimation() != null) {
            pathGeom.setAnimation(element.getAnimation());
        }
        if (indicator.isShowValue()) {
            StringFormat sf = new StringFormat();
            sf.Alignment = StiStringAlignment.Center;
            sf.LineAlignment = StiStringAlignment.Center;
            sf.FormatFlags = StiEnumSet.of((Enum)StiStringFormatFlags.NoWrap);
            StiFont zoomFont = StiGaugeContextPainter.changeFontSize(indicator.getFont(), context.zoom);
            context.addTextGaugeGeom(StiStringUtil.format((String)indicator.getFormat(), (Object[])new Object[]{indicator.getValueObj()}), zoomFont, indicator.getTextBrush(), ellipseRect, sf);
        }
    }
}

