/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.tick;

import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.gauge.helpers.StiTickLabelHelper;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.helpers.StiRectangleHelper;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiTickLabelBase;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import java.util.Map;
import java.util.TreeMap;

public abstract class StiLinearTickLabelBase
extends StiTickLabelBase {
    @Override
    public void drawElement(StiGaugeContextPainter context) {
        double scaleOffset;
        double distance;
        boolean isUp;
        StiLinearScale linearScale;
        StiLinearScale stiLinearScale = linearScale = this.getScale() instanceof StiLinearScale ? (StiLinearScale)this.scale : null;
        if (linearScale == null) {
            return;
        }
        StiSize size = linearScale.barGeometry.getSize();
        StiRectangle rect = linearScale.barGeometry.getRectGeometry();
        if (size.width == 0.0 || size.height == 0.0) {
            return;
        }
        TreeMap<Double, Double> collection = this.getPointCollection();
        if (collection.size() == 0) {
            return;
        }
        Map<Double, String> collectionPrepare = StiTickLabelHelper.getLabels(collection);
        String textFormat = this.getTextFormat();
        double[] skipValues = super.getSkipValuesObj();
        double[] skipIndices = super.getSkipIndicesObj();
        double startValue = this.scale.scaleHelper.ActualMinimum;
        double endValue = this.scale.scaleHelper.ActualMaximum;
        boolean bl = isUp = linearScale.getStartWidth() < linearScale.getEndWidth();
        if (linearScale.getOrientation() == StiOrientation.Horizontal) {
            distance = rect.width;
            scaleOffset = size.height;
        } else {
            distance = rect.height;
            scaleOffset = size.width;
        }
        double rest = linearScale.barGeometry.getRestToLenght();
        scaleOffset *= super.getOffset();
        int index = -1;
        for (Double key : collection.keySet()) {
            double restValue;
            double top;
            double left;
            if (key < startValue || key > endValue || this.checkTickValue(skipValues, skipIndices, key, ++index) || this.getMinimumValue() != null && key < this.getMinimumValue() || this.getMaximumValue() != null && key > this.getMaximumValue()) continue;
            String text = StiValidationUtil.isNullOrEmpty((String)textFormat) && this.scale.gauge.isShortValue() ? collectionPrepare.get(key) : this.getTextForRender(key, textFormat);
            StiFont zoomFont = StiGaugeContextPainter.changeFontSize(this.getFont(), context.zoom);
            StiSize textSize = context.measureString(text, zoomFont);
            double offsetByValue = collection.get(key) * distance;
            if (linearScale.getOrientation() == StiOrientation.Horizontal) {
                double d = left = linearScale.getIsReversed() ? rect.getRight() - offsetByValue - textSize.width / 2.0 : rect.getLeft() + offsetByValue - textSize.width / 2.0;
                if (this.getPlacement() == StiPlacement.Overlay) {
                    top = StiRectangleHelper.centerY(rect) - textSize.height / 2.0 - scaleOffset;
                } else {
                    double d2 = restValue = isUp ? (1.0 - collection.get(key)) * rest : rest * collection.get(key);
                    top = this.getPlacement() == StiPlacement.Outside ? rect.getTop() - textSize.height - scaleOffset + restValue : rect.getBottom() + scaleOffset - restValue;
                }
            } else {
                double d = top = linearScale.getIsReversed() ? rect.getTop() + offsetByValue - textSize.height / 2.0 : rect.getBottom() - offsetByValue - textSize.height / 2.0;
                if (this.getPlacement() == StiPlacement.Overlay) {
                    left = StiRectangleHelper.centerX(rect) - textSize.width / 2.0 - scaleOffset;
                } else {
                    restValue = isUp ? (1.0 - collection.get(key)) * rest : rest * collection.get(key);
                    left = this.getPlacement() == StiPlacement.Outside ? rect.getLeft() - textSize.width - 3.0 - scaleOffset + restValue : rect.getRight() + scaleOffset + 3.0 - restValue;
                }
            }
            context.addTextGaugeGeom(text, zoomFont, this.getTextBrush(), new StiRectangle(new StiPoint(left, top), textSize), null);
        }
    }
}

