/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.scalebargeometry;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.StiRadiusMode;
import com.stimulsoft.report.infographics.gauge.interfaces.IStiScaleBarGeometry;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLinesGaugeGeom;

public class StiRadialBarGeometry
implements IStiScaleBarGeometry {
    private final StiRadialScale scale;
    private StiSize size = new StiSize(0, 0);
    private StiRectangle rectGeometry;
    private double radius = 0.0;
    private double diameter = 0.0;
    private StiPoint center = new StiPoint(0.0, 0.0);

    @Override
    public StiSize getSize() {
        return this.size;
    }

    @Override
    public StiRectangle getRectGeometry() {
        return this.rectGeometry;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public double getDiameter() {
        return this.diameter;
    }

    @Override
    public StiPoint getCenter() {
        return this.center;
    }

    @Override
    public void checkRectGeometry(StiRectangle rect) {
        this.size = rect.getSize();
        StiPoint centerPoint = this.scale.getCenter();
        centerPoint = new StiPoint(rect.x + this.size.width * centerPoint.x, rect.y + this.size.height * centerPoint.y);
        double width = 0.0;
        double height = 0.0;
        if (this.scale.getRadiusMode() == StiRadiusMode.Auto) {
            height = width = Math.min(this.size.width, this.size.height) * this.scale.GetRadius();
            this.diameter = width;
            this.radius = width / 2.0;
        } else if (this.scale.getRadiusMode() == StiRadiusMode.Width) {
            width = this.size.width * this.scale.GetRadius();
            height = this.size.height;
            this.diameter = width;
            this.radius = width / 2.0;
        } else {
            width = this.size.width;
            this.diameter = height = this.size.height * this.scale.GetRadius();
            this.radius = height / 2.0;
        }
        this.rectGeometry = new StiRectangle(centerPoint.x - width / 2.0, centerPoint.y - height / 2.0, width, height);
        this.center = new StiPoint(this.rectGeometry.getLeft() + this.rectGeometry.width / 2.0, this.rectGeometry.getTop() + this.rectGeometry.height / 2.0);
    }

    @Override
    public void drawScaleGeometry(StiGaugeContextPainter context) {
        double endWidth;
        double startWidth;
        if (this.scale.getIsReversed()) {
            startWidth = this.scale.GetEndWidth();
            endWidth = this.scale.GetStartWidth();
        } else {
            startWidth = this.scale.GetStartWidth();
            endWidth = this.scale.GetEndWidth();
        }
        if (this.rectGeometry.width > 0.0 && this.rectGeometry.height > 0.0) {
            context.addGraphicsArcGeometryGaugeGeom(this.rectGeometry, this.scale.getBrush(), this.scale.getBorderBrush(), 1.0, this.scale.getStartAngle(), this.scale.GetSweepAngle(), startWidth, endWidth);
        }
    }

    @Override
    public double getRestToLenght() {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public StiGraphicsPathLinesGaugeGeom drawGeometry(StiGaugeContextPainter context, double StartValue, double EndValue, double StartWidth, double EndWidth, double Offset, StiPlacement Placement, StiRefObject<StiRectangle> rect, boolean returnOnlyRect) {
        throw new RuntimeException("NotImplemented");
    }

    public StiRadialBarGeometry(StiRadialScale scale) {
        this.rectGeometry = StiRectangle.empty();
        this.scale = scale;
    }
}

