/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.indicators;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.events.StiGetValueEvent;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.expressions.StiValueExpression;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import java.util.logging.Logger;

public abstract class StiIndicatorBase
extends StiGaugeElement {
    private static final Logger LOGGER = Logger.getLogger("com.stimulsoft.report.infographics.gauge.primitives.indicators.StiIndicatorBase");
    private double valueObj = 0.0;
    private StiPlacement placement = StiPlacement.Overlay;
    private StiBrush brush = new StiSolidBrush(StiColorEnum.White.color());
    private StiBrush borderBrush = new StiEmptyBrush();
    private double borderWidth = 0.0;
    private StiGetValueEvent getValueEvent = new StiGetValueEvent();
    private StiValueExpression value = new StiValueExpression();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("Placement", (Enum)this.getPlacement());
        jObject.AddPropertyStringNullOfEmpty("BorderBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBorderBrush()));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyFloat("BorderWidth", this.getBorderWidth(), 0.0);
        jObject.AddPropertyJObject("GetValueEvent", this.getValueEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Value", this.value.SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Placement".equals(property.Name)) {
                this.setPlacement(StiPlacement.valueOf((String)property.Value));
                continue;
            }
            if ("BorderBrush".equals(property.Name)) {
                this.setBorderBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("Brush".equals(property.Name)) {
                this.setBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("GetValueEvent".equals(property.Name)) {
                StiGetValueEvent _getValueEvent = new StiGetValueEvent();
                _getValueEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetValueEvent(_getValueEvent);
                continue;
            }
            if (!"Value".equals(property.Name)) continue;
            StiValueExpression _valueObj = new StiValueExpression();
            _valueObj.LoadFromJsonObject((JSONObject)property.Value);
            this.setValue(_valueObj);
        }
    }

    @Override
    public Object clone() {
        StiIndicatorBase indicator = (StiIndicatorBase)super.clone();
        indicator.brush = (StiBrush)this.brush.clone();
        indicator.borderBrush = (StiBrush)this.borderBrush.clone();
        indicator.borderWidth = this.borderWidth;
        indicator.placement = this.placement;
        indicator.valueObj = this.valueObj;
        indicator.value = this.value != null ? (StiValueExpression)this.value.clone() : null;
        return indicator;
    }

    @StiSerializable
    public double getValueObj() {
        return this.valueObj;
    }

    public void setValueObj(double valueObj) {
        this.valueObj = valueObj;
        this.onValueChanged();
    }

    @StiSerializable
    public StiPlacement getPlacement() {
        return this.placement;
    }

    public void setPlacement(StiPlacement placement) {
        this.placement = placement;
    }

    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    @StiSerializable
    public StiBrush getBorderBrush() {
        return this.borderBrush;
    }

    public void setBorderBrush(StiBrush borderBrush) {
        this.borderBrush = borderBrush;
    }

    @StiSerializable
    public double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
    }

    protected void OnGetValue(StiGetValueEventArgs e) {
    }

    public void InvokeGetValue(StiGaugeElement sender, StiGetValueEventArgs e) {
        try {
            this.OnGetValue(e);
            Object parserResult = StiParser.ParseTextValue(this.value.getValue(), sender.getScale().getGauge());
            e.setValue(sender.getScale().getGauge().getReport().ToString(parserResult));
        }
        catch (Exception ex) {
            String str = String.format("Expression in GetValue property of '%s' series from '%s' chart can't be evaluated!", "Indicator", this.getScale().getGauge().getName());
            LOGGER.warning(str);
            LOGGER.warning(ex.getMessage());
            this.getScale().getGauge().getReport().WriteToReportRenderingMessages(str);
        }
    }

    @StiSerializable
    public StiGetValueEvent getGetValueEvent() {
        return this.getValueEvent;
    }

    public void setGetValueEvent(StiGetValueEvent getValueEvent) {
        this.getValueEvent = getValueEvent;
    }

    @StiSerializable
    public StiValueExpression getValue() {
        return this.value;
    }

    public void setValue(StiValueExpression value) {
        this.value = value;
    }

    @Override
    public void prepareGaugeElement() {
        StiGetValueEventArgs e = new StiGetValueEventArgs();
        this.InvokeGetValue(this, e);
        this.setValueObj(StiGaugeHelper.getFloatValueFromObject((Object)e.getValue(), this.scale));
    }

    protected abstract void interactiveClick(StiRectangle var1, StiPoint var2);

    protected void onValueChanged() {
    }

    public Double getActualValue() {
        if (this.getScale() == null || this.getScale().getGauge() == null) {
            return null;
        }
        try {
            if (this.getScale().getGauge().isDesigning()) {
                Object obj;
                Object object = obj = this.getValue().getValue().startsWith("{") ? StiParser.ParseTextValue(this.getValue().getValue(), this.getScale().getGauge()) : StiParser.ParseTextValue("{" + this.getValue().getValue() + "}", this.getScale().getGauge());
                if (obj == null) {
                    return 0.0;
                }
                if (obj instanceof String) {
                    Double result = Double.parseDouble(((String)obj).trim());
                    return result;
                }
                return Func.Convert.toSingle(obj);
            }
            return this.valueObj;
        }
        catch (Exception e) {
            return 0.0;
        }
    }
}

