/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.indicators;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.StiBarRangeListType;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.helpers.StiMathHelper;
import com.stimulsoft.report.infographics.gauge.indicators.StiRadialIndicatorRangeInfo;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiBarBase;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiRadialBar
extends StiBarBase {
    private StiBrush actualBush = new StiEmptyBrush();
    private RadialColorModeHelper colorModeHelper = new RadialColorModeHelper();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiRadialBar;
    }

    @Override
    public void applyStyle(IStiGaugeStyle style) {
        if (this.isAllowApplyStyle()) {
            this.setBrush(style.getCore().getRadialBarBrush());
            this.setBorderBrush(style.getCore().getRadialBarBorderBrush());
            this.setEmptyBrush(style.getCore().getRadialBarEmptyBrush());
            this.setEmptyBorderBrush(style.getCore().getRadialBarEmptyBorderBrush());
            this.setStartWidth(style.getCore().getRadialBarStartWidth());
            this.setEndWidth(style.getCore().getRadialBarEndWidth());
            this.checkActualBrushForTopGeometry();
        }
    }

    @Override
    public StiGaugeElemenType getElementType() {
        return StiGaugeElemenType.RadialElement;
    }

    @Override
    protected StiBarRangeListType getBarType() {
        return StiBarRangeListType.RadialBar;
    }

    @Override
    public String getLocalizeName() {
        return "RadialBar";
    }

    @Override
    protected void checkActualBrushForTopGeometry() {
        if (this.isUseRangeColor()) {
            for (int index = this.getRangeList().size() - 1; index >= 0; --index) {
                StiRadialIndicatorRangeInfo info = (StiRadialIndicatorRangeInfo)this.getRangeList().get(index);
                if (!(this.getValueObj() >= info.getValue())) continue;
                if (this.colorModeHelper.defaultIndex != index) {
                    this.colorModeHelper.defaultIndex = index;
                    this.actualBush = info.getBrush();
                }
                break;
            }
        } else {
            this.colorModeHelper.standardBackground = true;
            this.actualBush = this.getBrush();
        }
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiRadialBar();
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        double actualValue;
        StiRadialScale radialScale = this.scale instanceof StiRadialScale ? (StiRadialScale)this.scale : null;
        Double nullValue = this.getActualValue();
        double d = actualValue = nullValue == null ? this.scale.getMinimum() : nullValue.doubleValue();
        if (context.gauge.isDesigning()) {
            this.checkActualBrushForTopGeometry();
        }
        if (radialScale != null) {
            double to;
            double from;
            if (this.scale.getIsReversed()) {
                from = this.scale.getMaximum() - actualValue;
                to = this.scale.getMaximum();
            } else {
                from = this.scale.getMinimum();
                to = actualValue;
            }
            this.GetRangeGeometry(context, radialScale, this.getEmptyBrush(), this.getEmptyBorderBrush(), this.getEmptyBorderWidth(), this.scale.getMinimum(), this.scale.getMaximum());
            this.GetRangeGeometry(context, radialScale, this.actualBush, this.getBorderBrush(), this.getBorderWidth(), from, to);
        }
    }

    @Override
    protected void onRangeColorChanged() {
        this.colorModeHelper.reset();
    }

    @Override
    public void interactiveClick(StiRectangle rect, StiPoint p) {
    }

    private void GetRangeGeometry(StiGaugeContextPainter context, StiRadialScale scale, StiBrush bg, StiBrush bb, double bw, double startValue, double endValue) {
        double radius4;
        double radius3;
        double radius2;
        double radius1;
        StiRectangle rect = scale.barGeometry.getRectGeometry();
        StiPoint centerPoint = scale.barGeometry.getCenter();
        double radius = scale.barGeometry.getRadius();
        double diameter = scale.barGeometry.getDiameter();
        double startWidth = this.getStartWidth() >= 0.0 ? (scale.getIsReversed() ? this.getEndWidth() * diameter : this.getStartWidth() * diameter) : 0.0;
        double endWidth = this.getEndWidth() >= 0.0 ? (scale.getIsReversed() ? this.getStartWidth() * diameter : this.getEndWidth() * diameter) : 0.0;
        double startAngle = scale.getStartAngle() + scale.getPosition(startValue) * scale.getSweepAngle();
        double endAngle = (scale.getPosition(endValue) - scale.getPosition(startValue)) * scale.getSweepAngle();
        double scaleStartWidth = scale.getIsReversed() ? scale.getEndWidth() * diameter : scale.getStartWidth() * diameter;
        double scaleEndWidth = scale.getIsReversed() ? scale.getStartWidth() * diameter : scale.getEndWidth() * diameter;
        double value1 = scale.getPosition(startValue);
        double value2 = scale.getPosition(endValue);
        double scaleRest = StiMathHelper.maxMinusMin(scaleStartWidth, scaleEndWidth);
        if (this.getPlacement() == StiPlacement.Outside) {
            radius1 = radius;
            radius2 = radius;
            radius3 = radius + startWidth;
            radius4 = radius + endWidth;
        } else if (this.getPlacement() == StiPlacement.Overlay) {
            if (scale.isUp()) {
                radius1 = radius - (scaleStartWidth + scaleRest * value1 - startWidth) / 2.0;
                radius2 = radius - (scaleStartWidth + scaleRest * value2 - endWidth) / 2.0;
                radius3 = radius - (scaleStartWidth + scaleRest * value1 + startWidth) / 2.0;
                radius4 = radius - (scaleStartWidth + scaleRest * value2 + endWidth) / 2.0;
            } else {
                radius1 = radius - (scaleStartWidth - scaleRest * value1 - startWidth) / 2.0;
                radius2 = radius - (scaleStartWidth - scaleRest * value2 - endWidth) / 2.0;
                radius3 = radius - (scaleStartWidth - scaleRest * value1 + startWidth) / 2.0;
                radius4 = radius - (scaleStartWidth - scaleRest * value2 + endWidth) / 2.0;
            }
        } else if (scale.isUp()) {
            radius1 = radius - (scaleStartWidth + scaleRest * value1);
            radius2 = radius - (scaleStartWidth + scaleRest * value2);
            radius3 = radius - (scaleStartWidth + scaleRest * value1 + startWidth);
            radius4 = radius - (scaleStartWidth + scaleRest * value2 + endWidth);
        } else {
            radius1 = radius - (scaleStartWidth - scaleRest * value1);
            radius2 = radius - (scaleStartWidth - scaleRest * value2);
            radius3 = radius - (scaleStartWidth - scaleRest * value1 + startWidth);
            radius4 = radius - (scaleStartWidth - scaleRest * value2 + endWidth);
        }
        if (Double.isNaN(radius1) || Double.isNaN(radius2) || Double.isNaN(radius3) || Double.isNaN(radius4)) {
            return;
        }
        double maxRadius = StiMathHelper.getMax(new double[]{radius1, radius2, radius3, radius4});
        StiRectangle finalRect = new StiRectangle(centerPoint.x - maxRadius, centerPoint.y - maxRadius, maxRadius * 2.0, maxRadius * 2.0);
        context.addRadialRangeGaugeGeom(finalRect, bg, bb, bw, centerPoint, startAngle, endAngle, radius1, radius2, radius3, radius4);
    }

    private class RadialColorModeHelper {
        public boolean standardBackground = false;
        public int defaultIndex = -99;

        private RadialColorModeHelper() {
        }

        public void reset() {
            this.standardBackground = false;
            this.defaultIndex = -99;
        }
    }
}

