/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.indicators;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiTranslationAnimation;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiMathHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiRectangleHelper;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiMarkerBase;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiLinearMarker
extends StiMarkerBase {
    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiLinearMarker;
    }

    @Override
    public void applyStyle(IStiGaugeStyle style) {
        if (this.isAllowApplyStyle()) {
            this.setBrush(style.getCore().getMarkerBrush());
            this.setBorderBrush(style.getCore().getMarkerBorderBrush());
            this.setBorderWidth(style.getCore().getMarkerBorderWidth());
            this.setSkin(style.getCore().getMarkerSkin());
        }
    }

    @Override
    public String getLocalizeName() {
        return "LinearMarker";
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiLinearMarker();
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiRectangle rect = this.getRectangle(this.getValueObj());
        StiRectangle rectZero = this.getRectangle(0.0);
        this.setAnimation((StiAnimation)new StiTranslationAnimation(new StiPoint(rectZero.x, rectZero.y), new StiPoint(rect.x, rect.y), Integer.valueOf(StiGaugeHelper.GlobalDurationElement), Integer.valueOf(StiGaugeHelper.GlobalBeginTimeElement)));
        StiGaugeElementSkin skin = this.getActualSkin();
        skin.draw(context, this, rect);
    }

    private StiRectangle getRectangle(double value) {
        StiLinearScale linearScale = this.scale instanceof StiLinearScale ? (StiLinearScale)this.scale : null;
        StiSize size = linearScale.barGeometry.getSize();
        StiRectangle barRect = linearScale.barGeometry.getRectGeometry();
        double offset = this.getBarPosition(linearScale.getOrientation(), value);
        double actualWidth = size.width * this.getRelativeWidth();
        double actualHeight = size.height * this.getRelativeHeight();
        double heightDiv2 = actualHeight / 2.0;
        double x = 0.0;
        double y = 0.0;
        if (linearScale.getOrientation() == StiOrientation.Horizontal) {
            if (this.getPlacement() != StiPlacement.Overlay) {
                double rest = this.scale.barGeometry.getRestToLenght();
                double position = this.scale.getPosition(value);
                double restValue = this.scale.getStartWidth() < this.scale.getEndWidth() ? (1.0 - position) * rest : rest * position;
                y = this.getPlacement() == StiPlacement.Outside ? barRect.getTop() - actualHeight + restValue : barRect.getBottom() - restValue;
            } else {
                y = StiRectangleHelper.centerY(this.scale.barGeometry.getRectGeometry()) - heightDiv2 + this.getOffset() * size.height;
            }
            x = this.scale.getIsReversed() ? barRect.getRight() - (offset += heightDiv2) : barRect.getLeft() + (offset -= heightDiv2);
        } else {
            if (this.getPlacement() != StiPlacement.Overlay) {
                double rest = this.scale.barGeometry.getRestToLenght();
                double position = this.scale.getPosition(value);
                double restValue = this.scale.getStartWidth() < this.scale.getEndWidth() ? (1.0 - position) * rest : rest * position;
                x = this.getPlacement() == StiPlacement.Outside ? barRect.getLeft() - actualWidth + restValue : barRect.getRight() - restValue;
            } else {
                x = StiRectangleHelper.centerX(this.scale.barGeometry.getRectGeometry()) - actualWidth / 2.0 + this.getOffset() * size.width;
            }
            y = this.scale.getIsReversed() ? barRect.getTop() + (offset -= heightDiv2) : barRect.getBottom() - (offset += heightDiv2);
        }
        return new StiRectangle(x, y, actualWidth, actualHeight);
    }

    @Override
    public void interactiveClick(StiRectangle rect, StiPoint p) {
    }

    private double getBarPosition(StiOrientation orientation, double value) {
        double minimum = this.scale.scaleHelper.ActualMinimum;
        double maximum = this.scale.scaleHelper.ActualMaximum;
        if (Double.isNaN(value)) {
            value = minimum;
        } else if (value < minimum) {
            value = minimum;
        } else if (value > maximum) {
            value = maximum;
        }
        double distance = StiMathHelper.length(minimum, value);
        double width = orientation == StiOrientation.Horizontal ? this.scale.barGeometry.getRectGeometry().width : this.scale.barGeometry.getRectGeometry().height;
        return distance / this.scale.scaleHelper.getTotalLength() * width;
    }
}

