/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiInteraction;
import com.stimulsoft.report.components.StiTextFormatState;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.components.textFormats.StiNumberFormatService;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.infographics.gauge.StiGaugeCalculationMode;
import com.stimulsoft.report.infographics.gauge.StiGaugeType;
import com.stimulsoft.report.infographics.gauge.StiScaleMode;
import com.stimulsoft.report.infographics.gauge.collections.StiScaleCollection;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.infographics.gauge.styles.view.StiCustomGaugeStyle;
import com.stimulsoft.report.infographics.gauge.styles.view.StiGaugeStyleXF26;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.StiPainter;
import com.stimulsoft.report.styles.StiGaugeStyle;
import java.awt.image.BufferedImage;

public class StiGauge
extends StiComponent
implements IStiExportImageExtended,
IStiBorder,
IStiBrush {
    private StiBorder border = new StiBorder();
    private StiBrush brush = new StiSolidBrush(StiColorEnum.Transparent.color());
    public boolean shortValue = true;
    private String customStyleName = "";
    private StiScaleCollection scales = new StiScaleCollection(this);
    public StiGaugeContextPainter painter;
    private boolean isAnimation = false;
    private double minimum;
    private double maximum = 100.0;
    private StiGaugeType type = StiGaugeType.FullCircular;
    private StiGaugeCalculationMode calculationMode = StiGaugeCalculationMode.Auto;
    private boolean allowApplyStyle = true;
    private StiScaleMode mode = StiScaleMode.V2;
    private IStiGaugeStyle style = new StiGaugeStyleXF26();
    public StiFormatService valueFormat = StiGauge.getValueFormatDefault();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("ComponentStyle");
        jObject.RemoveProperty("UseParentStyles");
        jObject.RemoveProperty("CanGrow");
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("GrowToHeight");
        jObject.RemoveProperty("Interaction");
        jObject.RemoveProperty("IsAnimation");
        jObject.AddPropertyBool("ShortValue", this.shortValue, true);
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.border));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyJObject("Scales", this.scales.SaveToJsonObject(mode));
        jObject.AddPropertyDouble("Minimum", this.getMinimum(), 0.0);
        jObject.AddPropertyDouble("Maximum", this.maximum, 100.0);
        jObject.AddPropertyStringNullOrEmpty("CustomStyleName", this.getCustomStyleName());
        jObject.AddPropertyEnum("Type", (Enum)this.getType(), (Enum)StiGaugeType.FullCircular);
        jObject.AddPropertyEnum("CalculationMode", (Enum)this.getCalculationMode(), (Enum)StiGaugeCalculationMode.Auto);
        jObject.AddPropertyEnum("Mode", (Enum)this.getMode(), (Enum)StiScaleMode.V2);
        jObject.AddPropertyBool("AllowApplyStyle", this.isAllowApplyStyle(), true);
        jObject.AddPropertyJObject("Style", this.getStyle().SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Border".equals(property.Name)) {
                this.setBorder(StiJsonReportObjectHelper.Deserialize.Border((JProperty)property));
                continue;
            }
            if ("Brush".equals(property.Name)) {
                this.setBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("Scales".equals(property.Name)) {
                this.scales.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if ("ShortValue".equals(property.Name)) {
                this.shortValue = (Boolean)property.Value;
                continue;
            }
            if ("Minimum".equals(property.Name)) {
                this.setMinimum((Double)property.Value);
                continue;
            }
            if ("Maximum".equals(property.Name)) {
                this.setMaximum((Double)property.Value);
                continue;
            }
            if ("CustomStyleName".equals(property.Name)) {
                this.setCustomStyleName((String)property.Value);
                continue;
            }
            if ("Type".equals(property.Name)) {
                this.setType(StiGaugeType.valueOf((String)property.Value));
                continue;
            }
            if ("CalculationMode".equals(property.Name)) {
                this.setCalculationMode(StiGaugeCalculationMode.valueOf((String)property.Value));
                continue;
            }
            if ("Mode".equals(property.Name)) {
                this.setMode(StiScaleMode.valueOf((String)property.Value));
                continue;
            }
            if ("AllowApplyStyle".equals(property.Name)) {
                this.setAllowApplyStyle((Boolean)property.Value);
                continue;
            }
            if (!"Style".equals(property.Name)) continue;
            this.getStyle().LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public IStiGaugeStyle getGaugeStyle() {
        StiGaugeStyle style;
        if (!StiValidationUtil.isNullOrEmpty((String)this.getCustomStyleName()) && this.getReport() != null && (style = (StiGaugeStyle)this.getReport().getStyles().stream().filter(x -> StiValidationUtil.equals((Object)x.getName(), (Object)this.getCustomStyleName())).findFirst().orElseGet(null)) != null) {
            return new StiCustomGaugeStyle(style);
        }
        return this.getStyle();
    }

    private static StiFormatService getValueFormatDefault() {
        StiNumberFormatService service = new StiNumberFormatService();
        service.setDecimalDigits(0);
        service.setState((StiEnumSet<StiTextFormatState>)StiEnumSet.of((Enum)StiTextFormatState.DecimalDigits, (Enum)StiTextFormatState.Abbreviation));
        return service;
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiGauge;
    }

    @StiSerializable
    public StiScaleMode getMode() {
        return this.mode;
    }

    public void setMode(StiScaleMode mode) {
        this.mode = mode;
    }

    @StiSerializable
    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    @StiSerializable
    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    @StiSerializable
    public StiGaugeType getType() {
        return this.type;
    }

    public void setType(StiGaugeType type) {
        this.type = type;
    }

    @StiSerializable
    public StiGaugeCalculationMode getCalculationMode() {
        return this.calculationMode;
    }

    public void setCalculationMode(StiGaugeCalculationMode calculationMode) {
        this.calculationMode = calculationMode;
    }

    @StiSerializable
    public boolean isAllowApplyStyle() {
        return this.allowApplyStyle;
    }

    public void setAllowApplyStyle(boolean allowApplyStyle) {
        this.allowApplyStyle = allowApplyStyle;
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiGauge gauge = (StiGauge)super.clone(cloneProperties);
        gauge.scales = new StiScaleCollection(gauge);
        for (StiScaleBase scale : this.scales) {
            gauge.scales.add((StiScaleBase)scale.clone());
        }
        gauge.allowApplyStyle = this.allowApplyStyle;
        gauge.border = (StiBorder)this.border.clone();
        gauge.brush = (StiBrush)this.brush.clone();
        gauge.calculationMode = this.calculationMode;
        gauge.customStyleName = this.customStyleName;
        gauge.isAnimation = this.isAnimation;
        gauge.maximum = this.maximum;
        gauge.minimum = this.minimum;
        gauge.mode = this.mode;
        gauge.style = this.style;
        gauge.type = this.type;
        return gauge;
    }

    public BufferedImage getImage(double zoom) {
        return this.getImage(zoom, StiExportFormat.None);
    }

    public BufferedImage getImage(double zoom, StiExportFormat format) {
        StiPainter painter = StiPainter.getPainter(this);
        return painter.getImage(this, zoom, format);
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return true;
    }

    @Override
    @StiSerializable
    public StiBorder getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(StiBorder border) {
        this.border = border;
    }

    @Override
    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    @StiSerializable
    public boolean isShortValue() {
        return this.shortValue;
    }

    public void setShortValue(boolean shortValue) {
        this.shortValue = shortValue;
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Infographics");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiGauge");
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 240L, 240L);
    }

    @Override
    public String getComponentStyle() {
        return super.getComponentStyle();
    }

    @Override
    public boolean getUseParentStyles() {
        return super.getUseParentStyles();
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public boolean getGrowToHeight() {
        return super.getGrowToHeight();
    }

    @Override
    public StiInteraction getInteraction() {
        return super.getInteraction();
    }

    @StiSerializable
    public IStiGaugeStyle getStyle() {
        return this.style;
    }

    public void setStyle(IStiGaugeStyle value) {
        if (this.style != value) {
            this.style = value;
            if (value != null) {
                value.getCore().setGauge(this);
            }
        }
    }

    @StiSerializable
    public String getCustomStyleName() {
        return this.customStyleName;
    }

    public void setCustomStyleName(String customStyleName) {
        this.customStyleName = customStyleName;
    }

    @StiSerializable
    public StiScaleCollection getScales() {
        return this.scales;
    }

    public void setScales(StiScaleCollection scales) {
        this.scales = scales;
        scales.setParent(this);
    }

    public boolean getIsAnimation() {
        return this.isAnimation;
    }

    public void setIsAnimation(boolean value) {
        this.isAnimation = value;
    }

    private void changeSkin() {
    }

    public void drawGauge(StiGaugeContextPainter context) {
        this.applyStyle(this.getStyle());
        int index = -1;
        while (++index < this.getScales().size()) {
            StiScaleBase scale = (StiScaleBase)this.getScales().get(index);
            if (scale == null) continue;
            scale.barGeometry.checkRectGeometry(context.rect);
            scale.drawElement(context);
        }
    }

    public StiComponent createNew() {
        return new StiGauge();
    }

    public void applyStyle(IStiGaugeStyle style) {
        this.brush = style.getCore().getBrush();
        this.border.setColor(style.getCore().getBorderColor());
        this.border.setSize((double)style.getCore().getBorderWidth());
        for (StiScaleBase scale : this.scales) {
            scale.applyStyle(style);
        }
    }

    public StiGauge() {
        this(StiRectangle.getEmpty());
    }

    public StiGauge(StiRectangle rect) {
        this.scales = new StiScaleCollection(this);
        this.setPlaceOnToolbox(false);
    }
}

